/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileFolderSelectionDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceSelectionValidator;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseCssInThemeDialog
extends BaseTitleAreaDialog {
    protected final Logger logger = Logger.getLogger(UseCssInThemeDialog.class.getName());
    private static final String DIALOG_TITLE = Messages.getString((String)"UseCssInReportDialog.Wizard.Title");
    private static final String TITLE_AREA_TITLE = Messages.getString((String)"UseCssInThemeDialog.TitleArea.Title");
    private static final String TITLE_AREA_MESSAGE = Messages.getString((String)"UseCssInThemeDialog.TitleArea.Message");
    private static final String DIALOG_BROWSE = Messages.getString((String)"UseCssInReportDialog.Dialog.Browse");
    private static final String DIALOG_BROWSE_TITLE = Messages.getString((String)"UseCssInReportDialog.Dialog.Browse.Library.Title");
    private static final String DIALOG_LABEL_NOFILE = Messages.getString((String)"UseCssInReportDialog.Label.No.File");
    private String dialogTitle = DIALOG_TITLE;
    private String areaTitle = TITLE_AREA_TITLE;
    private String areaMsg = TITLE_AREA_MESSAGE;
    private Text fileNameField;
    private Label title;
    private Table stylesTable;
    private Table notificationsTable;
    private Combo themeCombo;
    private Map<String, SharedStyleHandle> styleMap = new HashMap<String, SharedStyleHandle>();
    private List<String> styleNames = new ArrayList<String>();
    private List<String> unSupportedStyleNames = new ArrayList<String>();
    private int themeIndex = -1;
    private String uri;
    private IncludedCssStyleSheetHandle includedCssHandle;
    private Button viewTimeBtn;
    private Text uriText;
    private CssStyleSheetHandle cssHandle;
    private String fileName;

    public void setDialogTitle(String dlgTitle) {
        this.dialogTitle = dlgTitle;
    }

    public void setTitle(String title) {
        this.areaTitle = title;
        super.setTitle(this.areaTitle);
    }

    public void setMsg(String msg) {
        this.areaMsg = msg;
    }

    public UseCssInThemeDialog() {
        super(UIUtil.getDefaultShell());
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ThemeHandle getTheme() {
        if (this.themeIndex > -1) {
            return this.getThemes().get(this.themeIndex);
        }
        return null;
    }

    public void setTheme(ThemeHandle theme) {
        this.themeIndex = this.getThemes().indexOf(theme);
    }

    protected void okPressed() {
        this.themeIndex = this.themeCombo.getSelectionIndex();
        this.uri = this.uriText.isEnabled() ? this.uriText.getText().trim() : "";
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite topComposite = (Composite)super.createDialogArea(parent);
        topComposite.setLayout((Layout)new GridLayout());
        this.createFileNameComposite(topComposite);
        this.createStyleComposite(topComposite);
        this.initializeContents();
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.UseCssInReportDialog_ID");
        this.setTitle(this.areaTitle);
        this.setMessage(this.areaMsg);
        return topComposite;
    }

    protected void initializeContents() {
        if (this.fileName != null) {
            this.fileNameField.setText(this.fileName);
        }
        if (this.viewTimeBtn.isEnabled() && this.viewTimeBtn.getSelection()) {
            this.uriText.setEnabled(true);
        } else {
            this.uriText.setEnabled(false);
        }
        if (this.includedCssHandle == null) {
            return;
        }
        this.fileName = this.includedCssHandle.getFileName();
        this.uri = this.includedCssHandle.getExternalCssURI();
        if (this.fileName != null && this.fileName.trim().length() > 0) {
            this.fileNameField.setText(this.fileName);
        }
        if (this.uri != null && this.uri.trim().length() > 0) {
            this.viewTimeBtn.setSelection(true);
            this.uriText.setEnabled(true);
            this.uriText.setText(this.uri);
        } else {
            this.viewTimeBtn.setSelection(false);
            this.uriText.setEnabled(false);
        }
        this.refresh();
    }

    private void createStyleComposite(Composite parent) {
        Composite styleComposite = new Composite(parent, 0);
        styleComposite.setLayout((Layout)new GridLayout());
        styleComposite.setLayoutData((Object)new GridData(1808));
        this.title = new Label(styleComposite, 0);
        GridData data = new GridData(768);
        this.title.setLayoutData((Object)data);
        this.title.setText(DIALOG_LABEL_NOFILE);
        this.stylesTable = new Table(styleComposite, 67588);
        data = new GridData(1808);
        data.minimumHeight = 100;
        this.stylesTable.setLayoutData((Object)data);
        new Label(styleComposite, 0).setText(Messages.getString((String)"UseCssInReportDialog.Label.notifications"));
        this.notificationsTable = new Table(styleComposite, 67588);
        data = new GridData(1808);
        data.minimumHeight = 60;
        this.notificationsTable.setLayoutData((Object)data);
    }

    private void createFileNameComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        nameComposite.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        nameComposite.setLayoutData((Object)gd);
        Label title = new Label(nameComposite, 0);
        title.setText(Messages.getString((String)"UseCssInReportDialog.Wizard.Filename"));
        this.fileNameField = new Text(nameComposite, 2056);
        this.fileNameField.setLayoutData((Object)new GridData(768));
        this.fileNameField.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                UseCssInThemeDialog.this.fileName = UseCssInThemeDialog.this.fileNameField.getText().trim();
                try {
                    UseCssInThemeDialog.this.cssHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(UseCssInThemeDialog.this.fileName);
                }
                catch (StyleSheetException e1) {
                    UseCssInThemeDialog.this.logger.log(Level.SEVERE, e1.getMessage(), e1);
                }
                UseCssInThemeDialog.this.themeCombo.removeAll();
                UseCssInThemeDialog.this.refresh();
            }
        });
        this.fileNameField.setLayoutData((Object)gd);
        Button selectButton = new Button(nameComposite, 8);
        selectButton.setText(Messages.getString((String)"WizardSelectCssStylePage.button.label.browse"));
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String sourceFileName;
                ResourceFileFolderSelectionDialog dialog = new ResourceFileFolderSelectionDialog(true, new String[]{"*.css", "*.CSS"});
                dialog.setTitle(DIALOG_BROWSE);
                dialog.setMessage(DIALOG_BROWSE_TITLE);
                ResourceSelectionValidator validator = new ResourceSelectionValidator(new String[]{".css", ".CSS"});
                dialog.setValidator(validator);
                if (dialog.open() == 0 && (sourceFileName = dialog.getPath()) != null) {
                    UseCssInThemeDialog.this.fileNameField.setText(sourceFileName);
                }
            }
        });
        Label theme = new Label(nameComposite, 0);
        theme.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Label.Theme.Text"));
        this.themeCombo = new Combo(nameComposite, 8);
        this.themeCombo.setLayoutData((Object)new GridData(768));
        this.themeCombo.setVisibleItemCount(30);
        this.themeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UseCssInThemeDialog.this.refresh();
            }
        });
        new Label(nameComposite, 0);
        new Label(nameComposite, 0);
        this.viewTimeBtn = new Button(nameComposite, 32);
        this.viewTimeBtn.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Button.viewTimeBtn.Text"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.viewTimeBtn.setLayoutData((Object)gd);
        this.viewTimeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = UseCssInThemeDialog.this.viewTimeBtn.getSelection();
                UseCssInThemeDialog.this.uriText.setEnabled(selected);
            }
        });
        new Label(nameComposite, 0);
        Label viewTimeLb = new Label(nameComposite, 0);
        viewTimeLb.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Label.viewTimeLb"));
        viewTimeLb.setLayoutData((Object)gd);
        Label uri = new Label(nameComposite, 0);
        uri.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Text.uri"));
        uri.setLayoutData((Object)new GridData(128));
        this.uriText = new Text(nameComposite, 2048);
        this.uriText.setLayoutData((Object)gd);
        new Label(nameComposite, 0);
        Label example = new Label(nameComposite, 0);
        example.setText(Messages.getString((String)"UseCssInReportDialog.Dialog.Label.example"));
        example.setLayoutData((Object)gd);
    }

    private void refresh() {
        TableItem item;
        String sn;
        this.styleMap.clear();
        this.styleNames.clear();
        this.unSupportedStyleNames.clear();
        String fileName = null;
        TableItem[] ch = this.stylesTable.getItems();
        int i = 0;
        while (i < ch.length) {
            ch[i].dispose();
            ++i;
        }
        ch = this.notificationsTable.getItems();
        i = 0;
        while (i < ch.length) {
            ch[i].dispose();
            ++i;
        }
        this.title.setText(DIALOG_LABEL_NOFILE);
        this.updateThemes();
        fileName = this.fileNameField.getText().trim();
        if (fileName.length() == 0) {
            this.updateOKButton();
            return;
        }
        try {
            this.cssHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(fileName.trim());
        }
        catch (StyleSheetException styleSheetException) {
            this.updateOKButton();
            return;
        }
        if (this.cssHandle == null) {
            this.updateOKButton();
            return;
        }
        this.title.setText(Messages.getFormattedString((String)"UseCssInReportDialog.Label.Styles", (Object[])new String[]{fileName}));
        Iterator styleIter = this.cssHandle.getStyleIterator();
        while (styleIter.hasNext()) {
            SharedStyleHandle styleHandle = (SharedStyleHandle)styleIter.next();
            this.styleMap.put(styleHandle.getName(), styleHandle);
            this.styleNames.add(styleHandle.getName());
        }
        List unSupportedStyles = this.cssHandle.getUnsupportedStyles();
        for (String name : unSupportedStyles) {
            this.unSupportedStyleNames.add(String.valueOf(name) + Messages.getString((String)"WizardSelectCssStylePage.text.cannot.import.style"));
        }
        int i2 = 0;
        while (i2 < this.styleNames.size()) {
            sn = this.styleNames.get(i2);
            item = new TableItem(this.stylesTable, 0);
            item.setText(sn);
            item.setImage(ReportPlatformUIImages.getImage("Style"));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.unSupportedStyleNames.size()) {
            sn = this.unSupportedStyleNames.get(i2);
            item = new TableItem(this.notificationsTable, 0);
            item.setText(sn);
            item.setImage(ReportPlatformUIImages.getImage("Style"));
            ++i2;
        }
        this.updateOKButton();
    }

    private void updateThemes() {
        if (this.themeCombo == null) {
            return;
        }
        if (this.themeCombo.getItemCount() == 0) {
            List<ThemeHandle> themeList = this.getThemes();
            int i = 0;
            while (i < themeList.size()) {
                String displayName = themeList.get(i).getName();
                this.themeCombo.add(displayName);
                ++i;
            }
            if (this.themeCombo.getItemCount() > 0) {
                if (this.themeIndex > -1 && this.themeIndex < this.themeCombo.getItemCount()) {
                    this.themeCombo.select(this.themeIndex);
                } else {
                    this.themeCombo.select(0);
                }
            } else {
                this.themeCombo.select(-1);
            }
        }
    }

    private void updateOKButton() {
        this.updateThemes();
        this.themeIndex = this.themeCombo.getSelectionIndex();
        ThemeHandle theme = this.getTheme();
        if (this.getButton(0) != null) {
            if (!(this.fileName == null || this.includedCssHandle != null && this.fileName.equals(this.includedCssHandle.getFileName()) || theme == null || theme.canAddCssStyleSheet(this.fileName))) {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(Messages.getFormattedString((String)"UseCssInReportDialog.Error.Already.Include", (Object[])new String[]{this.fileName}));
            } else if (this.styleNames.size() != 0) {
                this.getButton(0).setEnabled(true);
                this.setErrorMessage(null);
            } else {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(null);
            }
        }
    }

    private List<ThemeHandle> getThemes() {
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (!(module instanceof LibraryHandle)) {
            return Collections.emptyList();
        }
        LibraryHandle libraryHandle = (LibraryHandle)module;
        SlotHandle slotHandle = libraryHandle.getThemes();
        ArrayList<ThemeHandle> list = new ArrayList<ThemeHandle>();
        Iterator iter = slotHandle.iterator();
        while (iter.hasNext()) {
            list.add((ThemeHandle)iter.next());
        }
        return list;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateOKButton();
    }

    public String getURI() {
        return this.uri;
    }

    public void setIncludedCssStyleSheetHandle(IncludedCssStyleSheetHandle handle) {
        this.includedCssHandle = handle;
    }
}

