/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.parameters.IParameter;
import org.eclipse.birt.report.designer.ui.parameters.ScalarParameter;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public abstract class ListingParameter
extends ScalarParameter {
    public ListingParameter(ScalarParameterHandle handle, IEngineTask engineTask) {
        super(handle, engineTask);
    }

    public List getValueList() {
        List values = new ArrayList();
        boolean isCascading = this.isCascadingParameter();
        String name = this.handle.getName();
        IGetParameterDefinitionTask task = this.engineTask.getEngine().createGetParameterDefinitionTask((IRunnable)this.engineTask.getReportRunnable());
        if (isCascading) {
            values = this.getCascadingValues(values, task);
        } else {
            List selectionList = (List)task.getSelectionList(name);
            values.addAll(selectionList);
        }
        return values;
    }

    private List getCascadingValues(List values, IGetParameterDefinitionTask task) {
        CascadingParameterGroupHandle container = (CascadingParameterGroupHandle)this.handle.getContainer();
        ArrayList<Object> groupList = new ArrayList<Object>();
        List children = this.group.getChildren();
        for (IParameter param : children) {
            if (param == this) break;
            try {
                groupList.add(param.converToDataType(param.getSelectionValue()));
            }
            catch (BirtException birtException) {}
        }
        Object[] groupKeys = new Object[groupList.size()];
        int i = 0;
        while (i < groupList.size()) {
            groupKeys[i] = groupList.get(i);
            ++i;
        }
        List cascading = (List)task.getSelectionListForCascadingGroup(container.getName(), groupKeys);
        if (cascading != null) {
            for (IParameterSelectionChoice choice : cascading) {
                values.add(choice.getValue());
            }
            return cascading;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isCascadingParameter() {
        DesignElementHandle container = this.handle.getContainer();
        return container != null && container instanceof CascadingParameterGroupHandle;
    }
}

