/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.reportitem.ChartReportItemPresentationBase;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.StyleHandle;

public final class ChartReportItemPresentationPlotImpl
extends ChartReportItemPresentationBase {
    protected Bounds computeBounds() throws ChartException {
        Bounds originalBounds = this.cm.getBlock().getBounds();
        Bounds bounds = originalBounds.copyInstance();
        try {
            AggregationCellHandle xtabCell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.modelHandle);
            if (xtabCell != null) {
                if (xtabCell.getSpanOverOnColumn() != null) {
                    double dWidth = ChartReportItemPresentationPlotImpl.getColumnCellWidth(xtabCell.getCrosstab(), this.dpi);
                    if (ChartUtil.mathEqual((double)dWidth, (double)0.0)) {
                        dWidth = ChartCubeUtil.DEFAULT_COLUMN_WIDTH.getMeasure();
                    }
                    StyleHandle style = xtabCell.getModelHandle().getPrivateStyle();
                    double dLeftBorder = ChartItemUtil.convertToPoints(style.getBorderLeftWidth(), this.dpi);
                    double dRightBorder = ChartItemUtil.convertToPoints(style.getBorderRightWidth(), this.dpi);
                    bounds.setWidth(-this.roundPointsWithPixels(dWidth + (dLeftBorder + dRightBorder) / 2.0));
                    double dHeight = ChartReportItemPresentationPlotImpl.getRowCellHeight(xtabCell.getCrosstab(), this.dpi);
                    if (!ChartUtil.mathEqual((double)dHeight, (double)0.0) && !ChartUtil.mathEqual((double)dHeight, (double)ChartCubeUtil.DEFAULT_ROW_HEIGHT.getMeasure())) {
                        bounds.setHeight(dHeight);
                    } else if (!bounds.isSetHeight() || ChartUtil.mathEqual((double)bounds.getHeight(), (double)0.0)) {
                        bounds.setHeight(ChartCubeUtil.DEFAULT_ROW_HEIGHT.getMeasure());
                    }
                } else if (xtabCell.getSpanOverOnRow() != null) {
                    double dHeight = ChartReportItemPresentationPlotImpl.getRowCellHeight(xtabCell.getCrosstab(), this.dpi);
                    if (ChartUtil.mathEqual((double)dHeight, (double)0.0)) {
                        dHeight = ChartCubeUtil.DEFAULT_ROW_HEIGHT.getMeasure();
                    }
                    StyleHandle style = xtabCell.getModelHandle().getPrivateStyle();
                    double dTopBorder = ChartItemUtil.convertToPoints(style.getBorderTopWidth(), this.dpi);
                    double dBottomBorder = ChartItemUtil.convertToPoints(style.getBorderBottomWidth(), this.dpi);
                    bounds.setHeight(-this.roundPointsWithPixels(dHeight + (dTopBorder + dBottomBorder) / 2.0));
                    double dWidth = ChartReportItemPresentationPlotImpl.getColumnCellWidth(xtabCell.getCrosstab(), this.dpi);
                    if (!ChartUtil.mathEqual((double)dWidth, (double)0.0) && !ChartUtil.mathEqual((double)dWidth, (double)ChartCubeUtil.DEFAULT_COLUMN_WIDTH.getMeasure())) {
                        bounds.setWidth(dWidth);
                    } else if (!bounds.isSetWidth() || ChartUtil.mathEqual((double)bounds.getWidth(), (double)0.0)) {
                        bounds.setWidth(ChartCubeUtil.DEFAULT_COLUMN_WIDTH.getMeasure());
                    }
                }
            }
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem", 3, (Throwable)e);
        }
        return bounds;
    }

    protected void updateChartModel() {
        super.updateChartModel();
        ChartCubeUtil.updateModelToRenderPlot(this.cm, this.rtc.isRightToLeft());
    }

    private double roundPointsWithPixels(double points) {
        return (double)((int)(points / 72.0 * (double)this.dpi) * 72) / (double)this.dpi;
    }

    static double getColumnCellWidth(CrosstabReportItemHandle xtabHandle, int dpi) throws BirtException {
        CrosstabCellHandle columnCell = ChartCubeUtil.getInnermostLevelCell(xtabHandle, 1);
        if (columnCell == null) {
            return 0.0;
        }
        return ChartItemUtil.convertToPoints(xtabHandle.getColumnWidth(columnCell), dpi);
    }

    static double getRowCellHeight(CrosstabReportItemHandle xtabHandle, int dpi) throws BirtException {
        CrosstabCellHandle rowCell = ChartCubeUtil.getInnermostLevelCell(xtabHandle, 0);
        if (rowCell == null) {
            return 0.0;
        }
        return ChartItemUtil.convertToPoints(xtabHandle.getRowHeight(rowCell), dpi);
    }
}

