/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.impl;

import org.eclipse.datatools.connectivity.oda.design.DataAccessDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignPackage;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionResponse;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.SessionStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class OdaDesignSessionImpl
extends EObjectImpl
implements OdaDesignSession {
    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    protected DesignSessionRequest m_request;
    protected DesignSessionResponse m_response;

    protected OdaDesignSessionImpl() {
    }

    protected EClass eStaticClass() {
        return DesignPackage.Literals.ODA_DESIGN_SESSION;
    }

    public void setNewRequest(DataSourceDesign dataSourceDesign) {
        DesignSessionRequest newRequest = DesignFactory.eINSTANCE.createDesignSessionRequest();
        newRequest.setNewDataAccessDesign(dataSourceDesign);
        this.setRequest(newRequest);
    }

    public void setNewRequest(DataSetDesign dataSetDesign) {
        DesignSessionRequest newRequest = DesignFactory.eINSTANCE.createDesignSessionRequest();
        newRequest.setNewDataAccessDesign(dataSetDesign);
        this.setRequest(newRequest);
    }

    public void setNewResponse(boolean isSessionOk, DataSourceDesign dataSourceDesign) {
        DesignSessionResponse newResponse = DesignFactory.eINSTANCE.createDesignSessionResponse();
        if (isSessionOk) {
            newResponse.setSessionStatus(SessionStatus.OK_LITERAL);
        } else {
            newResponse.setSessionStatus(SessionStatus.ERROR_LITERAL);
        }
        newResponse.setNewDataAccessDesign(dataSourceDesign);
        this.setResponse(newResponse);
    }

    public void setNewResponse(boolean isSessionOk, DataSetDesign dataSetDesign) {
        DesignSessionResponse newResponse = DesignFactory.eINSTANCE.createDesignSessionResponse();
        if (isSessionOk) {
            newResponse.setSessionStatus(SessionStatus.OK_LITERAL);
        } else {
            newResponse.setSessionStatus(SessionStatus.ERROR_LITERAL);
        }
        DataAccessDesign newDataAccess = DesignFactory.eINSTANCE.createDataAccessDesign();
        newDataAccess.setDataSetDesign(dataSetDesign);
        newResponse.setDataAccessDesign(newDataAccess);
        this.setResponse(newResponse);
    }

    public void setResponseInCancelledState() {
        DesignSessionResponse newResponse = DesignFactory.eINSTANCE.createDesignSessionResponse();
        newResponse.setSessionStatus(SessionStatus.USER_CANCELLED_LITERAL);
        this.setResponse(newResponse);
    }

    public DataSourceDesign getRequestDataSourceDesign() {
        if (this.getRequest() == null) {
            return null;
        }
        return this.getRequest().getDataSourceDesign();
    }

    public DataSetDesign getRequestDataSetDesign() {
        if (this.getRequest() == null) {
            return null;
        }
        return this.getRequest().getDataSetDesign();
    }

    public DataSourceDesign getResponseDataSourceDesign() {
        if (this.getResponse() == null) {
            return null;
        }
        return this.getResponse().getDataSourceDesign();
    }

    public DataSetDesign getResponseDataSetDesign() {
        if (this.getResponse() == null) {
            return null;
        }
        return this.getResponse().getDataSetDesign();
    }

    public DesignSessionRequest getRequest() {
        return this.m_request;
    }

    public NotificationChain basicSetRequest(DesignSessionRequest newRequest, NotificationChain msgs) {
        DesignSessionRequest oldRequest = this.m_request;
        this.m_request = newRequest;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldRequest, (Object)newRequest);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setRequest(DesignSessionRequest newRequest) {
        if (newRequest != this.m_request) {
            NotificationChain msgs = null;
            if (this.m_request != null) {
                msgs = ((InternalEObject)this.m_request).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newRequest != null) {
                msgs = ((InternalEObject)newRequest).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetRequest(newRequest, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newRequest, (Object)newRequest));
        }
    }

    public DesignSessionResponse getResponse() {
        return this.m_response;
    }

    public NotificationChain basicSetResponse(DesignSessionResponse newResponse, NotificationChain msgs) {
        DesignSessionResponse oldResponse = this.m_response;
        this.m_response = newResponse;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldResponse, (Object)newResponse);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setResponse(DesignSessionResponse newResponse) {
        if (newResponse != this.m_response) {
            NotificationChain msgs = null;
            if (this.m_response != null) {
                msgs = ((InternalEObject)this.m_response).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newResponse != null) {
                msgs = ((InternalEObject)newResponse).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetResponse(newResponse, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newResponse, (Object)newResponse));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetRequest(null, msgs);
            }
            case 1: {
                return this.basicSetResponse(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getRequest();
            }
            case 1: {
                return this.getResponse();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setRequest((DesignSessionRequest)newValue);
                return;
            }
            case 1: {
                this.setResponse((DesignSessionResponse)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setRequest(null);
                return;
            }
            case 1: {
                this.setResponse(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.m_request != null;
            }
            case 1: {
                return this.m_response != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

