/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.Statistics;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;

public class StatisticsImpl
implements Statistics,
Formatable {
    private long numRows;
    private long numUnique;

    public StatisticsImpl(long numRows, long numUnique) {
        this.numRows = numRows;
        this.numUnique = numUnique;
    }

    public StatisticsImpl() {
    }

    public double selectivity(Object[] predicates) {
        if ((double)this.numRows == 0.0) {
            return 0.1;
        }
        return 1.0 / (double)this.numUnique;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        FormatableHashtable fh = (FormatableHashtable)in.readObject();
        this.numRows = fh.getLong("numRows");
        this.numUnique = fh.getLong("numUnique");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        FormatableHashtable fh = new FormatableHashtable();
        fh.putLong("numRows", this.numRows);
        fh.putLong("numUnique", this.numUnique);
        out.writeObject(fh);
    }

    public int getTypeFormatId() {
        return 397;
    }

    public String toString() {
        return "numunique= " + this.numUnique + " numrows= " + this.numRows;
    }
}

