/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.AsciiStream;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClobLocatorOutputStream;
import org.apache.derby.client.am.ClobLocatorWriter;
import org.apache.derby.client.am.ClobOutputStream;
import org.apache.derby.client.am.ClobWriter;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UpdateSensitiveClobLocatorInputStream;
import org.apache.derby.client.am.UpdateSensitiveClobLocatorReader;
import org.apache.derby.client.net.EncodedInputStream;

public class Clob
extends Lob
implements java.sql.Clob {
    protected String string_ = null;
    protected InputStream asciiStream_ = null;
    protected InputStream unicodeStream_ = null;
    protected Reader characterStream_ = null;
    protected byte[] utf8String_;
    protected String encoding_ = "UNICODE";

    public Clob(Agent agent, String string) {
        this(agent, false);
        this.string_ = string;
        this.setSqlLength(this.string_.length());
        this.dataType_ |= 2;
    }

    public Clob(Agent agent, byte[] unconvertedBytes, String charsetName, int dataOffset) throws SqlException {
        this(agent, false);
        try {
            if (charsetName == null) {
                throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.2"));
            }
            this.string_ = new String(unconvertedBytes, dataOffset, unconvertedBytes.length - dataOffset, charsetName);
            this.setSqlLength(this.string_.length());
            this.dataType_ |= 2;
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"byte[]", (Object)(charsetName + " String"), (Throwable)e);
        }
    }

    public Clob(Agent agent, InputStream inputStream, String encoding, int length) throws SqlException {
        this(agent, false);
        this.setSqlLength(length);
        if (encoding.equals("ISO-8859-1")) {
            this.asciiStream_ = inputStream;
            this.dataType_ |= 4;
        } else if (encoding.equals("UTF-8")) {
            this.unicodeStream_ = inputStream;
            this.dataType_ |= 8;
        } else if (encoding.equals("UnicodeBigUnmarked")) {
            try {
                this.characterStream_ = new InputStreamReader(inputStream, "UnicodeBigUnmarked");
            }
            catch (UnsupportedEncodingException e) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"UnicodeBigUnmarked", (Object)"InputStreamReader", (Throwable)e);
            }
            this.dataType_ |= 0x10;
            this.setSqlLength(length / 2);
        }
    }

    public Clob(Agent agent, InputStream inputStream, String encoding) throws SqlException {
        this(agent, Clob.isLayerBStreamingPossible(agent));
        if (encoding.equals("ISO-8859-1")) {
            this.asciiStream_ = inputStream;
            this.dataType_ |= 4;
        } else {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)(encoding + " InputStream"), "String/Clob");
        }
    }

    public Clob(Agent agent, Reader reader, int length) {
        this(agent, false);
        this.setSqlLength(length);
        this.characterStream_ = reader;
        this.dataType_ |= 0x10;
    }

    public Clob(Agent agent, int locator) {
        super(agent, false);
        this.locator_ = locator;
        this.dataType_ |= 0x80;
    }

    public Clob(Agent agent, Reader reader) {
        this(agent, Clob.isLayerBStreamingPossible(agent));
        this.unicodeStream_ = EncodedInputStream.createUTF8Stream(reader);
        this.dataType_ |= 8;
    }

    private Clob(Agent agent, boolean willBeLayerBStreamed) {
        super(agent, willBeLayerBStreamed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "length");
                }
                long length = super.sqlLength();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "length", length);
                }
                return length;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long pos, int length) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                String retVal = null;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getSubString", (int)pos, length);
                }
                if (pos <= 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(pos));
                }
                if (length < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Integer(length));
                }
                if (pos > this.sqlLength() + 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), new Long(pos));
                }
                retVal = this.getSubStringX(pos, length);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getSubString", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private String getSubStringX(long pos, int length) throws SqlException {
        this.checkForClosedConnection();
        long actualLength = Math.min(this.sqlLength() - pos + 1L, (long)length);
        if (this.isLocator()) {
            return this.agent_.connection_.locatorProcedureCall().clobGetSubString(this.locator_, pos, (int)actualLength);
        }
        return this.string_.substring((int)pos - 1, (int)(pos - 1L + actualLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCharacterStream");
                }
                Reader retVal = this.getCharacterStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    Reader getCharacterStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isLocator()) {
            return new UpdateSensitiveClobLocatorReader(this.agent_.connection_, this);
        }
        if (this.isCharacterStream()) {
            return this.characterStream_;
        }
        return new StringReader(this.string_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream() throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getAsciiStream");
                }
                InputStream retVal = this.getAsciiStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getAsciiStream", retVal);
                }
                return retVal;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    InputStream getAsciiStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isAsciiStream()) {
            return this.asciiStream_;
        }
        if (this.isLocator()) {
            return new UpdateSensitiveClobLocatorInputStream(this.agent_.connection_, this);
        }
        return new AsciiStream(this.string_, new StringReader(this.string_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(String searchstr, long start) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "position(String, long)", (Object)searchstr, start);
                }
                if (searchstr == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"));
                }
                if (start < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(start));
                }
                long pos = this.positionX(searchstr, start);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(String, long)", pos);
                }
                return pos;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private long positionX(String searchstr, long start) throws SqlException {
        this.checkForClosedConnection();
        long index = -1L;
        if (start <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Long(start), (Object)"start", "Clob.position()");
        }
        if (this.isLocator()) {
            index = this.agent_.connection_.locatorProcedureCall().clobGetPositionFromString(this.locator_, searchstr, start);
        } else {
            index = this.string_.indexOf(searchstr, (int)start - 1);
            if (index != -1L) {
                ++index;
            }
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(java.sql.Clob searchstr, long start) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "position(Clob, long)", (Object)searchstr, start);
                }
                if (start < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(start));
                }
                if (searchstr == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"));
                }
                long pos = this.positionX(searchstr, start);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(Clob, long)", pos);
                }
                return pos;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private long positionX(java.sql.Clob searchstr, long start) throws SqlException {
        long index;
        this.checkForClosedConnection();
        if (start <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Long(start), (Object)"start", "Clob.position()");
        }
        try {
            if (searchstr.length() > this.sqlLength()) {
                return -1L;
            }
            if (this.isLocator()) {
                index = this.agent_.connection_.locatorProcedureCall().clobGetPositionFromLocator(this.locator_, ((Clob)searchstr).getLocator(), start);
            } else {
                index = this.string_.indexOf(searchstr.getSubString(1L, (int)searchstr.length()), (int)start - 1);
                if (index != -1L) {
                    ++index;
                }
            }
        }
        catch (SQLException e) {
            throw new SqlException(e);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long pos, String str) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setString", (int)pos, (Object)str);
                }
                int length = this.setStringX(pos, str, 0, str.length());
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setString", length);
                }
                return length;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setString", (int)pos, (Object)str, offset, len);
                }
                int length = this.setStringX(pos, str, offset, len);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setString", length);
                }
                return length;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int setStringX(long pos, String str, int offset, int len) throws SqlException {
        if ((int)pos <= 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(pos));
        }
        if (pos - 1L > this.sqlLength()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), new Long(pos));
        }
        if (offset < 0 || offset > str.length()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ078.S"), new Integer(offset));
        }
        if (len < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Integer(len));
        }
        if (len == 0) {
            return 0;
        }
        int length = 0;
        length = Math.min(str.length() - offset, len);
        if (this.isLocator()) {
            this.agent_.connection_.locatorProcedureCall().clobSetString(this.locator_, pos, length, str.substring(offset, offset + length));
            if (pos + (long)length - 1L > this.sqlLength()) {
                this.setSqlLength(pos + (long)length - 1L);
            }
            this.incrementUpdateCount();
        } else {
            String newString = this.string_.substring(0, (int)pos - 1);
            this.string_ = newString.concat(str.substring(offset, offset + length));
            this.asciiStream_ = new StringBufferInputStream(this.string_);
            this.unicodeStream_ = new StringBufferInputStream(this.string_);
            this.characterStream_ = new StringReader(this.string_);
            this.setSqlLength(this.string_.length());
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", (int)pos);
                }
                OutputStream outStream = null;
                outStream = this.isLocator() ? new ClobLocatorOutputStream(this.agent_.connection_, this, pos) : new ClobOutputStream(this, pos);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setAsciiStream", outStream);
                }
                return outStream;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer setCharacterStream(long pos) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", (int)pos);
                }
                Writer writer = null;
                writer = this.isLocator() ? new ClobLocatorWriter(this.agent_.connection_, this, pos) : new ClobWriter(this, pos);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setCharacterStream", writer);
                }
                return writer;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long len) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, " truncate", (int)len);
                }
                if (len < 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Long(len));
                }
                if (len > this.sqlLength()) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ079.S"), new Long(len));
                }
                if (len == this.sqlLength()) {
                    return;
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().clobTruncate(this.locator_, len);
                    this.incrementUpdateCount();
                    this.setSqlLength(len);
                } else {
                    String newstr;
                    this.string_ = newstr = this.string_.substring(0, (int)len);
                    this.asciiStream_ = new StringBufferInputStream(this.string_);
                    this.unicodeStream_ = new StringBufferInputStream(this.string_);
                    this.characterStream_ = new StringReader(this.string_);
                    this.setSqlLength(this.string_.length());
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() throws SQLException {
        if (!this.isValid_) {
            return;
        }
        this.isValid_ = false;
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "free");
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().clobReleaseLocator(this.locator_);
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.isString()) {
            this.string_ = null;
            this.utf8String_ = null;
        }
        if (this.isAsciiStream()) {
            try {
                this.asciiStream_.close();
            }
            catch (IOException ioe) {
                throw new SqlException(null, new ClientMessageId("XJ214.S")).getSQLException();
            }
        }
        if (this.isUnicodeStream()) {
            try {
                this.unicodeStream_.close();
            }
            catch (IOException ioe) {
                throw new SqlException(null, new ClientMessageId("XJ214.S")).getSQLException();
            }
        }
        if (this.isCharacterStream()) {
            try {
                this.characterStream_.close();
            }
            catch (IOException ioe) {
                throw new SqlException(null, new ClientMessageId("XJ214.S")).getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkValidity();
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getCharacterStream", (int)pos, length);
            }
            this.checkPosAndLength(pos, length);
            Reader retVal = null;
            if (this.isLocator()) {
                try {
                    retVal = new UpdateSensitiveClobLocatorReader(this.agent_.connection_, this, pos, length);
                }
                catch (SqlException sqle) {
                    throw sqle.getSQLException();
                }
            }
            String retVal_str = null;
            try {
                retVal_str = this.getSubStringX(pos, (int)length);
            }
            catch (SqlException sqle) {
                throw sqle.getSQLException();
            }
            retVal = new StringReader(retVal_str);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", retVal);
            }
            return retVal;
        }
    }

    public boolean isString() {
        return (this.dataType_ & 2) == 2;
    }

    public boolean isAsciiStream() {
        return (this.dataType_ & 4) == 4;
    }

    public boolean isCharacterStream() {
        return (this.dataType_ & 0x10) == 16;
    }

    public boolean isUnicodeStream() {
        return (this.dataType_ & 8) == 8;
    }

    public InputStream getUnicodeStream() {
        return this.unicodeStream_;
    }

    public String getString() {
        return this.string_;
    }

    public byte[] getUtf8String() {
        return this.utf8String_;
    }

    public int getUTF8Length() throws SqlException {
        if (this.utf8String_ != null) {
            return this.utf8String_.length;
        }
        try {
            this.utf8String_ = this.string_.getBytes("UTF-8");
            return this.utf8String_.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"String", (Object)"UTF8 byte[]", (Throwable)e);
        }
    }

    protected Clob createClobWrapper(java.sql.Clob clob) throws SqlException {
        Reader rdr;
        long length;
        try {
            length = clob.length();
        }
        catch (SQLException e) {
            throw new SqlException(e);
        }
        if (length > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ093.S"), (Object)new Long(length), new Integer(Integer.MAX_VALUE));
        }
        try {
            rdr = clob.getCharacterStream();
        }
        catch (SQLException e) {
            throw SqlException.javaException(this.agent_.logWriter_, e);
        }
        return new Clob(this.agent_, rdr, (int)length);
    }

    public void convertFromAsciiToCharacterStream() throws SqlException {
        try {
            this.characterStream_ = new InputStreamReader(this.asciiStream_, "ISO-8859-1");
            this.dataType_ = 16;
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"ISO-8859-1", (Object)"CharacterStream", (Throwable)e);
        }
    }

    protected void materializeStream() throws SqlException {
        this.unicodeStream_ = super.materializeStream(this.isAsciiStream() ? this.asciiStream_ : this.unicodeStream_, "java.sql.Clob");
        this.dataType_ = 8;
    }

    long getLocatorLength() throws SqlException {
        return this.agent_.connection_.locatorProcedureCall().clobGetLength(this.locator_);
    }
}

