/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.CallableLocatorProcedures;
import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DatabaseMetaData;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.Savepoint;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.am.Utils;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class Connection
implements java.sql.Connection,
ConnectionCallbackInterface {
    public Agent agent_;
    public DatabaseMetaData databaseMetaData_;
    final WeakHashMap openStatements_ = new WeakHashMap();
    final WeakHashMap CommitAndRollbackListeners_ = new WeakHashMap();
    private SqlWarning warnings_ = null;
    private static final int INVALID_LOCATOR = -1;
    protected final String user_;
    public boolean retrieveMessageText_;
    protected boolean jdbcReadOnly_;
    private int holdability = 1;
    public String databaseName_;
    public String productID_;
    protected EncryptionManager encryptionManager_;
    private Statement setTransactionIsolationStmt = null;
    private Statement getTransactionIsolationStmt = null;
    protected boolean open_ = true;
    private boolean availableForReuse_ = false;
    private static final int TRANSACTION_UNKNOWN = -1;
    private int isolation_ = -1;
    private String currentSchemaName_ = null;
    public boolean autoCommit_ = true;
    protected boolean inUnitOfWork_ = false;
    private boolean accumulated440ForMessageProcFailure_ = false;
    private boolean accumulated444ForMessageProcFailure_ = false;
    private int transactionID_ = 0;
    protected boolean isXAConnection_ = false;
    public static final int XA_T0_NOT_ASSOCIATED = 0;
    public static final int XA_T1_ASSOCIATED = 1;
    private int xaState_ = 0;
    public int xaHostVersion_ = 0;
    public int loginTimeout_;
    public ClientBaseDataSource dataSource_;
    public String serverNameIP_;
    public int portNumber_;
    public int clientSSLMode_ = 0;
    Hashtable clientCursorNameCache_ = new Hashtable();
    public int commBufferSize_ = Short.MAX_VALUE;
    public boolean resetConnectionAtFirstSql_ = false;
    private static String DERBY_TRANSACTION_REPEATABLE_READ = "RS";
    private static String DERBY_TRANSACTION_SERIALIZABLE = "RR";
    private static String DERBY_TRANSACTION_READ_COMMITTED = "CS";
    private static String DERBY_TRANSACTION_READ_UNCOMMITTED = "UR";
    public int dncGeneratedSavepointId_;
    public static final String dncGeneratedSavepointNamePrefix__ = "DNC_GENENERATED_NAME_";
    private CallableLocatorProcedures lobProcs;

    protected Connection(LogWriter logWriter, String user, String password, ClientBaseDataSource dataSource) throws SqlException {
        this.user_ = user;
        this.initConnection(logWriter, dataSource);
    }

    protected Connection(LogWriter logWriter, String user, String password, boolean isXAConn, ClientBaseDataSource dataSource) throws SqlException {
        this.user_ = user;
        this.isXAConnection_ = isXAConn;
        this.initConnection(logWriter, dataSource);
    }

    protected void initConnection(LogWriter logWriter, ClientBaseDataSource dataSource) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(dataSource);
        }
        this.databaseName_ = dataSource.getDatabaseName();
        String connAtrrs = dataSource.getConnectionAttributes();
        if (dataSource.getCreateDatabase() != null) {
            connAtrrs = connAtrrs == null ? "create=true" : connAtrrs + ";create=true";
        }
        if (dataSource.getShutdownDatabase() != null) {
            connAtrrs = connAtrrs == null ? "shutdown=true" : connAtrrs + ";shutdown=true";
        }
        if (this.databaseName_ != null && connAtrrs != null) {
            this.databaseName_ = this.databaseName_ + ";" + connAtrrs;
        }
        this.retrieveMessageText_ = dataSource.getRetrieveMessageText();
        this.loginTimeout_ = dataSource.getLoginTimeout();
        this.dataSource_ = dataSource;
        this.serverNameIP_ = dataSource.getServerName();
        this.portNumber_ = dataSource.getPortNumber();
        this.clientSSLMode_ = ClientBaseDataSource.getSSLModeFromString(dataSource.getSsl());
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected Connection(LogWriter logWriter, boolean isXAConn, ClientBaseDataSource dataSource) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(dataSource);
        }
        this.isXAConnection_ = isXAConn;
        this.user_ = "APP";
        this.databaseName_ = dataSource.getDatabaseName();
        this.retrieveMessageText_ = dataSource.getRetrieveMessageText();
        this.loginTimeout_ = dataSource.getLoginTimeout();
        this.dataSource_ = dataSource;
        this.serverNameIP_ = dataSource.getServerName();
        this.portNumber_ = dataSource.getPortNumber();
        this.clientSSLMode_ = ClientBaseDataSource.getSSLModeFromString(dataSource.getSsl());
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected void resetConnection(LogWriter logWriter) throws SqlException {
        this.clearWarningsX();
        this.encryptionManager_ = null;
        this.currentSchemaName_ = this.user_;
        this.autoCommit_ = true;
        this.inUnitOfWork_ = false;
        this.holdability = 1;
        this.agent_.resetAgent(this, logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_);
    }

    protected Connection(LogWriter logWriter, int driverManagerLoginTimeout, String serverName, int portNumber, String databaseName, Properties properties) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectEntry(serverName, portNumber, databaseName, properties);
        }
        this.databaseName_ = databaseName;
        this.user_ = ClientDataSource.getUser(properties);
        this.retrieveMessageText_ = ClientDataSource.getRetrieveMessageText(properties);
        this.loginTimeout_ = driverManagerLoginTimeout;
        this.serverNameIP_ = serverName;
        this.portNumber_ = portNumber;
        this.clientSSLMode_ = ClientDataSource.getClientSSLMode(properties);
        this.agent_ = this.newAgent_(logWriter, this.loginTimeout_, this.serverNameIP_, this.portNumber_, this.clientSSLMode_);
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        if (!this.open_) {
            return;
        }
        this.agent_.disconnectEvent();
        super.finalize();
    }

    public synchronized java.sql.Statement createStatement() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "createStatement");
            }
            Statement s = this.createStatementX(1003, 1007, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", s);
            }
            return s;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", sql);
            }
            PreparedStatement ps = this.prepareStatementX(sql, 1003, 1007, this.holdability(), 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", ps);
            }
            return ps;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized PreparedStatement preparePositionedUpdateStatement(String sql, Section querySection) throws SqlException {
        this.checkForClosedConnection();
        PreparedStatement preparedStatement = this.newPositionedUpdatePreparedStatement_(sql, querySection);
        preparedStatement.flowPrepareDescribeInputOutput();
        return preparedStatement;
    }

    public synchronized java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", sql);
            }
            CallableStatement cs = this.prepareCallX(sql, 1003, 1007, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", cs);
            }
            return cs;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    synchronized PreparedStatement prepareDynamicCatalogQuery(String sql) throws SqlException {
        PreparedStatement ps = this.newPreparedStatement_(sql, 1003, 1007, this.holdability(), 2, null, null);
        ps.isCatalogQuery_ = true;
        ps.prepare();
        this.openStatements_.put(ps, null);
        return ps;
    }

    public String nativeSQL(String sql) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "nativeSQL", sql);
            }
            String nativeSql = this.nativeSQLX(sql);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "nativeSQL", nativeSql);
            }
            return nativeSql;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized String nativeSQLX(String sql) throws SqlException {
        this.checkForClosedConnection();
        if (sql == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ067.S"));
        }
        String trimSql = sql.trim();
        if (trimSql.startsWith("{") && trimSql.lastIndexOf("}") >= 0) {
            return trimSql.substring(1, trimSql.lastIndexOf("}"));
        }
        return trimSql;
    }

    protected abstract boolean allowLocalCommitRollback_() throws SqlException;

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setAutoCommit", autoCommit);
            }
            this.checkForClosedConnection();
            if (!this.allowLocalCommitRollback_()) {
                if (autoCommit) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("2D521.S.1"));
                }
            } else {
                if (autoCommit == this.autoCommit_) {
                    return;
                }
                if (this.inUnitOfWork_) {
                    this.flowCommit();
                }
            }
            this.autoCommit_ = autoCommit;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public boolean getAutoCommit() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getAutoCommit", this.autoCommit_);
            }
            if (!this.allowLocalCommitRollback_()) {
                return false;
            }
            return this.autoCommit_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized void commit() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "commit");
            }
            this.checkForClosedConnection();
            this.checkForInvalidXAStateOnCommitOrRollback();
            this.flowCommit();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void checkForInvalidXAStateOnCommitOrRollback() throws SqlException {
        if (!this.allowLocalCommitRollback_()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("2D521.S.2"));
        }
    }

    public void flowCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.agent_.beginWriteChainOutsideUOW();
            this.writeCommit();
            this.agent_.flowOutsideUOW();
            this.readCommit();
            this.agent_.endReadChain();
        } else {
            this.agent_.beginWriteChain(null);
            this.writeCommit();
            this.agent_.flow(null);
            this.readCommit();
            this.agent_.endReadChain();
        }
    }

    public boolean flowAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.flowCommit();
            return true;
        }
        return false;
    }

    public boolean willAutoCommitGenerateFlow() throws SqlException {
        if (!this.autoCommit_) {
            return false;
        }
        return this.allowLocalCommitRollback_();
    }

    void writeAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.writeCommit();
        }
    }

    public void writeCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.writeXACommit_();
        } else {
            this.writeLocalCommit_();
        }
    }

    void readAutoCommit() throws SqlException {
        if (this.willAutoCommitGenerateFlow()) {
            this.readCommit();
        }
    }

    public void readCommit() throws SqlException {
        if (this.isXAConnection_) {
            this.readXACommit_();
        } else {
            this.readLocalCommit_();
        }
    }

    public synchronized void rollback() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "rollback");
            }
            this.checkForClosedConnection();
            this.checkForInvalidXAStateOnCommitOrRollback();
            this.flowRollback();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    protected void flowRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.agent_.beginWriteChainOutsideUOW();
            this.writeRollback();
            this.agent_.flowOutsideUOW();
            this.readRollback();
            this.agent_.endReadChain();
        } else {
            this.agent_.beginWriteChain(null);
            this.writeRollback();
            this.agent_.flow(null);
            this.readRollback();
            this.agent_.endReadChain();
        }
    }

    public void writeRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.writeXARollback_();
        } else {
            this.writeLocalRollback_();
        }
    }

    public void readRollback() throws SqlException {
        if (this.isXAConnection_) {
            this.readLocalXARollback_();
        } else {
            this.readLocalRollback_();
        }
    }

    public synchronized void close() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "close");
        }
        this.closeX();
    }

    void checkForTransactionInProgress() throws SqlException {
        if (this.transactionInProgress()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("25001"));
        }
    }

    public boolean transactionInProgress() {
        return this.inUnitOfWork_ && !this.allowCloseInUOW_();
    }

    public synchronized void closeX() throws SQLException {
        if (!this.open_) {
            return;
        }
        this.closeResourcesX();
    }

    public synchronized void closeResources() throws SQLException {
        if (this.open_ || !this.open_ && this.availableForReuse_) {
            this.availableForReuse_ = false;
            this.closeResourcesX();
        }
    }

    private void closeResourcesX() throws SQLException {
        try {
            this.checkForTransactionInProgress();
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
        this.resetConnectionAtFirstSql_ = false;
        SQLException accumulatedExceptions = null;
        if (this.setTransactionIsolationStmt != null) {
            try {
                this.setTransactionIsolationStmt.close();
            }
            catch (SQLException se) {
                accumulatedExceptions = se;
            }
        }
        this.setTransactionIsolationStmt = null;
        if (this.getTransactionIsolationStmt != null) {
            try {
                this.getTransactionIsolationStmt.close();
            }
            catch (SQLException se) {
                accumulatedExceptions = Utils.accumulateSQLException(se, accumulatedExceptions);
            }
        }
        this.getTransactionIsolationStmt = null;
        try {
            this.flowClose();
        }
        catch (SqlException e) {
            accumulatedExceptions = Utils.accumulateSQLException(e.getSQLException(), accumulatedExceptions);
        }
        this.markClosed(false);
        try {
            this.agent_.close();
        }
        catch (SqlException e) {
            throw Utils.accumulateSQLException(e.getSQLException(), accumulatedExceptions);
        }
    }

    protected abstract boolean isGlobalPending_();

    public synchronized void closeForReuse(boolean statementPooling) throws SqlException {
        if (!this.open_) {
            return;
        }
        this.resetConnectionAtFirstSql_ = false;
        SqlException accumulatedExceptions = null;
        try {
            this.flowClose();
        }
        catch (SqlException e) {
            accumulatedExceptions = e;
        }
        if (this.open_) {
            this.markClosedForReuse(statementPooling);
        }
        if (accumulatedExceptions != null) {
            throw accumulatedExceptions;
        }
    }

    private void flowClose() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        if (this.doCloseStatementsOnClose_()) {
            this.writeCloseStatements();
        }
        if (this.autoCommit_) {
            this.writeAutoCommit();
        }
        this.agent_.flowOutsideUOW();
        if (this.doCloseStatementsOnClose_()) {
            this.readCloseStatements();
        }
        if (this.autoCommit_) {
            this.readAutoCommit();
        }
        this.agent_.endReadChain();
    }

    protected abstract void markClosed_();

    public void markClosed(boolean statementPooling) {
        this.open_ = false;
        this.inUnitOfWork_ = false;
        if (!statementPooling) {
            this.markStatementsClosed();
        }
        this.CommitAndRollbackListeners_.clear();
        this.markClosed_();
    }

    private void markClosedForReuse(boolean statementPooling) {
        this.availableForReuse_ = true;
        this.markClosed(statementPooling);
    }

    private void markStatementsClosed() {
        Set keySet = this.openStatements_.keySet();
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            Statement stmt = (Statement)i.next();
            stmt.markClosed();
            i.remove();
        }
    }

    private void writeCloseStatements() throws SqlException {
        Set keySet = this.openStatements_.keySet();
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            ((Statement)i.next()).writeClose(false);
        }
    }

    private void readCloseStatements() throws SqlException {
        Set keySet = this.openStatements_.keySet();
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            ((Statement)i.next()).readClose(false);
        }
    }

    public boolean isPhysicalConnClosed() {
        return !this.open_ && !this.availableForReuse_;
    }

    public boolean isClosed() {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", !this.open_);
        }
        return !this.open_;
    }

    public boolean isClosedX() {
        return !this.open_;
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTransactionIsolation", level);
        }
        try {
            this.checkForClosedConnection();
            this.setTransactionIsolationX(level);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void setTransactionIsolationX(int level) throws SqlException {
        String levelString = null;
        switch (level) {
            case 4: {
                levelString = DERBY_TRANSACTION_REPEATABLE_READ;
                break;
            }
            case 2: {
                levelString = DERBY_TRANSACTION_READ_COMMITTED;
                break;
            }
            case 8: {
                levelString = DERBY_TRANSACTION_SERIALIZABLE;
                break;
            }
            case 1: {
                levelString = DERBY_TRANSACTION_READ_UNCOMMITTED;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ045.S"), new Integer(level));
            }
        }
        if (this.setTransactionIsolationStmt == null || !this.setTransactionIsolationStmt.openOnClient_ || !this.setTransactionIsolationStmt.openOnServer_) {
            this.setTransactionIsolationStmt = this.createStatementX(1003, 1007, this.holdability());
        }
        try {
            this.setTransactionIsolationStmt.executeUpdate("SET CURRENT ISOLATION = " + levelString);
        }
        catch (SQLException sqle) {
            throw new SqlException(sqle);
        }
        this.completeLocalCommit();
        if (this.supportsSessionDataCaching()) {
            SanityManager.ASSERT(this.isolation_ == level);
        }
    }

    protected abstract boolean supportsSessionDataCaching();

    protected abstract boolean serverSupportsLocators();

    public int getTransactionIsolation() throws SQLException {
        boolean currentAutoCommit = this.autoCommit_;
        ResultSet rs = null;
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTransactionIsolation", this.isolation_);
            }
            if (this.isolation_ != -1) {
                SanityManager.ASSERT(this.supportsSessionDataCaching(), "Cannot return cached isolation when caching is not supported!");
                int n = this.isolation_;
                return n;
            }
            this.autoCommit_ = false;
            if (this.getTransactionIsolationStmt == null || !this.getTransactionIsolationStmt.openOnClient_ || !this.getTransactionIsolationStmt.openOnServer_) {
                this.getTransactionIsolationStmt = this.createStatementX(1003, 1007, this.holdability());
            }
            boolean savedInUnitOfWork = this.inUnitOfWork_;
            rs = this.getTransactionIsolationStmt.executeQuery("values current isolation");
            rs.next();
            String isolationStr = rs.getString(1);
            int isolation = this.translateIsolation(isolationStr);
            if (this.isolation_ == -1 && this.supportsSessionDataCaching()) {
                this.isolation_ = isolation;
            }
            SanityManager.ASSERT(!this.supportsSessionDataCaching() || this.isolation_ == isolation, "Cached isolation_ not updated, (isolation_=" + this.isolation_ + ")!=(isolation=" + isolation + ")");
            SanityManager.ASSERT(this.supportsSessionDataCaching() || this.isolation_ == -1, "isolation_ modified when caching is not supported");
            rs.close();
            this.inUnitOfWork_ = savedInUnitOfWork;
            int n = isolation;
            return n;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        finally {
            this.autoCommit_ = currentAutoCommit;
            if (rs != null) {
                rs.close();
            }
        }
    }

    public int getTransactionID() {
        return this.transactionID_;
    }

    public String getCurrentSchemaName() throws SQLException {
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (this.currentSchemaName_ == null) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getCurrentSchemaName() executes query");
            }
            java.sql.Statement s = this.createStatement();
            ResultSet rs = s.executeQuery("VALUES CURRENT SCHEMA");
            rs.next();
            String schema = rs.getString(1);
            rs.close();
            s.close();
            return schema;
        }
        SanityManager.ASSERT(this.supportsSessionDataCaching(), "A cached schema name (" + this.currentSchemaName_ + ") is not expected when session data caching is not" + "supported");
        return this.currentSchemaName_;
    }

    private int translateIsolation(String isolationStr) {
        if (isolationStr.compareTo(DERBY_TRANSACTION_REPEATABLE_READ) == 0) {
            return 4;
        }
        if (isolationStr.compareTo(DERBY_TRANSACTION_SERIALIZABLE) == 0) {
            return 8;
        }
        if (isolationStr.compareTo(DERBY_TRANSACTION_READ_COMMITTED) == 0) {
            return 2;
        }
        if (isolationStr.compareTo(DERBY_TRANSACTION_READ_UNCOMMITTED) == 0) {
            return 1;
        }
        return 0;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    public synchronized void clearWarnings() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings");
            }
            this.checkForClosedConnection();
            this.clearWarningsX();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void clearWarningsX() throws SqlException {
        this.warnings_ = null;
        this.accumulated440ForMessageProcFailure_ = false;
        this.accumulated444ForMessageProcFailure_ = false;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMetaData", this.databaseMetaData_);
            }
            return this.databaseMetaData_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setReadOnly", readOnly);
            }
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public boolean isReadOnly() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "isReadOnly", this.jdbcReadOnly_);
            }
            return false;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setCatalog", catalog);
            }
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public String getCatalog() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCatalog", (Object)null);
            }
            return null;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "createStatement", resultSetType, resultSetConcurrency);
            }
            Statement s = this.createStatementX(resultSetType, resultSetConcurrency, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", s);
            }
            return s;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)sql, resultSetType, resultSetConcurrency);
            }
            PreparedStatement ps = this.prepareStatementX(sql, resultSetType, resultSetConcurrency, this.holdability(), 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", ps);
            }
            return ps;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", (Object)sql, resultSetType, resultSetConcurrency);
            }
            CallableStatement cs = this.prepareCallX(sql, resultSetType, resultSetConcurrency, this.holdability());
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", cs);
            }
            return cs;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized CallableStatement prepareMessageProc(String sql) throws SqlException {
        this.checkForClosedConnection();
        CallableStatement cs = this.prepareCallX(sql, 1003, 1007, this.holdability());
        return cs;
    }

    private int downgradeResultSetType(int resultSetType) {
        if (resultSetType == 1005) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J10")));
            return 1004;
        }
        return resultSetType;
    }

    public Map getTypeMap() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getTypeMap");
            }
            this.checkForClosedConnection();
            HashMap map = new HashMap();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTypeMap", map);
            }
            return map;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setTypeMap", map);
            }
            this.checkForClosedConnection();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S"), "setTypeMap");
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized void setHoldability(int holdability) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setHoldability", holdability);
            }
            this.checkForClosedConnection();
            if (this.isXAConnection_ && this.xaState_ == 1 && holdability == 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ05C.S"));
            }
            this.holdability = holdability;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getHoldability() throws SQLException {
        try {
            this.checkForClosedConnection();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getHoldability", this.holdability());
            }
            return this.holdability();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized java.sql.Savepoint setSavepoint() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "setSavepoint");
            }
            this.checkForClosedConnection();
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ010.S"));
            }
            if (++this.dncGeneratedSavepointId_ < 0) {
                this.dncGeneratedSavepointId_ = 1;
            }
            Savepoint s = this.setSavepointX(new Savepoint(this.agent_, this.dncGeneratedSavepointId_));
            return s;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized java.sql.Savepoint setSavepoint(String name) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setSavepoint", name);
            }
            this.checkForClosedConnection();
            if (name == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ011.S"));
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ010.S"));
            }
            Savepoint s = this.setSavepointX(new Savepoint(this.agent_, name));
            return s;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private Savepoint setSavepointX(Savepoint savepoint) throws SQLException {
        Statement stmt = null;
        try {
            String savepointName;
            stmt = this.createStatementX(1003, 1007, this.holdability());
            try {
                savepointName = savepoint.getSavepointName();
            }
            catch (SQLException e) {
                savepointName = dncGeneratedSavepointNamePrefix__ + savepoint.getSavepointId();
            }
            String sql = "SAVEPOINT \"" + savepointName + "\" ON ROLLBACK RETAIN CURSORS";
            stmt.executeX(sql);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.closeX();
                }
                catch (SqlException doNothing) {}
            }
        }
        return savepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(java.sql.Savepoint savepoint) throws SQLException {
        try {
            int saveXaState = this.xaState_;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "rollback", savepoint);
            }
            this.checkForClosedConnection();
            if (savepoint == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("3B502.S"));
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ008.S"));
            }
            try {
                if (this != ((Savepoint)savepoint).agent_.connection_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"));
                }
            }
            catch (ClassCastException e) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"));
            }
            Statement stmt = null;
            try {
                String savepointName;
                stmt = this.createStatementX(1003, 1007, this.holdability());
                try {
                    savepointName = ((Savepoint)savepoint).getSavepointName();
                }
                catch (SQLException e) {
                    savepointName = dncGeneratedSavepointNamePrefix__ + ((Savepoint)savepoint).getSavepointId();
                }
                String sql = "ROLLBACK TO SAVEPOINT \"" + savepointName + "\"";
                stmt.executeX(sql);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.closeX();
                    }
                    catch (SqlException doNothing) {}
                }
                this.xaState_ = saveXaState;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseSavepoint(java.sql.Savepoint savepoint) throws SQLException {
        try {
            int saveXaState = this.xaState_;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "releaseSavepoint", savepoint);
            }
            this.checkForClosedConnection();
            if (savepoint == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("3B502.S"));
            }
            if (this.autoCommit_) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ008.S"));
            }
            try {
                if (this != ((Savepoint)savepoint).agent_.connection_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"));
                }
            }
            catch (ClassCastException e) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ097.S"));
            }
            Statement stmt = null;
            try {
                String savepointName;
                stmt = this.createStatementX(1003, 1007, this.holdability());
                try {
                    savepointName = ((Savepoint)savepoint).getSavepointName();
                }
                catch (SQLException e) {
                    savepointName = dncGeneratedSavepointNamePrefix__ + ((Savepoint)savepoint).getSavepointId();
                }
                String sql = "RELEASE SAVEPOINT \"" + savepointName + "\"";
                stmt.executeX(sql);
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.closeX();
                    }
                    catch (SqlException doNothing) {}
                }
                this.xaState_ = saveXaState;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public synchronized java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "createStatement", resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            Statement s = this.createStatementX(resultSetType, resultSetConcurrency, resultSetHoldability);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "createStatement", s);
            }
            return s;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private Statement createStatementX(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SqlException {
        this.checkForClosedConnection();
        resultSetType = this.downgradeResultSetType(resultSetType);
        if (this.isXAConnection_ && this.xaState_ == 1 && resultSetHoldability == 1) {
            resultSetHoldability = 2;
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J07")));
        }
        Statement s = this.newStatement_(resultSetType, resultSetConcurrency, resultSetHoldability);
        s.cursorAttributesToSendOnPrepare_ = s.cacheCursorAttributesToSendOnPrepare();
        this.openStatements_.put(s, null);
        return s;
    }

    protected void resetStatement(Statement s) throws SqlException {
        String cursorAttributesToSendOnPrepare = s.cursorAttributesToSendOnPrepare_;
        this.resetStatement_(s, s.resultSetType_, s.resultSetConcurrency_, s.resultSetHoldability_);
        s.cursorAttributesToSendOnPrepare_ = cursorAttributesToSendOnPrepare;
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            PreparedStatement ps = this.prepareStatementX(sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", ps);
            }
            return ps;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    PreparedStatement prepareStatementX(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        this.checkForClosedConnection();
        resultSetType = this.downgradeResultSetType(resultSetType);
        PreparedStatement ps = this.newPreparedStatement_(sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnNames, columnIndexes);
        ps.cursorAttributesToSendOnPrepare_ = ps.cacheCursorAttributesToSendOnPrepare();
        ps.prepare();
        this.openStatements_.put(ps, null);
        return ps;
    }

    protected void resetPrepareStatement(PreparedStatement ps) throws SqlException {
        String cursorAttributesToSendOnPrepare = ps.cursorAttributesToSendOnPrepare_;
        this.resetPreparedStatement_(ps, ps.sql_, ps.resultSetType_, ps.resultSetConcurrency_, ps.resultSetHoldability_, ps.autoGeneratedKeys_, ps.generatedKeysColumnNames_, ps.generatedKeysColumnIndexes_);
        ps.cursorAttributesToSendOnPrepare_ = cursorAttributesToSendOnPrepare;
        ps.prepare();
    }

    public synchronized java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareCall", (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            CallableStatement cs = this.prepareCallX(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareCall", cs);
            }
            return cs;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    CallableStatement prepareCallX(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SqlException {
        this.checkForClosedConnection();
        resultSetType = this.downgradeResultSetType(resultSetType);
        CallableStatement cs = this.newCallableStatement_(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        cs.cursorAttributesToSendOnPrepare_ = cs.cacheCursorAttributesToSendOnPrepare();
        cs.prepare();
        this.openStatements_.put(cs, null);
        return cs;
    }

    protected void resetPrepareCall(CallableStatement cs) throws SqlException {
        String cursorAttributesToSendOnPrepare = cs.cursorAttributesToSendOnPrepare_;
        this.resetCallableStatement_(cs, cs.sql_, cs.resultSetType_, cs.resultSetConcurrency_, cs.resultSetHoldability_);
        cs.cursorAttributesToSendOnPrepare_ = cursorAttributesToSendOnPrepare;
        cs.prepare();
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)sql, autoGeneratedKeys);
            }
            PreparedStatement ps = this.prepareStatementX(sql, 1003, 1007, this.holdability(), autoGeneratedKeys, null, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", ps);
            }
            return ps;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public java.sql.PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)sql, (Object)columnIndexes);
            }
            int genKeys = columnIndexes == null || columnIndexes.length == 0 ? 2 : 1;
            PreparedStatement ps = this.prepareStatementX(sql, 1003, 1007, this.holdability(), genKeys, null, columnIndexes);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", ps);
            }
            return ps;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public java.sql.PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "prepareStatement", (Object)sql, (Object)columnNames);
            }
            int genKeys = columnNames == null || columnNames.length == 0 ? 2 : 1;
            PreparedStatement ps = this.prepareStatementX(sql, 1003, 1007, this.holdability(), genKeys, columnNames, null);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "prepareStatement", ps);
            }
            return ps;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    protected abstract boolean allowCloseInUOW_();

    protected abstract boolean doCloseStatementsOnClose_();

    public abstract SectionManager newSectionManager(String var1, Agent var2, String var3);

    protected abstract Agent newAgent_(LogWriter var1, int var2, String var3, int var4, int var5) throws SqlException;

    protected abstract DatabaseMetaData newDatabaseMetaData_();

    protected abstract Statement newStatement_(int var1, int var2, int var3) throws SqlException;

    protected abstract void resetStatement_(Statement var1, int var2, int var3, int var4) throws SqlException;

    protected abstract PreparedStatement newPositionedUpdatePreparedStatement_(String var1, Section var2) throws SqlException;

    protected abstract PreparedStatement newPreparedStatement_(String var1, int var2, int var3, int var4, int var5, String[] var6, int[] var7) throws SqlException;

    protected abstract void resetPreparedStatement_(PreparedStatement var1, String var2, int var3, int var4, int var5, int var6, String[] var7, int[] var8) throws SqlException;

    protected abstract CallableStatement newCallableStatement_(String var1, int var2, int var3, int var4) throws SqlException;

    protected abstract void resetCallableStatement_(CallableStatement var1, String var2, int var3, int var4, int var5) throws SqlException;

    public void completeConnect() throws SqlException {
        this.open_ = true;
        this.databaseMetaData_ = this.newDatabaseMetaData_();
        this.agent_.sectionManager_ = this.newSectionManager("NULLID", this.agent_, this.databaseName_);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectExit(this);
        }
    }

    public abstract void writeCommitSubstitute_() throws SqlException;

    public abstract void readCommitSubstitute_() throws SqlException;

    public abstract void writeLocalXAStart_() throws SqlException;

    public abstract void readLocalXAStart_() throws SqlException;

    public abstract void writeLocalXACommit_() throws SqlException;

    protected abstract void writeXACommit_() throws SqlException;

    public abstract void readLocalXACommit_() throws SqlException;

    protected abstract void readXACommit_() throws SqlException;

    public abstract void writeLocalCommit_() throws SqlException;

    public abstract void readLocalCommit_() throws SqlException;

    protected abstract void writeXATransactionStart(Statement var1) throws SqlException;

    public void completeLocalCommit() {
        Set keySet = this.CommitAndRollbackListeners_.keySet();
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            UnitOfWorkListener listener = (UnitOfWorkListener)i.next();
            listener.completeLocalCommit(i);
        }
        this.inUnitOfWork_ = false;
        ++this.transactionID_;
    }

    public abstract void writeLocalRollback_() throws SqlException;

    public abstract void readLocalRollback_() throws SqlException;

    public void completeLocalRollback() {
        Set keySet = this.CommitAndRollbackListeners_.keySet();
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            UnitOfWorkListener listener = (UnitOfWorkListener)i.next();
            listener.completeLocalRollback(i);
        }
        this.inUnitOfWork_ = false;
        ++this.transactionID_;
    }

    public void completeSpecificRollback(UnitOfWorkListener uwl) {
        Set keySet = this.CommitAndRollbackListeners_.keySet();
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            UnitOfWorkListener listener = (UnitOfWorkListener)i.next();
            if (listener != uwl) continue;
            listener.completeLocalRollback(i);
            break;
        }
        this.inUnitOfWork_ = false;
    }

    public abstract void writeLocalXARollback_() throws SqlException;

    protected abstract void writeXARollback_() throws SqlException;

    public abstract void readLocalXARollback_() throws SqlException;

    protected abstract void readXARollback_() throws SqlException;

    public void writeTransactionStart(Statement statement) throws SqlException {
        if (this.isXAConnection_) {
            this.writeXATransactionStart(statement);
        }
    }

    public void readTransactionStart() throws SqlException {
        this.completeTransactionStart();
    }

    void completeTransactionStart() {
        this.inUnitOfWork_ = true;
    }

    public void completeAbnormalUnitOfWork() {
        this.completeLocalRollback();
    }

    public void completeAbnormalUnitOfWork(UnitOfWorkListener uwl) {
        this.completeSpecificRollback(uwl);
    }

    public void completeChainBreakingDisconnect() {
        this.open_ = false;
        this.completeLocalRollback();
        this.markStatementsClosed();
    }

    public void completeSqlca(Sqlca sqlca) {
        if (sqlca != null) {
            if (sqlca.getSqlCode() > 0) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            } else if (sqlca.getSqlCode() < 0) {
                this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
            }
        }
    }

    public void completePiggyBackIsolation(int pbIsolation) {
        SanityManager.ASSERT(this.supportsSessionDataCaching());
        this.isolation_ = pbIsolation;
    }

    public void completePiggyBackSchema(String pbSchema) {
        SanityManager.ASSERT(this.supportsSessionDataCaching());
        this.currentSchemaName_ = pbSchema;
    }

    public abstract void addSpecialRegisters(String var1);

    public synchronized void reset(LogWriter logWriter) throws SqlException {
        if (logWriter != null) {
            logWriter.traceConnectResetEntry(this, logWriter, this.user_, this.dataSource_);
        }
        try {
            this.reset_(logWriter);
        }
        catch (SqlException sqle) {
            DisconnectException de = new DisconnectException(this.agent_, new ClientMessageId("08006.C.1"));
            de.setNextException(sqle);
            throw de;
        }
    }

    public synchronized void lightReset() throws SqlException {
        if (!this.open_ && !this.availableForReuse_) {
            return;
        }
        this.open_ = true;
        this.availableForReuse_ = false;
    }

    protected abstract void reset_(LogWriter var1) throws SqlException;

    protected void completeReset(boolean isDeferredReset, boolean closeStatementsOnClose) throws SqlException {
        this.open_ = true;
        this.completeLocalRollback();
        if (closeStatementsOnClose) {
            this.isolation_ = -1;
            Set keySet = this.openStatements_.keySet();
            Iterator i = keySet.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                ((Statement)o).reset(closeStatementsOnClose);
            }
        } else if (this.isolation_ != 2) {
            this.setTransactionIsolationX(2);
        }
        if (!isDeferredReset && this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectResetExit(this);
        }
    }

    CallableLocatorProcedures locatorProcedureCall() {
        if (this.lobProcs == null) {
            this.lobProcs = new CallableLocatorProcedures(this);
        }
        return this.lobProcs;
    }

    protected void checkForClosedConnection() throws SqlException {
        if (!this.open_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"));
        }
        this.agent_.checkForDeferredExceptions();
    }

    public boolean isXAConnection() {
        return this.isXAConnection_;
    }

    public int getXAState() {
        return this.xaState_;
    }

    public void setXAState(int state) {
        this.xaState_ = state;
    }

    public void accumulateWarning(SqlWarning e) {
        if (this.warnings_ == null) {
            this.warnings_ = e;
        } else {
            this.warnings_.setNextException(e);
        }
    }

    public void accumulate440WarningForMessageProcFailure(SqlWarning e) {
        if (!this.accumulated440ForMessageProcFailure_) {
            this.accumulateWarning(e);
            this.accumulated440ForMessageProcFailure_ = true;
        }
    }

    public void accumulate444WarningForMessageProcFailure(SqlWarning e) {
        if (!this.accumulated444ForMessageProcFailure_) {
            this.accumulateWarning(e);
            this.accumulated444ForMessageProcFailure_ = true;
        }
    }

    public int getServerVersion() {
        return this.databaseMetaData_.productLevel_.versionLevel_;
    }

    public void setInUnitOfWork(boolean inUnitOfWork) {
        this.inUnitOfWork_ = inUnitOfWork;
    }

    final int holdability() {
        if (this.isXAConnection_ && this.xaState_ == 1) {
            return 2;
        }
        return this.holdability;
    }

    public java.sql.Clob createClob() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "createClob");
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        int locator = -1;
        Clob clob = null;
        try {
            locator = this.locatorProcedureCall().clobCreateLocator();
        }
        catch (SqlException sqle) {
            throw sqle.getSQLException();
        }
        clob = locator != -1 ? new Clob(this.agent_, locator) : new Clob(this.agent_, "");
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createClob", clob);
        }
        return clob;
    }

    public java.sql.Blob createBlob() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "createBlob");
        }
        try {
            this.checkForClosedConnection();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        int locator = -1;
        Blob blob = null;
        try {
            locator = this.locatorProcedureCall().blobCreateLocator();
        }
        catch (SqlException sqle) {
            throw sqle.getSQLException();
        }
        blob = locator != -1 ? new Blob(this.agent_, locator) : new Blob(new byte[0], this.agent_, 0);
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "createBlob", blob);
        }
        return blob;
    }
}

