/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnTypeConversionException;
import org.apache.derby.client.am.LossOfPrecisionConversionException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Types;

final class CrossConverters {
    public static final int UNKNOWN_LENGTH = Integer.MIN_VALUE;
    private static final BigDecimal bdMaxByteValue__ = BigDecimal.valueOf(127L);
    private static final BigDecimal bdMinByteValue__ = BigDecimal.valueOf(-128L);
    private static final BigDecimal bdMaxShortValue__ = BigDecimal.valueOf(32767L);
    private static final BigDecimal bdMinShortValue__ = BigDecimal.valueOf(-32768L);
    private static final BigDecimal bdMaxIntValue__ = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal bdMinIntValue__ = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal bdMaxLongValue__ = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal bdMinLongValue__ = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal bdMaxFloatValue__ = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue__ = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdMaxDoubleValue__ = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue__ = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdZero__ = BigDecimal.valueOf(0L);
    private static final BigDecimal bdOne__ = BigDecimal.valueOf(1L);
    Agent agent_;

    CrossConverters(Agent agent) {
        this.agent_ = agent;
    }

    final Object setObject(int targetType, boolean source) throws SqlException {
        return this.setObject(targetType, (short)(source ? 1 : 0));
    }

    final Object setObject(int targetType, byte source) throws SqlException {
        return this.setObject(targetType, (short)source);
    }

    final Object setObject(int targetType, short source) throws SqlException {
        switch (targetType) {
            case 5: {
                return new Short(source);
            }
            case 4: {
                return new Integer(source);
            }
            case -5: {
                return new Long(source);
            }
            case 7: {
                return new Float(source);
            }
            case 8: {
                return new Double(source);
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"byte", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, int source) throws SqlException {
        switch (targetType) {
            case 5: {
                if (source > Short.MAX_VALUE || source < Short.MIN_VALUE) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Short((short)source);
            }
            case 4: {
                return new Integer(source);
            }
            case -5: {
                return new Long(source);
            }
            case 7: {
                return new Float(source);
            }
            case 8: {
                return new Double(source);
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"int", Types.getTypeString(targetType));
    }

    final boolean setBooleanFromObject(Object source, int sourceType) throws SqlException {
        switch (sourceType) {
            case 5: {
                return this.getBooleanFromShort((Short)source);
            }
            case 4: {
                return this.getBooleanFromInt((Integer)source);
            }
            case -5: {
                return this.getBooleanFromLong(((BigInteger)source).longValue());
            }
            case 7: {
                return this.getBooleanFromFloat(((Float)source).floatValue());
            }
            case 8: {
                return this.getBooleanFromDouble((Double)source);
            }
            case 3: {
                return this.getBooleanFromLong(((BigDecimal)source).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getBooleanFromString((String)source);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, Types.getTypeString(sourceType), "boolean");
    }

    final byte setByteFromObject(Object source, int sourceType) throws SqlException {
        switch (sourceType) {
            case 5: {
                return this.getByteFromShort((Short)source);
            }
            case 4: {
                return this.getByteFromInt((Integer)source);
            }
            case -5: {
                return this.getByteFromLong(((BigInteger)source).longValue());
            }
            case 7: {
                return this.getByteFromFloat(((Float)source).floatValue());
            }
            case 8: {
                return this.getByteFromDouble((Double)source);
            }
            case 3: {
                return this.getByteFromLong(((BigDecimal)source).longValue());
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getByteFromString((String)source);
            }
        }
        throw new ColumnTypeConversionException(this.agent_.logWriter_, Types.getTypeString(sourceType), "byte");
    }

    final Object setObject(int targetType, long source) throws SqlException {
        switch (targetType) {
            case 5: {
                if (source > 32767L || source < -32768L) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Short((short)source);
            }
            case 4: {
                if (source > Integer.MAX_VALUE || source < Integer.MIN_VALUE) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Integer((int)source);
            }
            case -5: {
                return new Long(source);
            }
            case 7: {
                return new Float(source);
            }
            case 8: {
                return new Double(source);
            }
            case 3: {
                return BigDecimal.valueOf(source);
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"long", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, float source) throws SqlException {
        switch (targetType) {
            case 5: {
                if (source > 32767.0f || source < -32768.0f) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Short((short)source);
            }
            case 4: {
                if (source > 2.1474836E9f || source < -2.1474836E9f) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Integer((int)source);
            }
            case -5: {
                if (source > 9.223372E18f || source < -9.223372E18f) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Long((long)source);
            }
            case 7: {
                if (source == Float.POSITIVE_INFINITY || source == Float.NEGATIVE_INFINITY) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Float(source);
            }
            case 8: {
                if ((double)source == Double.POSITIVE_INFINITY || (double)source == Double.NEGATIVE_INFINITY) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Double(String.valueOf(source));
            }
            case 3: {
                return new BigDecimal(String.valueOf(source));
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"float", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, double source) throws SqlException {
        switch (targetType) {
            case 5: {
                if (source > 32767.0 || source < -32768.0) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Short((short)source);
            }
            case 4: {
                if (source > 2.147483647E9 || source < -2.147483648E9) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Integer((int)source);
            }
            case -5: {
                if (source > 9.223372036854776E18 || source < -9.223372036854776E18) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Long((long)source);
            }
            case 7: {
                if (source > 3.4028234663852886E38 || source < -3.4028234663852886E38) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Float((float)source);
            }
            case 8: {
                if (source == Double.POSITIVE_INFINITY || source == Double.NEGATIVE_INFINITY) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Double(source);
            }
            case 3: {
                return new BigDecimal(String.valueOf(source));
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"double", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, BigDecimal source) throws SqlException {
        switch (targetType) {
            case 5: {
                if (source.compareTo(bdMaxShortValue__) == 1 || source.compareTo(bdMinShortValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Short(source.shortValue());
            }
            case 4: {
                if (source.compareTo(bdMaxIntValue__) == 1 || source.compareTo(bdMinIntValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Integer(source.intValue());
            }
            case -5: {
                if (source.compareTo(bdMaxLongValue__) == 1 || source.compareTo(bdMinLongValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Long(source.longValue());
            }
            case 7: {
                if (source.compareTo(bdMaxFloatValue__) == 1 || source.compareTo(bdMinFloatValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Float(source.floatValue());
            }
            case 8: {
                if (source.compareTo(bdMaxDoubleValue__) == 1 || source.compareTo(bdMinDoubleValue__) == -1) {
                    throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
                }
                return new Double(source.doubleValue());
            }
            case 3: {
                return source;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.Math.BigDecimal", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, Date source) throws SqlException {
        switch (targetType) {
            case 91: {
                return source;
            }
            case 93: {
                return new Timestamp(source.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.sql.Date", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, Time source) throws SqlException {
        switch (targetType) {
            case 92: {
                return source;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.sql.Time", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, Timestamp source) throws SqlException {
        switch (targetType) {
            case 93: {
                return source;
            }
            case 92: {
                return new Time(source.getTime());
            }
            case 91: {
                return new Date(source.getTime());
            }
            case -1: 
            case 1: 
            case 12: {
                return String.valueOf(source);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.sql.Timestamp", Types.getTypeString(targetType));
    }

    final Object setObject(int targetDriverType, String source) throws SqlException {
        try {
            switch (targetDriverType) {
                case 5: {
                    return Short.valueOf(source);
                }
                case 4: {
                    return Integer.valueOf(source);
                }
                case -5: {
                    return Long.valueOf(source);
                }
                case 7: {
                    return Float.valueOf(source);
                }
                case 8: {
                    return Double.valueOf(source);
                }
                case 3: {
                    return new BigDecimal(source);
                }
                case 91: {
                    return this.date_valueOf(source);
                }
                case 92: {
                    return this.time_valueOf(source);
                }
                case 93: {
                    return this.timestamp_valueOf(source);
                }
                case -1: 
                case 1: 
                case 12: {
                    return source;
                }
                case 2005: {
                    return new Clob(this.agent_, source);
                }
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"String", Types.getTypeString(targetDriverType));
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), (Object)Types.getTypeString(targetDriverType), (Throwable)e);
        }
    }

    public static int getInputJdbcType(int jdbcType) {
        switch (jdbcType) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 6: {
                return 8;
            }
        }
        return jdbcType;
    }

    final Object setObject(int targetType, byte[] source) throws SqlException {
        switch (targetType) {
            case -4: 
            case -3: 
            case -2: {
                return source;
            }
            case 2004: {
                return new Blob(source, this.agent_, 0);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"byte[]", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, Reader source, int length) throws SqlException {
        switch (targetType) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromReader(source, length);
            }
            case 2005: {
                if (length == Integer.MIN_VALUE) {
                    return new Clob(this.agent_, source);
                }
                return new Clob(this.agent_, source, length);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.io.Reader", Types.getTypeString(targetType));
    }

    private final String setStringFromReader(Reader r, int length) throws SqlException {
        StringWriter sw = new StringWriter();
        try {
            int read = r.read();
            int totalRead = 0;
            while (read != -1) {
                ++totalRead;
                sw.write(read);
                read = r.read();
            }
            if (length != Integer.MIN_VALUE && length != totalRead) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"));
            }
            return sw.toString();
        }
        catch (IOException e) {
            throw SqlException.javaException(this.agent_.logWriter_, e);
        }
    }

    final Object setObjectFromCharacterStream(int targetType, InputStream source, String encoding, int length) throws SqlException {
        switch (targetType) {
            case -1: 
            case 1: 
            case 12: {
                return this.setStringFromStream(source, encoding, length);
            }
            case 2005: {
                if (length == Integer.MIN_VALUE) {
                    return new Clob(this.agent_, source, encoding);
                }
                return new Clob(this.agent_, source, encoding, length);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.io.InputStream", Types.getTypeString(targetType));
    }

    private final String setStringFromStream(InputStream is, String encoding, int length) throws SqlException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int totalRead = 0;
            try {
                int read = is.read();
                while (read != -1) {
                    ++totalRead;
                    baos.write(read);
                    read = is.read();
                }
            }
            catch (IOException e) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), (Object)e.getClass().getName(), (Object)e.getMessage(), (Throwable)e);
            }
            if (length != Integer.MIN_VALUE && length != totalRead) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"));
            }
            return new String(baos.toByteArray(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"java.io.InputStream", (Object)"String", (Throwable)e);
        }
    }

    final Object setObject(int targetType, java.sql.Blob source) throws SqlException {
        switch (targetType) {
            case 2004: {
                return source;
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.sql.Blob", Types.getTypeString(targetType));
    }

    final Object setObjectFromBinaryStream(int targetType, InputStream source, int length) throws SqlException {
        switch (targetType) {
            case -4: 
            case -3: 
            case -2: {
                return this.setBytesFromStream(source, length);
            }
            case 2004: {
                if (length == Integer.MIN_VALUE) {
                    return new Blob(this.agent_, source);
                }
                return new Blob(this.agent_, source, length);
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.io.InputStream", Types.getTypeString(targetType));
    }

    private final byte[] setBytesFromStream(InputStream is, int length) throws SqlException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int totalRead = 0;
        try {
            int read = is.read();
            while (read != -1) {
                ++totalRead;
                baos.write(read);
                read = is.read();
            }
            if (length != Integer.MIN_VALUE && length != totalRead) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ099.S"));
            }
        }
        catch (IOException e) {
            throw SqlException.javaException(this.agent_.logWriter_, e);
        }
        return baos.toByteArray();
    }

    final Object setObject(int targetType, java.sql.Clob source) throws SqlException {
        switch (targetType) {
            case 2005: {
                return source;
            }
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)"java.sql.Clob", Types.getTypeString(targetType));
    }

    final Object setObject(int targetType, Object source) throws SqlException {
        if (source == null) {
            return null;
        }
        if (source instanceof Boolean) {
            return this.setObject(targetType, (Boolean)source);
        }
        if (source instanceof Integer) {
            return this.setObject(targetType, (Integer)source);
        }
        if (source instanceof Long) {
            return this.setObject(targetType, (Long)source);
        }
        if (source instanceof Float) {
            return this.setObject(targetType, ((Float)source).floatValue());
        }
        if (source instanceof Double) {
            return this.setObject(targetType, (Double)source);
        }
        if (source instanceof BigDecimal) {
            return this.setObject(targetType, (BigDecimal)source);
        }
        if (source instanceof Date) {
            return this.setObject(targetType, (Date)source);
        }
        if (source instanceof Time) {
            return this.setObject(targetType, (Time)source);
        }
        if (source instanceof Timestamp) {
            return this.setObject(targetType, (Timestamp)source);
        }
        if (source instanceof String) {
            return this.setObject(targetType, (String)source);
        }
        if (source instanceof byte[]) {
            return this.setObject(targetType, (byte[])source);
        }
        if (source instanceof java.sql.Blob) {
            return this.setObject(targetType, (java.sql.Blob)source);
        }
        if (source instanceof java.sql.Clob) {
            return this.setObject(targetType, (java.sql.Clob)source);
        }
        if (source instanceof Array) {
            return this.setObject(targetType, (Array)source);
        }
        if (source instanceof Ref) {
            return this.setObject(targetType, (Ref)source);
        }
        if (source instanceof Short) {
            return this.setObject(targetType, (Short)source);
        }
        if (source instanceof Byte) {
            return this.setObject(targetType, (Byte)source);
        }
        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XCL12.S"), (Object)source.getClass().getName(), Types.getTypeString(targetType));
    }

    final boolean getBooleanFromByte(byte source) throws SqlException {
        return source != 0;
    }

    final boolean getBooleanFromShort(short source) throws SqlException {
        return source != 0;
    }

    final boolean getBooleanFromInt(int source) throws SqlException {
        return source != 0;
    }

    final boolean getBooleanFromLong(long source) throws SqlException {
        return source != 0L;
    }

    final boolean getBooleanFromFloat(float source) throws SqlException {
        return source != 0.0f;
    }

    final boolean getBooleanFromDouble(double source) throws SqlException {
        return source != 0.0;
    }

    final boolean getBooleanFromBigDecimal(BigDecimal source) throws SqlException {
        return source.intValue() != 0;
    }

    final boolean getBooleanFromString(String source) throws SqlException {
        return !source.trim().equals("0") && !source.trim().equals("false");
    }

    final byte getByteFromShort(short source) throws SqlException {
        if (source > 127 || source < -128) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (byte)source;
    }

    final byte getByteFromInt(int source) throws SqlException {
        if (source > 127 || source < -128) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (byte)source;
    }

    final byte getByteFromLong(long source) throws SqlException {
        if (source > 127L || source < -128L) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (byte)source;
    }

    final byte getByteFromFloat(float source) throws SqlException {
        if (source > 127.0f || source < -128.0f) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (byte)source;
    }

    final byte getByteFromDouble(double source) throws SqlException {
        if (source > 127.0 || source < -128.0) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (byte)source;
    }

    final byte getByteFromBigDecimal(BigDecimal source) throws SqlException {
        if (source.compareTo(bdMaxByteValue__) == 1 || source.compareTo(bdMinByteValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (byte)source.intValue();
    }

    final byte getByteFromBoolean(boolean source) throws SqlException {
        return source ? (byte)1 : 0;
    }

    final byte getByteFromString(String source) throws SqlException {
        try {
            return this.parseByte(source);
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), (Object)"byte", (Throwable)e);
        }
    }

    final short getShortFromInt(int source) throws SqlException {
        if (source > Short.MAX_VALUE || source < Short.MIN_VALUE) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (short)source;
    }

    final short getShortFromLong(long source) throws SqlException {
        if (source > 32767L || source < -32768L) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (short)source;
    }

    final short getShortFromFloat(float source) throws SqlException {
        if (source > 32767.0f || source < -32768.0f) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (short)source;
    }

    final short getShortFromDouble(double source) throws SqlException {
        if (source > 32767.0 || source < -32768.0) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (short)source;
    }

    final short getShortFromBigDecimal(BigDecimal source) throws SqlException {
        if (source.compareTo(bdMaxShortValue__) == 1 || source.compareTo(bdMinShortValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (short)source.intValue();
    }

    final short getShortFromBoolean(boolean source) throws SqlException {
        return source ? (short)1 : 0;
    }

    final short getShortFromString(String source) throws SqlException {
        try {
            return this.parseShort(source);
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), (Object)"short", (Throwable)e);
        }
    }

    final int getIntFromLong(long source) throws SqlException {
        if (source > Integer.MAX_VALUE || source < Integer.MIN_VALUE) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (int)source;
    }

    final int getIntFromFloat(float source) throws SqlException {
        if (source > 2.1474836E9f || source < -2.1474836E9f) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (int)source;
    }

    final int getIntFromDouble(double source) throws SqlException {
        if (source > 2.147483647E9 || source < -2.147483648E9) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (int)source;
    }

    final int getIntFromBigDecimal(BigDecimal source) throws SqlException {
        if (source.compareTo(bdMaxIntValue__) == 1 || source.compareTo(bdMinIntValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return source.intValue();
    }

    final int getIntFromBoolean(boolean source) throws SqlException {
        return source ? 1 : 0;
    }

    final int getIntFromString(String source) throws SqlException {
        try {
            return this.parseInt(source);
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), (Object)"int", (Throwable)e);
        }
    }

    final long getLongFromFloat(float source) throws SqlException {
        if (source > 9.223372E18f || source < -9.223372E18f) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (long)source;
    }

    final long getLongFromDouble(double source) throws SqlException {
        if (source > 9.223372036854776E18 || source < -9.223372036854776E18) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (long)source;
    }

    final long getLongFromBigDecimal(BigDecimal source) throws SqlException {
        if (source.compareTo(bdMaxLongValue__) == 1 || source.compareTo(bdMinLongValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return source.longValue();
    }

    final long getLongFromBoolean(boolean source) throws SqlException {
        return source ? 1L : 0L;
    }

    final long getLongFromString(String source) throws SqlException {
        try {
            return this.parseLong(source);
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), (Object)"long", (Throwable)e);
        }
    }

    final float getFloatFromDouble(double source) throws SqlException {
        if (Float.isInfinite((float)source)) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return (float)source;
    }

    final float getFloatFromBigDecimal(BigDecimal source) throws SqlException {
        if (source.compareTo(bdMaxFloatValue__) == 1 || source.compareTo(bdMinFloatValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return source.floatValue();
    }

    final float getFloatFromBoolean(boolean source) throws SqlException {
        return source ? 1.0f : 0.0f;
    }

    final float getFloatFromString(String source) throws SqlException {
        try {
            return Float.parseFloat(source.trim());
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), (Object)"float", (Throwable)e);
        }
    }

    final double getDoubleFromBigDecimal(BigDecimal source) throws SqlException {
        if (source.compareTo(bdMaxDoubleValue__) == 1 || source.compareTo(bdMinDoubleValue__) == -1) {
            throw new LossOfPrecisionConversionException(this.agent_.logWriter_, String.valueOf(source));
        }
        return source.doubleValue();
    }

    final double getDoubleFromBoolean(boolean source) throws SqlException {
        return source ? 1.0 : 0.0;
    }

    final double getDoubleFromString(String source) throws SqlException {
        try {
            return Double.parseDouble(source.trim());
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), (Object)"double", (Throwable)e);
        }
    }

    final BigDecimal getBigDecimalFromBoolean(boolean source) throws SqlException {
        return source ? bdOne__ : bdZero__;
    }

    final BigDecimal getBigDecimalFromString(String source) throws SqlException {
        try {
            return new BigDecimal(source.trim());
        }
        catch (NumberFormatException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22018"), (Object)"java.math.BigDecimal", (Throwable)e);
        }
    }

    final String getStringFromBoolean(boolean source) throws SqlException {
        return source ? "1" : "0";
    }

    final String getStringFromBytes(byte[] bytes) throws SqlException {
        StringBuffer stringBuffer = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            String hexForByte = Integer.toHexString(bytes[i] & 0xFF);
            if (hexForByte.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(hexForByte);
        }
        return stringBuffer.toString();
    }

    final Date getDateFromString(String source) throws SqlException {
        try {
            return this.date_valueOf(source);
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), e);
        }
    }

    final Date getDateFromTime(Time source) throws SqlException {
        return new Date(source.getTime());
    }

    final Date getDateFromTimestamp(Timestamp source) throws SqlException {
        return new Date(source.getTime());
    }

    final Time getTimeFromString(String source) throws SqlException {
        try {
            return this.time_valueOf(source);
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), e);
        }
    }

    final Time getTimeFromTimestamp(Timestamp source) throws SqlException {
        return new Time(source.getTime());
    }

    final Timestamp getTimestampFromString(String source) throws SqlException {
        try {
            return this.timestamp_valueOf(source);
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22007.S.181"), e);
        }
    }

    final Timestamp getTimestampFromTime(Time source) throws SqlException {
        return new Timestamp(source.getTime());
    }

    final Timestamp getTimestampFromDate(Date source) throws SqlException {
        return new Timestamp(source.getTime());
    }

    final Date date_valueOf(String s) throws IllegalArgumentException {
        String formatError = "JDBC Date format must be yyyy-mm-dd";
        if (s == null) {
            throw new IllegalArgumentException(formatError);
        }
        s = s.trim();
        return Date.valueOf(s);
    }

    final Time time_valueOf(String s) throws IllegalArgumentException, NumberFormatException {
        String formatError = "JDBC Time format must be hh:mm:ss";
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s = s.trim();
        return Time.valueOf(s);
    }

    final Timestamp timestamp_valueOf(String s) throws IllegalArgumentException, NumberFormatException {
        String formatError = "JDBC Timestamp format must be yyyy-mm-dd hh:mm:ss.fffffffff";
        if (s == null) {
            throw new IllegalArgumentException();
        }
        s = s.trim();
        return Timestamp.valueOf(s);
    }

    private final byte parseByte(String s) throws NumberFormatException {
        int i = this.parseInt(s);
        if (i < -128 || i > 127) {
            throw new NumberFormatException();
        }
        return (byte)i;
    }

    private final short parseShort(String s) throws NumberFormatException {
        int i = this.parseInt(s);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    private final int parseInt(String s) throws NumberFormatException {
        int digit;
        int limit;
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max == 0) {
            throw new NumberFormatException(s);
        }
        if (s.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / 10;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                throw new NumberFormatException(s);
            }
            result = -digit;
        }
        while (i < max) {
            char c;
            if ((c = s.charAt(i++)) == ' ') {
                this.skipPadding(s, i, max);
                break;
            }
            digit = Character.digit(c, 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            if (result < multmin) {
                throw new NumberFormatException(s);
            }
            if ((result *= 10) < limit + digit) {
                throw new NumberFormatException(s);
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    private final long parseLong(String s) throws NumberFormatException {
        int digit;
        long limit;
        if (s == null) {
            throw new NumberFormatException("null");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max == 0) {
            throw new NumberFormatException(s);
        }
        if (s.charAt(0) == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long multmin = limit / 10L;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                throw new NumberFormatException(s);
            }
            result = -digit;
        }
        while (i < max) {
            char c;
            if ((c = s.charAt(i++)) == ' ') {
                this.skipPadding(s, i, max);
                break;
            }
            digit = Character.digit(c, 10);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            if (result < multmin) {
                throw new NumberFormatException(s);
            }
            if ((result *= 10L) < limit + (long)digit) {
                throw new NumberFormatException(s);
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(s);
        }
        return -result;
    }

    private final void skipPadding(String s, int i, int length) throws NumberFormatException {
        while (i < length) {
            if (s.charAt(i++) == ' ') continue;
            throw new NumberFormatException(s);
        }
    }
}

