/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;

public class ConsistencyChecker {
    private ConsistencyChecker() {
    }

    public static boolean checkTable(String schemaName, String tableName) throws SQLException {
        long baseRowCount = -1L;
        RowLocation rl = null;
        RowLocation scanRL = null;
        GenericScanController scan = null;
        int baseColumns = 0;
        ConglomerateController baseCC = null;
        ConglomerateController indexCC = null;
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            ConstraintDescriptor constraintDesc;
            DataDictionary dd = lcc.getDataDictionary();
            DataValueFactory dvf = lcc.getDataValueFactory();
            ExecutionFactory ef = lcc.getLanguageConnectionFactory().getExecutionFactory();
            SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, true);
            TableDescriptor td = dd.getTableDescriptor(tableName, sd, tc);
            if (td == null) {
                throw StandardException.newException("42X05", schemaName + "." + tableName);
            }
            if (td.getTableType() == 2) {
                boolean bl = true;
                return bl;
            }
            baseCC = tc.openConglomerate(td.getHeapConglomerateId(), false, 0, 7, 5);
            baseCC.checkConsistency();
            ConglomerateDescriptor heapCD = td.getConglomerateDescriptor(td.getHeapConglomerateId());
            ExecRow baseRow = ef.getValueRow(td.getNumberOfColumns());
            ColumnDescriptorList cdl = td.getColumnDescriptorList();
            int cdlSize = cdl.size();
            for (int index = 0; index < cdlSize; ++index) {
                ColumnDescriptor cd = cdl.elementAt(index);
                baseRow.setColumn(cd.getPosition(), cd.getType().getNull());
            }
            ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
            for (int index = 0; index < cds.length; ++index) {
                ConglomerateDescriptor indexCD = cds[index];
                if (!indexCD.isIndex()) continue;
                indexCC = tc.openConglomerate(indexCD.getConglomerateNumber(), false, 0, 7, 5);
                indexCC.checkConsistency();
                indexCC.close();
                indexCC = null;
                if (indexCD.isConstraint() && (constraintDesc = dd.getConstraintDescriptor(td, indexCD.getUUID())) == null) {
                    throw StandardException.newException("42X94", (Object)"CONSTRAINT for INDEX", (Object)indexCD.getConglomerateName());
                }
                if (baseRowCount < 0L) {
                    scan = tc.openScan(heapCD.getConglomerateNumber(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0);
                    rl = scan.newRowLocationTemplate();
                    scanRL = scan.newRowLocationTemplate();
                    baseRowCount = 0L;
                    while (scan.next()) {
                        ++baseRowCount;
                    }
                    scan.close();
                    scan = null;
                }
                int[] baseColumnPositions = indexCD.getIndexDescriptor().baseColumnPositions();
                baseColumns = baseColumnPositions.length;
                FormatableBitSet indexColsBitSet = new FormatableBitSet();
                for (int i = 0; i < baseColumns; ++i) {
                    indexColsBitSet.grow(baseColumnPositions[i]);
                    indexColsBitSet.set(baseColumnPositions[i] - 1);
                }
                ExecRow indexRow = ef.getValueRow(baseColumns + 1);
                for (int column = 0; column < baseColumns; ++column) {
                    ColumnDescriptor cd = td.getColumnDescriptor(baseColumnPositions[column]);
                    indexRow.setColumn(column + 1, cd.getType().getNull());
                }
                indexRow.setColumn(baseColumns + 1, rl);
                scan = tc.openScan(indexCD.getConglomerateNumber(), false, 0, 7, 5, null, null, 0, null, null, 0);
                DataValueDescriptor[] baseRowIndexOrder = new DataValueDescriptor[baseColumns];
                DataValueDescriptor[] baseObjectArray = baseRow.getRowArray();
                for (int i = 0; i < baseColumns; ++i) {
                    baseRowIndexOrder[i] = baseObjectArray[baseColumnPositions[i] - 1];
                }
                long indexRows = 0L;
                while (scan.fetchNext(indexRow.getRowArray())) {
                    RowLocation baseRL = (RowLocation)indexRow.getColumn(baseColumns + 1);
                    boolean base_row_exists = baseCC.fetch(baseRL, baseObjectArray, indexColsBitSet);
                    if (!base_row_exists) {
                        String indexName = indexCD.getConglomerateName();
                        throw StandardException.newException("X0X62.S", schemaName + "." + tableName, (Object)indexName, (Object)baseRL.toString(), (Object)indexRow.toString());
                    }
                    for (int column = 0; column < baseColumns; ++column) {
                        DataValueDescriptor baseColumn;
                        DataValueDescriptor indexColumn = indexRow.getColumn(column + 1);
                        if (indexColumn.compare(baseColumn = baseRowIndexOrder[column]) == 0) continue;
                        ColumnDescriptor cd = td.getColumnDescriptor(baseColumnPositions[column]);
                        throw StandardException.newException("X0X61.S", indexCD.getConglomerateName(), (Object)td.getSchemaName(), (Object)td.getName(), (Object)baseRL.toString(), (Object)cd.getColumnName(), (Object)indexColumn.toString(), (Object)baseColumn.toString(), (Object)indexRow.toString());
                    }
                    ++indexRows;
                }
                scan.close();
                scan = null;
                if (indexRows == baseRowCount) continue;
                throw StandardException.newException("X0Y55.S", indexCD.getConglomerateName(), (Object)td.getSchemaName(), (Object)td.getName(), (Object)Long.toString(indexRows), (Object)Long.toString(baseRowCount));
            }
            ConstraintDescriptorList constraintDescList = dd.getConstraintDescriptors(td);
            for (int index = 0; index < constraintDescList.size(); ++index) {
                ConglomerateDescriptor conglomDesc;
                constraintDesc = constraintDescList.elementAt(index);
                if (!constraintDesc.hasBackingIndex() || (conglomDesc = td.getConglomerateDescriptor(constraintDesc.getConglomerateId())) != null) continue;
                throw StandardException.newException("42X94", (Object)"INDEX for CONSTRAINT", (Object)constraintDesc.getConstraintName());
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        finally {
            try {
                if (baseCC != null) {
                    baseCC.close();
                    baseCC = null;
                }
                if (indexCC != null) {
                    indexCC.close();
                    indexCC = null;
                }
                if (scan != null) {
                    scan.close();
                    scan = null;
                }
            }
            catch (StandardException se) {
                throw PublicAPI.wrapStandardException(se);
            }
        }
        return true;
    }
}

