/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.derby.iapi.error.ErrorStringBuilder;
import org.apache.derby.iapi.error.PassThroughException;
import org.apache.derby.iapi.error.ShutdownException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;

public class ContextManager {
    private final HashMap ctxTable = new HashMap();
    private final ArrayList holder = new ArrayList();
    private Locale messageLocale;
    final ContextService owningCsf;
    private int logSeverityLevel;
    private HeaderPrintWriter errorStream;
    private ErrorStringBuilder errorStringBuilder;
    private boolean shutdown;
    private LocaleFinder finder;
    Thread activeThread;
    int activeCount;

    public void pushContext(Context newContext) {
        this.checkInterrupt();
        String contextId = newContext.getIdName();
        CtxStack idStack = (CtxStack)this.ctxTable.get(contextId);
        if (idStack == null) {
            idStack = new CtxStack();
            this.ctxTable.put(contextId, idStack);
        }
        idStack.push(newContext);
        this.holder.add(newContext);
    }

    public Context getContext(String contextId) {
        this.checkInterrupt();
        CtxStack idStack = (CtxStack)this.ctxTable.get(contextId);
        SanityManager.ASSERT(idStack == null || idStack.isEmpty() || idStack.top().getIdName() == contextId);
        return idStack == null ? null : idStack.top();
    }

    public void popContext() {
        this.checkInterrupt();
        if (this.holder.isEmpty()) {
            return;
        }
        Context theContext = (Context)this.holder.remove(this.holder.size() - 1);
        String contextId = theContext.getIdName();
        CtxStack idStack = (CtxStack)this.ctxTable.get(contextId);
        SanityManager.ASSERT(idStack != null && !idStack.isEmpty() && idStack.top().getIdName() == contextId);
        idStack.pop();
    }

    void popContext(Context theContext) {
        this.checkInterrupt();
        SanityManager.ASSERT(!this.holder.isEmpty());
        this.holder.remove(this.holder.lastIndexOf(theContext));
        String contextId = theContext.getIdName();
        CtxStack idStack = (CtxStack)this.ctxTable.get(contextId);
        idStack.remove(theContext);
    }

    final boolean isEmpty() {
        return this.holder.isEmpty();
    }

    public final List getContextStack(String contextId) {
        CtxStack cs = (CtxStack)this.ctxTable.get(contextId);
        return cs == null ? Collections.EMPTY_LIST : cs.getUnmodifiableList();
    }

    public boolean cleanupOnError(Throwable error) {
        boolean reportError;
        if (this.shutdown) {
            return true;
        }
        if (this.errorStringBuilder == null) {
            this.errorStringBuilder = new ErrorStringBuilder(this.errorStream.getHeader());
        }
        ThreadDeath seenThreadDeath = null;
        if (error instanceof ThreadDeath) {
            seenThreadDeath = (ThreadDeath)error;
        }
        if (error instanceof PassThroughException) {
            error = error.getCause();
        }
        if (reportError = this.reportError(error)) {
            ContextImpl sc;
            ContextImpl lcc = null;
            StringBuffer sb = null;
            if (!this.shutdown && (lcc = (ContextImpl)this.getContext("LanguageConnectionContext")) != null) {
                sb = lcc.appendErrorInfo();
            }
            String cleanup = "Cleanup action starting";
            if (sb != null) {
                sb.append(cleanup);
                cleanup = sb.toString();
            }
            this.errorStringBuilder.appendln(cleanup);
            if (!this.shutdown && (sc = (ContextImpl)this.getContext("StatementContext")) != null && (sb = sc.appendErrorInfo()) != null) {
                this.errorStringBuilder.appendln(sb.toString());
            }
        }
        block3: while (true) {
            int errorSeverity;
            int n = errorSeverity = error instanceof StandardException ? ((StandardException)error).getSeverity() : 0;
            if (reportError) {
                this.errorStringBuilder.stackTrace(error);
                this.flushErrorString();
            }
            boolean lastHandler = false;
            for (int index = this.holder.size() - 1; index >= 0; --index) {
                try {
                    if (lastHandler) break block3;
                    Context ctx = (Context)this.holder.get(index);
                    lastHandler = ctx.isLastHandler(errorSeverity);
                    ctx.cleanupOnError(error);
                    continue;
                }
                catch (StandardException se) {
                    if (error instanceof StandardException && se.getSeverity() > ((StandardException)error).getSeverity()) {
                        error = se;
                        reportError = this.reportError(se);
                        if (!reportError) continue block3;
                        this.errorStream.println("New exception raised during cleanup " + error.getMessage());
                        this.errorStream.flush();
                        continue block3;
                    }
                    if (!this.reportError(se)) continue;
                    this.errorStringBuilder.appendln("Less severe exception raised during cleanup (ignored) " + se.getMessage());
                    this.errorStringBuilder.stackTrace(se);
                    this.flushErrorString();
                    continue;
                }
                catch (Throwable t) {
                    reportError = this.reportError(t);
                    if (error instanceof StandardException) {
                        error = t;
                        if (!reportError) continue block3;
                        this.errorStream.println("New exception raised during cleanup " + error.getMessage());
                        this.errorStream.flush();
                        continue block3;
                    }
                    if (reportError) {
                        this.errorStringBuilder.appendln("Equally severe exception raised during cleanup (ignored) " + t.getMessage());
                        this.errorStringBuilder.stackTrace(t);
                        this.flushErrorString();
                    }
                    if (!(t instanceof ThreadDeath)) continue;
                    if (seenThreadDeath != null) {
                        throw seenThreadDeath;
                    }
                    seenThreadDeath = (ThreadDeath)t;
                }
            }
            break;
        }
        if (reportError) {
            this.errorStream.println("Cleanup action completed");
            this.errorStream.flush();
        }
        if (seenThreadDeath != null) {
            throw seenThreadDeath;
        }
        return false;
    }

    synchronized boolean setInterrupted(Context c) {
        boolean interruptMe;
        boolean bl = interruptMe = c == null || this.holder.contains(c);
        if (interruptMe) {
            this.shutdown = true;
        }
        return interruptMe;
    }

    private void checkInterrupt() {
        if (this.shutdown) {
            throw new ShutdownException();
        }
    }

    public void setLocaleFinder(LocaleFinder finder) {
        this.finder = finder;
    }

    public void setMessageLocale(String localeID) throws StandardException {
        this.messageLocale = Monitor.getLocaleFromString(localeID);
    }

    public Locale getMessageLocale() {
        if (this.messageLocale != null) {
            return this.messageLocale;
        }
        if (this.finder != null) {
            try {
                return this.finder.getCurrentLocale();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        return Locale.getDefault();
    }

    private void flushErrorString() {
        this.errorStream.print(this.errorStringBuilder.get().toString());
        this.errorStream.flush();
        this.errorStringBuilder.reset();
    }

    private boolean reportError(Throwable t) {
        if (t instanceof StandardException) {
            StandardException se = (StandardException)t;
            switch (se.report()) {
                case 0: {
                    int level = se.getSeverity();
                    return level >= this.logSeverityLevel || level == 0;
                }
                case 1: {
                    return false;
                }
            }
            return true;
        }
        return !(t instanceof ShutdownException);
    }

    ContextManager(ContextService csf, HeaderPrintWriter stream) {
        this.errorStream = stream;
        this.owningCsf = csf;
        this.logSeverityLevel = PropertyUtil.getSystemInt("derby.stream.error.logSeverityLevel", 0);
    }

    private static final class CtxStack {
        private final ArrayList stack_ = new ArrayList();
        private final List view_ = Collections.unmodifiableList(this.stack_);
        private Context top_ = null;

        private CtxStack() {
        }

        void push(Context context) {
            this.stack_.add(context);
            this.top_ = context;
        }

        void pop() {
            this.stack_.remove(this.stack_.size() - 1);
            this.top_ = this.stack_.isEmpty() ? null : (Context)this.stack_.get(this.stack_.size() - 1);
        }

        void remove(Context context) {
            if (context == this.top_) {
                this.pop();
                return;
            }
            this.stack_.remove(this.stack_.lastIndexOf(context));
        }

        Context top() {
            return this.top_;
        }

        boolean isEmpty() {
            return this.stack_.isEmpty();
        }

        List getUnmodifiableList() {
            return this.view_;
        }
    }
}

