/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.diag;

import org.apache.derby.iapi.services.diag.Diagnosticable;

public class DiagnosticUtil {
    private DiagnosticUtil() {
    }

    public static Diagnosticable findDiagnostic(Object ref) {
        Class<?> refClass = ref.getClass();
        try {
            Class<?> diagClass;
            while (true) {
                String className = refClass.getName();
                int lastDot = className.lastIndexOf(46) + 1;
                String diagClassName = className.substring(0, lastDot) + "D_" + className.substring(lastDot);
                try {
                    diagClass = Class.forName(diagClassName);
                }
                catch (ClassNotFoundException cnfe) {
                    if ((refClass = refClass.getSuperclass()) != null) continue;
                    return null;
                }
                break;
            }
            Diagnosticable diag_obj = (Diagnosticable)diagClass.newInstance();
            diag_obj.init(ref);
            return diag_obj;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toDiagString(Object obj) {
        String ret_string = null;
        if (obj == null) {
            return "null";
        }
        try {
            Diagnosticable diag = DiagnosticUtil.findDiagnostic(obj);
            if (diag != null) {
                ret_string = diag.diag();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (ret_string == null) {
            ret_string = obj.toString();
        }
        return ret_string;
    }
}

