/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;

public class EmbedStatement
extends ConnectionChild
implements EngineStatement {
    private final Connection applicationConnection;
    protected EngineStatement applicationStatement;
    int updateCount = -1;
    EmbedResultSet results;
    private java.sql.ResultSet autoGeneratedKeysResultSet;
    private String cursorName;
    private final boolean forMetaData;
    final int resultSetType;
    final int resultSetConcurrency;
    private final int resultSetHoldability;
    final LanguageConnectionContext lcc;
    private SQLWarning warnings;
    String SQLText;
    private int fetchSize = 1;
    private int fetchDirection = 1000;
    int MaxFieldSize;
    long timeoutMillis;
    private boolean active = true;
    Vector batchStatements;
    int maxRows;
    private ParameterValueSet pvs;
    protected boolean isPoolable = false;
    private EmbedResultSet[] dynamicResults;
    private int currentDynamicResultSet;

    public EmbedStatement(EmbedConnection connection, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection);
        this.forMetaData = forMetaData;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.lcc = this.getEmbedConnection().getLanguageConnection();
        this.applicationConnection = this.getEmbedConnection().getApplicationConnection();
        this.applicationStatement = this;
    }

    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql, true, false, 2, null, null);
        if (this.results == null) {
            SanityManager.THROWASSERT("no results returned on executeQuery()");
        }
        return this.results;
    }

    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql, false, true, 2, null, null);
        return this.updateCount;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.execute(sql, false, true, autoGeneratedKeys, null, null);
        return this.updateCount;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.execute(sql, false, true, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null);
        return this.updateCount;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.execute(sql, false, true, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames);
        return this.updateCount;
    }

    final void checkIfInMiddleOfBatch() throws SQLException {
        if (this.batchStatements != null) {
            throw this.newSQLException("XJ068.S");
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.active) {
            try {
                this.checkExecStatus();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return !this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws SQLException {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.closeActions();
            this.active = false;
            this.clearResultSets();
            this.cursorName = null;
            this.warnings = null;
            this.SQLText = null;
            this.batchStatements = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.results != null && this.results.singleUseActivation != null) {
            this.results.singleUseActivation.markUnused();
        }
    }

    void closeActions() throws SQLException {
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkStatus();
        return this.MaxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkStatus();
        if (max < 0) {
            throw this.newSQLException("XJ066.S", new Integer(max));
        }
        this.MaxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        this.checkStatus();
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkStatus();
        if (max < 0) {
            throw this.newSQLException("XJ063.S", new Integer(max));
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkStatus();
    }

    public final int getQueryTimeout() throws SQLException {
        this.checkStatus();
        return (int)(this.timeoutMillis / 1000L);
    }

    public final void setQueryTimeout(int seconds) throws SQLException {
        this.checkStatus();
        if (seconds < 0) {
            throw this.newSQLException("XJ074.S", new Integer(seconds));
        }
        this.timeoutMillis = (long)seconds * 1000L;
    }

    public void cancel() throws SQLException {
        throw Util.notImplemented("cancel");
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkStatus();
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.checkStatus();
        this.warnings = null;
    }

    public void setCursorName(String name) throws SQLException {
        this.checkStatus();
        this.cursorName = name;
    }

    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, false, false, 2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(String sql, boolean executeQuery, boolean executeUpdate, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            this.checkExecStatus();
            if (sql == null) {
                throw this.newSQLException("XJ067.S");
            }
            this.checkIfInMiddleOfBatch();
            this.clearResultSets();
            this.setupContextStack();
            this.SQLText = sql;
            try {
                Activation activation;
                try {
                    PreparedStatement preparedStatement = this.lcc.prepareInternalStatement(this.lcc.getDefaultSchema(), sql, this.resultSetConcurrency == 1007, false);
                    activation = preparedStatement.getActivation(this.lcc, this.resultSetType == 1004);
                    this.checkRequiresCallableStatement(activation);
                }
                catch (Throwable t) {
                    throw this.handleException(t);
                }
                activation.setSingleExecution();
                if (autoGeneratedKeys == 1) {
                    activation.setAutoGeneratedKeysResultsetInfo(columnIndexes, columnNames);
                }
                bl = this.executeStatement(activation, executeQuery, executeUpdate);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql, false, false, autoGeneratedKeys, null, null);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, false, true, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, false, true, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames);
    }

    public final java.sql.ResultSet getResultSet() throws SQLException {
        this.checkStatus();
        return this.results;
    }

    public final int getUpdateCount() throws SQLException {
        this.checkStatus();
        return this.updateCount;
    }

    public final boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    public final int getResultSetType() throws SQLException {
        this.checkStatus();
        return this.resultSetType;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkStatus();
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw this.newSQLException("XJ064.S", new Integer(direction));
        }
        this.fetchDirection = direction;
    }

    public int getFetchDirection() throws SQLException {
        this.checkStatus();
        return this.fetchDirection;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkStatus();
        if (rows < 0 || this.getMaxRows() != 0 && rows > this.getMaxRows()) {
            throw this.newSQLException("XJ065.S", new Integer(rows));
        }
        if (rows > 0) {
            this.fetchSize = rows;
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkStatus();
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkStatus();
        return this.resultSetConcurrency;
    }

    public final int getResultSetHoldability() throws SQLException {
        this.checkStatus();
        return this.resultSetHoldability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String sql) throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.addElement(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.batchStatements = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            SQLException sqle;
            int i;
            this.setupContextStack();
            this.clearResultSets();
            Vector stmts = this.batchStatements;
            this.batchStatements = null;
            int size = stmts == null ? 0 : stmts.size();
            int[] returnUpdateCountForBatch = new int[size];
            try {
                for (i = 0; i < size; ++i) {
                    if (this.executeBatchElement(stmts.elementAt(i))) {
                        throw this.newSQLException("XJ04B.S");
                    }
                    returnUpdateCountForBatch[i] = this.getUpdateCount();
                }
                int[] nArray = returnUpdateCountForBatch;
                return nArray;
            }
            catch (StandardException se) {
                sqle = this.handleException(se);
            }
            catch (SQLException sqle2) {
                sqle = sqle2;
            }
            finally {
                this.restoreContextStack();
            }
            int[] successfulUpdateCount = new int[i];
            int j = 0;
            while (true) {
                if (j >= i) {
                    BatchUpdateException batch = new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), successfulUpdateCount);
                    batch.setNextException(sqle);
                    batch.initCause(sqle);
                    throw batch;
                }
                successfulUpdateCount[j] = returnUpdateCountForBatch[j];
                ++j;
            }
        }
    }

    boolean executeBatchElement(Object batchElement) throws SQLException, StandardException {
        return this.execute((String)batchElement, false, true, 2, null, null);
    }

    public final Connection getConnection() throws SQLException {
        this.checkStatus();
        Connection appConn = this.getEmbedConnection().getApplicationConnection();
        if (appConn != this.applicationConnection || appConn == null) {
            throw Util.noCurrentConnection();
        }
        return appConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getMoreResults(int current) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.dynamicResults == null) {
                this.clearResultSets();
                return false;
            }
            switch (current) {
                default: {
                    int startingClose = 0;
                    break;
                }
                case 1: {
                    int startingClose = this.currentDynamicResultSet;
                    break;
                }
                case 2: {
                    int startingClose = this.dynamicResults.length;
                }
            }
            SQLException se = null;
            for (int i = startingClose; i <= this.currentDynamicResultSet && i < this.dynamicResults.length; ++i) {
                EmbedResultSet lrs = this.dynamicResults[i];
                if (lrs == null) continue;
                try {
                    lrs.close();
                    continue;
                }
                catch (SQLException sqle) {
                    if (se == null) {
                        se = sqle;
                        continue;
                    }
                    se.setNextException(sqle);
                    continue;
                }
                finally {
                    this.dynamicResults[i] = null;
                }
            }
            if (se != null) {
                throw se;
            }
            this.updateCount = -1;
            while (++this.currentDynamicResultSet < this.dynamicResults.length) {
                EmbedResultSet lrs = this.dynamicResults[this.currentDynamicResultSet];
                if (lrs == null) continue;
                if (lrs.isClosed) {
                    this.dynamicResults[this.currentDynamicResultSet] = null;
                    continue;
                }
                this.results = lrs;
                return true;
            }
            this.results = null;
            return false;
        }
    }

    public final java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.checkStatus();
        if (this.autoGeneratedKeysResultSet == null) {
            return null;
        }
        this.execute("VALUES IDENTITY_VAL_LOCAL()", true, false, 2, null, null);
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean retval;
            SanityManager.ASSERT(this.results == null);
            SanityManager.ASSERT(this.dynamicResults == null);
            SanityManager.ASSERT(this.autoGeneratedKeysResultSet == null);
            this.setupContextStack();
            this.pvs = a.getParameterValueSet();
            try {
                this.clearWarnings();
                if (!this.forMetaData) {
                    this.commitIfNeeded();
                    this.needCommit();
                } else if (this.lcc.getActivationCount() <= 1) {
                    this.commitIfNeeded();
                    this.needCommit();
                }
                ExecPreparedStatement ps = a.getPreparedStatement();
                ps.rePrepare(this.lcc);
                this.addWarning(ps.getCompileTimeWarnings());
                if (this.cursorName != null) {
                    a.setCursorName(this.cursorName);
                }
                boolean executeHoldable = this.getExecuteHoldable();
                a.setResultSetHoldability(executeHoldable);
                a.reset();
                a.setMaxRows(this.maxRows);
                ResultSet resultsToWrap = ps.execute(a, this.timeoutMillis);
                this.addWarning(a.getWarnings());
                if (resultsToWrap.returnsRows()) {
                    EmbedResultSet lresults;
                    if (executeUpdate) {
                        throw StandardException.newException("X0Y79.S");
                    }
                    this.results = lresults = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultsToWrap, this.forMetaData, this, ps.isAtomic());
                    if (a.isSingleExecution()) {
                        lresults.singleUseActivation = a;
                    }
                    this.updateCount = -1;
                    retval = true;
                } else {
                    if (a.getAutoGeneratedKeysResultsetMode() && resultsToWrap.getAutoGeneratedKeysResultset() != null) {
                        resultsToWrap.getAutoGeneratedKeysResultset().open();
                        this.autoGeneratedKeysResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultsToWrap.getAutoGeneratedKeysResultset(), false, this, ps.isAtomic());
                    }
                    this.updateCount = resultsToWrap.modifiedRowCount();
                    this.results = null;
                    int dynamicResultCount = 0;
                    if (a.getDynamicResults() != null) {
                        dynamicResultCount = this.processDynamicResults(a.getDynamicResults(), a.getMaxDynamicResults());
                    }
                    resultsToWrap.close();
                    if (executeQuery && dynamicResultCount != 1) {
                        throw StandardException.newException("X0Y78.S");
                    }
                    if (executeUpdate && dynamicResultCount > 0) {
                        throw StandardException.newException("X0Y79.S");
                    }
                    if (dynamicResultCount == 0) {
                        if (a.isSingleExecution()) {
                            a.close();
                        }
                        if (!this.forMetaData) {
                            this.commitIfNeeded();
                        } else if (this.lcc.getActivationCount() <= 1) {
                            this.commitIfNeeded();
                        }
                    }
                    retval = dynamicResultCount > 0;
                }
            }
            catch (Throwable t) {
                if (a.isSingleExecution()) {
                    try {
                        a.close();
                    }
                    catch (Throwable tt) {
                        // empty catch block
                    }
                }
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            return retval;
        }
    }

    final void addWarning(SQLWarning sw) {
        if (sw != null) {
            if (this.warnings == null) {
                this.warnings = sw;
            } else {
                this.warnings.setNextException(sw);
            }
        }
    }

    public String getSQLText() {
        return this.SQLText;
    }

    public ParameterValueSet getParameterValueSet() {
        return this.pvs;
    }

    final void checkStatus() throws SQLException {
        if (!this.active) {
            Connection appConn = this.getEmbedConnection().getApplicationConnection();
            if (appConn == null || appConn.isClosed()) {
                throw Util.noCurrentConnection();
            }
            throw this.newSQLException("XJ012.S", "Statement");
        }
    }

    final void checkExecStatus() throws SQLException {
        if (!this.getConnection().isClosed()) {
            return;
        }
        this.active = false;
        throw Util.noCurrentConnection();
    }

    void clearResultSets() throws SQLException {
        SQLException sqle = null;
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
        }
        catch (SQLException s1) {
            sqle = s1;
        }
        try {
            if (this.autoGeneratedKeysResultSet != null) {
                this.autoGeneratedKeysResultSet.close();
                this.autoGeneratedKeysResultSet = null;
            }
        }
        catch (SQLException sauto) {
            if (sqle == null) {
                sqle = sauto;
            }
            sqle.setNextException(sauto);
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                EmbedResultSet lrs = this.dynamicResults[i];
                if (lrs == null) continue;
                try {
                    lrs.close();
                    continue;
                }
                catch (SQLException sdynamic) {
                    if (sqle == null) {
                        sqle = sdynamic;
                        continue;
                    }
                    sqle.setNextException(sdynamic);
                }
            }
            this.dynamicResults = null;
        }
        this.updateCount = -1;
        if (sqle != null) {
            throw sqle;
        }
    }

    void checkRequiresCallableStatement(Activation activation) throws SQLException {
        ParameterValueSet pvs = activation.getParameterValueSet();
        if (pvs == null) {
            return;
        }
        if (pvs.checkNoDeclaredOutputParameters()) {
            try {
                activation.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw this.newSQLException("XJ009.S", this.SQLText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferBatch(EmbedStatement other) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            other.batchStatements = this.batchStatements;
            this.batchStatements = null;
        }
    }

    public final void setApplicationStatement(EngineStatement s) {
        this.applicationStatement = s;
    }

    private int processDynamicResults(java.sql.ResultSet[][] holder, int maxDynamicResultSets) throws SQLException {
        int i;
        Object[] sorted = new EmbedResultSet[holder.length];
        int actualCount = 0;
        for (i = 0; i < holder.length; ++i) {
            java.sql.ResultSet[] param = holder[i];
            java.sql.ResultSet rs = param[0];
            param[0] = null;
            EmbedResultSet lrs = EmbedStatement.processDynamicResult(this.getEmbedConnection(), rs, this);
            if (lrs == null) continue;
            sorted[actualCount++] = lrs;
        }
        if (actualCount != 0) {
            if (actualCount != 1) {
                Arrays.sort(sorted, 0, actualCount);
            }
            this.dynamicResults = sorted;
            if (actualCount > maxDynamicResultSets) {
                this.addWarning(StandardException.newWarning("0100E"));
                for (i = maxDynamicResultSets; i < actualCount; ++i) {
                    ((EmbedResultSet)sorted[i]).close();
                    sorted[i] = null;
                }
                actualCount = maxDynamicResultSets;
            }
            this.updateCount = -1;
            this.results = sorted[0];
            this.currentDynamicResultSet = 0;
        }
        return actualCount;
    }

    static EmbedResultSet processDynamicResult(EmbedConnection conn, java.sql.ResultSet resultSet, EmbedStatement callStatement) {
        if (resultSet == null) {
            return null;
        }
        if (!(resultSet instanceof EmbedResultSet)) {
            return null;
        }
        EmbedResultSet lrs = (EmbedResultSet)resultSet;
        if (lrs.getEmbedConnection().rootConnection != conn.rootConnection) {
            return null;
        }
        try {
            lrs.checkIfClosed("");
        }
        catch (SQLException ex) {
            return null;
        }
        lrs.setDynamicResultSet(callStatement);
        return lrs;
    }

    void resultSetClosing(EmbedResultSet closingLRS) throws SQLException {
        if (!this.getEmbedConnection().autoCommit) {
            return;
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                EmbedResultSet lrs = this.dynamicResults[i];
                if (lrs == null || lrs.isClosed || lrs == closingLRS) continue;
                return;
            }
        }
        this.commitIfAutoCommit();
    }

    private boolean getExecuteHoldable() throws SQLException {
        if (this.resultSetHoldability == 2) {
            return false;
        }
        if (this.applicationStatement == this) {
            return true;
        }
        return this.applicationStatement.getResultSetHoldability() == 1;
    }

    public boolean isPoolable() throws SQLException {
        this.checkStatus();
        return this.isPoolable;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.checkStatus();
        this.isPoolable = poolable;
    }
}

