/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public final class TransactionResourceImpl {
    protected ContextManager cm;
    protected ContextService csf;
    protected String username;
    private String dbname;
    private InternalDriver driver;
    private String url;
    private String drdaID;
    protected Database database;
    protected LanguageConnectionContext lcc;

    TransactionResourceImpl(InternalDriver driver, String url, Properties info) throws SQLException {
        this.driver = driver;
        this.csf = driver.getContextServiceFactory();
        this.dbname = InternalDriver.getDatabaseName(url, info);
        this.url = url;
        this.username = IdUtil.getUserNameFromURLProps(info);
        this.drdaID = info.getProperty("drdaID", null);
        this.cm = this.csf.newContextManager();
    }

    void setDatabase(Database db) {
        SanityManager.ASSERT(this.database == null, "setting database when it is not null");
        this.database = db;
    }

    void startTransaction() throws StandardException, SQLException {
        this.lcc = this.database.setupConnection(this.cm, this.username, this.drdaID, this.dbname);
    }

    InternalDriver getDriver() {
        return this.driver;
    }

    ContextService getCsf() {
        return this.csf;
    }

    ContextManager getContextManager() {
        return this.cm;
    }

    LanguageConnectionContext getLcc() {
        return this.lcc;
    }

    String getDBName() {
        return this.dbname;
    }

    String getUrl() {
        return this.url;
    }

    Database getDatabase() {
        return this.database;
    }

    StandardException shutdownDatabaseException() {
        StandardException se = StandardException.newException("08006.D", this.getDBName());
        se.setReport(1);
        return se;
    }

    void commit() throws StandardException {
        this.lcc.userCommit();
    }

    void rollback() throws StandardException {
        if (this.lcc != null) {
            this.lcc.userRollback();
        }
    }

    void clearContextInError() {
        this.csf.resetCurrentContextManager(this.cm);
        this.cm = null;
    }

    void clearLcc() {
        this.lcc = null;
    }

    final void setupContextStack() {
        SanityManager.ASSERT(this.cm != null, "setting up null context manager stack");
        this.csf.setCurrentContextManager(this.cm);
    }

    final void restoreContextStack() {
        if (this.csf == null || this.cm == null) {
            return;
        }
        this.csf.resetCurrentContextManager(this.cm);
    }

    final SQLException handleException(Throwable thrownException, boolean autoCommit, boolean rollbackOnAutoCommit) throws SQLException {
        try {
            SanityManager.ASSERT(thrownException != null);
            if (thrownException instanceof SQLException) {
                return (SQLException)thrownException;
            }
            boolean checkForShutdown = false;
            if (thrownException instanceof StandardException) {
                StandardException se = (StandardException)thrownException;
                int severity = se.getSeverity();
                if (severity <= 20000) {
                    if (autoCommit && rollbackOnAutoCommit) {
                        se.setSeverity(30000);
                    }
                } else if ("08000".equals(se.getMessageId())) {
                    checkForShutdown = true;
                }
            }
            if (this.cm != null) {
                boolean isShutdown = this.cleanupOnError(thrownException);
                if (checkForShutdown && isShutdown) {
                    thrownException = this.shutdownDatabaseException();
                }
            }
            return TransactionResourceImpl.wrapInSQLException(thrownException);
        }
        catch (Throwable t) {
            if (this.cm != null) {
                this.cm.cleanupOnError(t);
            }
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static SQLException wrapInSQLException(Throwable thrownException) {
        if (thrownException == null) {
            return null;
        }
        if (thrownException instanceof SQLException) {
            return (SQLException)thrownException;
        }
        if (thrownException instanceof StandardException) {
            StandardException se = (StandardException)thrownException;
            if (se.getCause() == null) {
                return Util.generateCsSQLException(se);
            }
            return Util.seeNextException(se.getMessageId(), se.getArguments(), TransactionResourceImpl.wrapInSQLException(se.getCause()));
        }
        return Util.javaException(thrownException);
    }

    String getUserName() {
        return this.username;
    }

    boolean cleanupOnError(Throwable e) {
        SanityManager.ASSERT(this.cm != null, "cannot cleanup on error with null context manager");
        return this.cm.cleanupOnError(e);
    }

    boolean isIdle() {
        return this.lcc == null || this.lcc.getTransactionExecute().isIdle();
    }

    boolean isActive() {
        return this.driver.isActive() && (this.database == null || this.database.isActive());
    }
}

