/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.services.monitor.BaseMonitor;

public final class FileMonitor
extends BaseMonitor
implements PrivilegedExceptionAction {
    private File home;
    private ProductVersionHolder engineVersion;
    private int action;
    private String key3;
    private Runnable task;
    private int intValue;

    public FileMonitor() {
        this.initialize(true);
        this.applicationProperties = this.readApplicationProperties();
    }

    public FileMonitor(Properties properties, PrintStream log) {
        this.runWithState(properties, log);
    }

    private InputStream PBapplicationPropertiesStream() throws IOException {
        File sr = FileUtil.newFile(this.home, "derby.properties");
        if (!sr.exists()) {
            return null;
        }
        return new FileInputStream(sr);
    }

    public Object getEnvironment() {
        return this.home;
    }

    private boolean PBinitialize(boolean lite) {
        String systemHome;
        if (!lite) {
            try {
                this.daemonGroup = new ThreadGroup("derby.daemons");
                this.daemonGroup.setDaemon(true);
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        InputStream versionStream = this.getClass().getResourceAsStream("/org/apache/derby/info/DBMS.properties");
        this.engineVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv(versionStream);
        try {
            systemHome = System.getProperty("derby.system.home");
        }
        catch (SecurityException se) {
            systemHome = null;
        }
        if (systemHome != null) {
            this.home = new File(systemHome);
            if (this.home.exists()) {
                if (!this.home.isDirectory()) {
                    this.report("derby.system.home=" + systemHome + " does not represent a directory");
                    return false;
                }
            } else if (!lite) {
                try {
                    boolean created = this.home.mkdir() || this.home.mkdirs();
                }
                catch (SecurityException se) {
                    return false;
                }
            }
        }
        return true;
    }

    private String PBgetJVMProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException se) {
            return null;
        }
    }

    final synchronized boolean initialize(boolean lite) {
        this.action = lite ? 0 : 1;
        try {
            Object ret = AccessController.doPrivileged(this);
            return (Boolean)ret;
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    final synchronized Properties getDefaultModuleProperties() {
        this.action = 2;
        try {
            return (Properties)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    public final synchronized String getJVMProperty(String key) {
        if (!key.startsWith("derby.")) {
            return this.PBgetJVMProperty(key);
        }
        try {
            this.action = 3;
            this.key3 = key;
            String value = (String)AccessController.doPrivileged(this);
            this.key3 = null;
            return value;
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    public final synchronized Thread getDaemonThread(Runnable task, String name, boolean setMinPriority) {
        this.action = 4;
        this.key3 = name;
        this.task = task;
        this.intValue = setMinPriority ? 1 : 0;
        try {
            Thread t = (Thread)AccessController.doPrivileged(this);
            this.key3 = null;
            task = null;
            return t;
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    public final synchronized void setThreadPriority(int priority) {
        this.action = 5;
        this.intValue = priority;
        try {
            AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (RuntimeException)pae.getException();
        }
    }

    final synchronized InputStream applicationPropertiesStream() throws IOException {
        this.action = 6;
        try {
            return (InputStream)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    public final synchronized Object run() throws IOException {
        switch (this.action) {
            case 0: 
            case 1: {
                return new Boolean(this.PBinitialize(this.action == 0));
            }
            case 2: {
                return super.getDefaultModuleProperties();
            }
            case 3: {
                return this.PBgetJVMProperty(this.key3);
            }
            case 4: {
                return super.getDaemonThread(this.task, this.key3, this.intValue != 0);
            }
            case 5: {
                super.setThreadPriority(this.intValue);
                return null;
            }
            case 6: {
                return this.PBapplicationPropertiesStream();
            }
        }
        return null;
    }

    public final ProductVersionHolder getEngineVersion() {
        return this.engineVersion;
    }
}

