/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectLoaderJava2;

public final class ReflectClassesJava2
extends DatabaseClasses
implements PrivilegedAction {
    private HashMap preCompiled;
    private int action = -1;

    synchronized LoadedGeneratedClass loadGeneratedClassFromData(String fullyQualifiedName, ByteArray classDump) {
        if (classDump == null || classDump.getArray() == null) {
            if (this.preCompiled == null) {
                this.preCompiled = new HashMap();
            } else {
                ReflectGeneratedClass gc = (ReflectGeneratedClass)this.preCompiled.get(fullyQualifiedName);
                if (gc != null) {
                    return gc;
                }
            }
            try {
                Class<?> jvmClass = Class.forName(fullyQualifiedName);
                ReflectGeneratedClass gc = new ReflectGeneratedClass(this, jvmClass, null);
                this.preCompiled.put(fullyQualifiedName, gc);
                return gc;
            }
            catch (ClassNotFoundException cnfe) {
                throw new NoClassDefFoundError(cnfe.toString());
            }
        }
        this.action = 1;
        return ((ReflectLoaderJava2)AccessController.doPrivileged(this)).loadGeneratedClass(fullyQualifiedName, classDump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object run() {
        Object var1_3;
        block7: {
            ClassLoader classLoader;
            block6: {
                try {
                    switch (this.action) {
                        case 1: {
                            ReflectLoaderJava2 reflectLoaderJava2 = new ReflectLoaderJava2(this.getClass().getClassLoader(), this);
                            Object var3_4 = null;
                            this.action = -1;
                            return reflectLoaderJava2;
                        }
                        case 2: {
                            classLoader = Thread.currentThread().getContextClassLoader();
                            break block6;
                        }
                        default: {
                            var1_3 = null;
                            break;
                        }
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    this.action = -1;
                    throw throwable;
                }
            }
            Object var3_5 = null;
            this.action = -1;
            return classLoader;
        }
        Object var3_6 = null;
        this.action = -1;
        return var1_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class loadClassNotInDatabaseJar(String name) throws ClassNotFoundException {
        Class<?> foundClass = null;
        try {
            ClassLoader cl;
            ReflectClassesJava2 reflectClassesJava2 = this;
            synchronized (reflectClassesJava2) {
                this.action = 2;
                cl = (ClassLoader)AccessController.doPrivileged(this);
            }
            foundClass = cl != null ? cl.loadClass(name) : Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            foundClass = Class.forName(name);
        }
        return foundClass;
    }
}

