/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Row;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.BaseActivation;

public final class GenericActivationHolder
implements Activation {
    public BaseActivation ac;
    ExecPreparedStatement ps;
    GeneratedClass gc;
    DataTypeDescriptor[] paramTypes;
    private final LanguageConnectionContext lcc;

    GenericActivationHolder(LanguageConnectionContext lcc, GeneratedClass gc, ExecPreparedStatement ps, boolean scrollable) throws StandardException {
        this.lcc = lcc;
        SanityManager.ASSERT(gc != null, "generated class is null , ps is a " + ps.getClass());
        this.gc = gc;
        this.ps = ps;
        this.ac = (BaseActivation)gc.newInstance(lcc);
        this.ac.setupActivation(ps, scrollable);
        this.paramTypes = ps.getParameterTypes();
    }

    public void reset() throws StandardException {
        this.ac.reset();
    }

    public boolean checkIfThisActivationHasHoldCursor(String tableName) {
        return this.ac.checkIfThisActivationHasHoldCursor(tableName);
    }

    public void setCursorName(String cursorName) {
        this.ac.setCursorName(cursorName);
    }

    public String getCursorName() {
        return this.ac.getCursorName();
    }

    public void setResultSetHoldability(boolean resultSetHoldability) {
        this.ac.setResultSetHoldability(resultSetHoldability);
    }

    public boolean getResultSetHoldability() {
        return this.ac.getResultSetHoldability();
    }

    public void setAutoGeneratedKeysResultsetInfo(int[] columnIndexes, String[] columnNames) {
        this.ac.setAutoGeneratedKeysResultsetInfo(columnIndexes, columnNames);
    }

    public boolean getAutoGeneratedKeysResultsetMode() {
        return this.ac.getAutoGeneratedKeysResultsetMode();
    }

    public int[] getAutoGeneratedKeysColumnIndexes() {
        return this.ac.getAutoGeneratedKeysColumnIndexes();
    }

    public String[] getAutoGeneratedKeysColumnNames() {
        return this.ac.getAutoGeneratedKeysColumnNames();
    }

    public LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    public TransactionController getTransactionController() {
        return this.ac.getTransactionController();
    }

    public ExecutionFactory getExecutionFactory() {
        return this.ac.getExecutionFactory();
    }

    public ParameterValueSet getParameterValueSet() {
        return this.ac.getParameterValueSet();
    }

    public void setParameters(ParameterValueSet parameterValues, DataTypeDescriptor[] parameterTypes) throws StandardException {
        this.ac.setParameters(parameterValues, parameterTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execute() throws StandardException {
        CursorActivation activeCursor;
        String cursorName;
        if (this.gc != this.ps.getActivationClass() || !this.ac.isValid()) {
            GeneratedClass newGC;
            if (this.gc != this.ps.getActivationClass()) {
                ExecPreparedStatement execPreparedStatement = this.ps;
                synchronized (execPreparedStatement) {
                    this.ps.rePrepare(this.getLanguageConnectionContext());
                    newGC = this.ps.getActivationClass();
                }
            } else {
                newGC = this.gc;
            }
            BaseActivation newAC = (BaseActivation)newGC.newInstance(this.lcc);
            DataTypeDescriptor[] newParamTypes = this.ps.getParameterTypes();
            newAC.setupActivation(this.ps, this.ac.getScrollable());
            newAC.setParameters(this.ac.getParameterValueSet(), this.paramTypes);
            if (this.ac.isSingleExecution()) {
                newAC.setSingleExecution();
            }
            newAC.setCursorName(this.ac.getCursorName());
            newAC.setResultSetHoldability(this.ac.getResultSetHoldability());
            if (this.ac.getAutoGeneratedKeysResultsetMode()) {
                newAC.setAutoGeneratedKeysResultsetInfo(this.ac.getAutoGeneratedKeysColumnIndexes(), this.ac.getAutoGeneratedKeysColumnNames());
            }
            newAC.setMaxRows(this.ac.getMaxRows());
            this.ac.setupActivation(null, false);
            this.ac.close();
            this.ac = newAC;
            this.gc = newGC;
            this.paramTypes = newParamTypes;
        }
        if ((cursorName = this.ac.getCursorName()) != null && (activeCursor = this.lcc.lookupCursorActivation(cursorName)) != null && activeCursor != this.ac) {
            throw StandardException.newException("X0X60.S", cursorName);
        }
        return this.ac.execute();
    }

    public ResultSet getResultSet() {
        return this.ac.getResultSet();
    }

    public void setCurrentRow(ExecRow currentRow, int resultSetNumber) {
        this.ac.setCurrentRow(currentRow, resultSetNumber);
    }

    public Row getCurrentRow(int resultSetNumber) {
        return this.ac.getCurrentRow(resultSetNumber);
    }

    public void clearCurrentRow(int resultSetNumber) {
        this.ac.clearCurrentRow(resultSetNumber);
    }

    public ExecPreparedStatement getPreparedStatement() {
        return this.ps;
    }

    public void checkStatementValidity() throws StandardException {
        this.ac.checkStatementValidity();
    }

    public ResultDescription getResultDescription() {
        return this.ac.getResultDescription();
    }

    public DataValueFactory getDataValueFactory() {
        return this.ac.getDataValueFactory();
    }

    public RowLocation getRowLocationTemplate(int itemNumber) {
        return this.ac.getRowLocationTemplate(itemNumber);
    }

    public ConglomerateController getHeapConglomerateController() {
        return this.ac.getHeapConglomerateController();
    }

    public void setHeapConglomerateController(ConglomerateController updateHeapCC) {
        this.ac.setHeapConglomerateController(updateHeapCC);
    }

    public void clearHeapConglomerateController() {
        this.ac.clearHeapConglomerateController();
    }

    public ScanController getIndexScanController() {
        return this.ac.getIndexScanController();
    }

    public void setIndexScanController(ScanController indexSC) {
        this.ac.setIndexScanController(indexSC);
    }

    public long getIndexConglomerateNumber() {
        return this.ac.getIndexConglomerateNumber();
    }

    public void setIndexConglomerateNumber(long indexConglomerateNumber) {
        this.ac.setIndexConglomerateNumber(indexConglomerateNumber);
    }

    public void clearIndexScanInfo() {
        this.ac.clearIndexScanInfo();
    }

    public void close() throws StandardException {
        this.ac.close();
    }

    public boolean isClosed() {
        return this.ac.isClosed();
    }

    public void setSingleExecution() {
        this.ac.setSingleExecution();
    }

    public boolean isSingleExecution() {
        return this.ac.isSingleExecution();
    }

    public int getNumSubqueries() {
        return this.ac.getNumSubqueries();
    }

    public void setForCreateTable() {
        this.ac.setForCreateTable();
    }

    public boolean getForCreateTable() {
        return this.ac.getForCreateTable();
    }

    public void setDDLTableDescriptor(TableDescriptor td) {
        this.ac.setDDLTableDescriptor(td);
    }

    public TableDescriptor getDDLTableDescriptor() {
        return this.ac.getDDLTableDescriptor();
    }

    public void setMaxRows(int maxRows) {
        this.ac.setMaxRows(maxRows);
    }

    public int getMaxRows() {
        return this.ac.getMaxRows();
    }

    public void setTargetVTI(java.sql.ResultSet targetVTI) {
        this.ac.setTargetVTI(targetVTI);
    }

    public java.sql.ResultSet getTargetVTI() {
        return this.ac.getTargetVTI();
    }

    public SQLSessionContext getSQLSessionContextForChildren() {
        return this.ac.getSQLSessionContextForChildren();
    }

    public SQLSessionContext setupSQLSessionContextForChildren(boolean push) {
        return this.ac.setupSQLSessionContextForChildren(push);
    }

    public void setParentActivation(Activation a) {
        this.ac.setParentActivation(a);
    }

    public Activation getParentActivation() {
        return this.ac.getParentActivation();
    }

    public DependableFinder getDependableFinder() {
        SanityManager.NOTREACHED();
        return null;
    }

    public String getObjectName() {
        SanityManager.NOTREACHED();
        return null;
    }

    public UUID getObjectID() {
        SanityManager.NOTREACHED();
        return null;
    }

    public String getClassType() {
        SanityManager.NOTREACHED();
        return null;
    }

    public boolean isPersistent() {
        SanityManager.NOTREACHED();
        return false;
    }

    public boolean isValid() {
        SanityManager.NOTREACHED();
        return false;
    }

    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        SanityManager.NOTREACHED();
    }

    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        SanityManager.NOTREACHED();
    }

    public void markUnused() {
        this.ac.markUnused();
    }

    public boolean isInUse() {
        return this.ac.isInUse();
    }

    public void addWarning(SQLWarning w) {
        this.ac.addWarning(w);
    }

    public SQLWarning getWarnings() {
        return this.ac.getWarnings();
    }

    public void clearWarnings() {
        this.ac.clearWarnings();
    }

    public void informOfRowCount(NoPutResultSet resultSet, long rowCount) throws StandardException {
        this.ac.informOfRowCount(resultSet, rowCount);
    }

    public boolean isCursorActivation() {
        return this.ac.isCursorActivation();
    }

    public ConstantAction getConstantAction() {
        return this.ac.getConstantAction();
    }

    public void setParentResultSet(TemporaryRowHolder rs, String resultSetId) {
        this.ac.setParentResultSet(rs, resultSetId);
    }

    public Vector getParentResultSet(String resultSetId) {
        return this.ac.getParentResultSet(resultSetId);
    }

    public void clearParentResultSets() {
        this.ac.clearParentResultSets();
    }

    public Hashtable getParentResultSets() {
        return this.ac.getParentResultSets();
    }

    public void setForUpdateIndexScan(CursorResultSet forUpdateResultSet) {
        this.ac.setForUpdateIndexScan(forUpdateResultSet);
    }

    public CursorResultSet getForUpdateIndexScan() {
        return this.ac.getForUpdateIndexScan();
    }

    public java.sql.ResultSet[][] getDynamicResults() {
        return this.ac.getDynamicResults();
    }

    public int getMaxDynamicResults() {
        return this.ac.getMaxDynamicResults();
    }
}

