/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.Timestamp;
import org.apache.derby.catalog.Statistics;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSSTATISTICSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSSTATISTICS";
    protected static final int SYSSTATISTICS_ID = 1;
    protected static final int SYSSTATISTICS_REFERENCEID = 2;
    protected static final int SYSSTATISTICS_TABLEID = 3;
    protected static final int SYSSTATISTICS_TIMESTAMP = 4;
    protected static final int SYSSTATISTICS_TYPE = 5;
    protected static final int SYSSTATISTICS_VALID = 6;
    protected static final int SYSSTATISTICS_COLCOUNT = 7;
    protected static final int SYSSTATISTICS_STAT = 8;
    protected static final int SYSSTATISTICS_COLUMN_COUNT = 8;
    protected static final int SYSSTATISTICS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = new boolean[]{false};
    private static final int[][] indexColumnPositions = new int[][]{{3, 2}};
    private static final String[] uuids = new String[]{"f81e0010-00e3-6612-5a96-009e3a3b5e00", "08264012-00e3-6612-5a96-009e3a3b5e00", "c013800d-00e3-ffbe-37c6-009e3a3b5e00"};

    SYSSTATISTICSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(8, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String myID = null;
        String referenceID = null;
        String tableID = null;
        Object statName = null;
        Object colMap = null;
        String statType = null;
        Timestamp updateTime = null;
        int columnCount = 0;
        Statistics statisticsObject = null;
        boolean validStat = false;
        ExecRow row = this.getExecutionFactory().getValueRow(8);
        if (td != null) {
            StatisticsDescriptor statDesc = (StatisticsDescriptor)td;
            myID = statDesc.getUUID().toString();
            tableID = statDesc.getTableUUID().toString();
            referenceID = statDesc.getReferenceID().toString();
            updateTime = statDesc.getUpdateTimestamp();
            statType = statDesc.getStatType();
            validStat = statDesc.isValid();
            statisticsObject = statDesc.getStatistic();
            columnCount = statDesc.getColumnCount();
        }
        row.setColumn(1, new SQLChar(myID));
        row.setColumn(2, new SQLChar(referenceID));
        row.setColumn(3, new SQLChar(tableID));
        row.setColumn(4, new SQLTimestamp(updateTime));
        row.setColumn(5, new SQLChar(statType));
        row.setColumn(6, this.dvf.getDataValue(validStat));
        row.setColumn(7, this.dvf.getDataValue(columnCount));
        row.setColumn(8, this.dvf.getDataValue(statisticsObject));
        return row;
    }

    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentDesc, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT(row.nColumns() == 8, "Wrong number of columns for a SYSSTATISTICS row");
        UUIDFactory uuidFactory = this.getUUIDFactory();
        DataValueDescriptor col = row.getColumn(1);
        String scratch = col.getString();
        UUID statUUID = uuidFactory.recreateUUID(scratch);
        col = row.getColumn(2);
        scratch = col.getString();
        UUID statReferenceUUID = uuidFactory.recreateUUID(scratch);
        col = row.getColumn(3);
        scratch = col.getString();
        UUID statTableUUID = uuidFactory.recreateUUID(scratch);
        col = row.getColumn(4);
        Timestamp updateTime = (Timestamp)col.getObject();
        col = row.getColumn(5);
        String statType = col.getString();
        col = row.getColumn(6);
        boolean valid = col.getBoolean();
        col = row.getColumn(7);
        int columnCount = col.getInt();
        col = row.getColumn(8);
        Statistics stat = (Statistics)col.getObject();
        return new StatisticsDescriptor(dd, statUUID, statReferenceUUID, statTableUUID, statType, stat, columnCount);
    }

    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("STATID", false), SystemColumnImpl.getUUIDColumn("REFERENCEID", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getColumn("CREATIONTIMESTAMP", 93, false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getColumn("VALID", 16, false), SystemColumnImpl.getColumn("COLCOUNT", 4, false), SystemColumnImpl.getJavaColumn("STATISTICS", "org.apache.derby.catalog.Statistics", false)};
    }
}

