/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class BooleanTypeCompiler
extends BaseTypeCompiler {
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        return otherJDBCTypeId != 91 && otherJDBCTypeId != 92 && otherJDBCTypeId != 93;
    }

    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    public boolean storable(TypeId otherType, ClassFactory cf) {
        if (otherType.isBooleanTypeId() || otherType.isStringTypeId() || otherType.isNumericTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), otherType, cf);
    }

    public String interfaceName() {
        return "org.apache.derby.iapi.types.BooleanDataValue";
    }

    public String getCorrespondingPrimitiveTypeName() {
        return "boolean";
    }

    public String getPrimitiveMethodName() {
        return "getBoolean";
    }

    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 5;
    }

    String nullMethodName() {
        return "getNullBoolean";
    }
}

