/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class ConstantNode
extends ValueNode {
    DataValueDescriptor value;

    public void init(Object typeId, Object nullable, Object maximumWidth) throws StandardException {
        this.setType((TypeId)typeId, (Boolean)nullable, (Integer)maximumWidth);
    }

    ConstantNode() {
    }

    void setValue(DataValueDescriptor value) {
        this.value = value;
    }

    public DataValueDescriptor getValue() {
        return this.value;
    }

    public String toString() {
        return "value: " + this.value + "\n" + super.toString();
    }

    public boolean isCloneable() {
        return true;
    }

    public ValueNode getClone() {
        return this;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        return this;
    }

    public boolean isConstantExpression() {
        return true;
    }

    public boolean constantExpression(PredicateList whereClause) {
        return true;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.isNull()) {
            acb.generateNull(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        } else {
            this.generateConstant(acb, mb);
            acb.generateDataValue(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType(), null);
        }
    }

    abstract void generateConstant(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    boolean isNull() {
        return this.value == null || this.value.isNull();
    }

    protected int getOrderableVariantType() {
        return 3;
    }

    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            ConstantNode other = (ConstantNode)o;
            return other.getValue() == null && this.getValue() == null || other.getValue() != null && other.getValue().compare(this.getValue()) == 0;
        }
        return false;
    }
}

