/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;

abstract class DDLStatementNode
extends StatementNode {
    public static final int UNKNOWN_TYPE = 0;
    public static final int ADD_TYPE = 1;
    public static final int DROP_TYPE = 2;
    public static final int MODIFY_TYPE = 3;
    public static final int LOCKING_TYPE = 4;
    private TableName objectName;
    private boolean initOk;
    boolean implicitCreateSchema;

    DDLStatementNode() {
    }

    public void init(Object objectName) throws StandardException {
        this.initAndCheck(objectName);
    }

    protected void initAndCheck(Object objectName) throws StandardException {
        this.objectName = (TableName)objectName;
        this.initOk = true;
    }

    public boolean isAtomic() {
        return true;
    }

    public String getRelativeName() {
        return this.objectName.getTableName();
    }

    public String getFullName() {
        return this.objectName.getFullTableName();
    }

    public final TableName getObjectName() {
        return this.objectName;
    }

    public String toString() {
        return (this.objectName == null ? "" : this.objectName.toString()) + super.toString();
    }

    int activationKind() {
        return 5;
    }

    public final void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (!this.initOk) {
            SanityManager.THROWASSERT(this.getClass() + " never called initAndCheck()");
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getDDLResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    protected final SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(true, true);
    }

    protected final SchemaDescriptor getSchemaDescriptor(boolean ownerCheck, boolean doSystemSchemaCheck) throws StandardException {
        String schemaName = this.objectName.getSchemaName();
        boolean needError = !this.implicitCreateSchema;
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName, needError);
        CompilerContext cc = this.getCompilerContext();
        if (sd == null) {
            if (schemaName.startsWith("SYS")) {
                throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)schemaName);
            }
            sd = new SchemaDescriptor(this.getDataDictionary(), schemaName, null, null, false);
            if (this.isPrivilegeCollectionRequired()) {
                cc.addRequiredSchemaPriv(schemaName, null, 16);
            }
        }
        if (ownerCheck && this.isPrivilegeCollectionRequired()) {
            cc.addRequiredSchemaPriv(sd.getSchemaName(), null, 17);
        }
        if (doSystemSchemaCheck && sd.isSystemSchema()) {
            throw StandardException.newException("42X62", (Object)this.statementToString(), (Object)sd);
        }
        return sd;
    }

    protected final TableDescriptor getTableDescriptor() throws StandardException {
        return this.getTableDescriptor(this.objectName);
    }

    protected final TableDescriptor getTableDescriptor(boolean doSystemTableCheck) throws StandardException {
        TableDescriptor td = this.justGetDescriptor(this.objectName);
        td = this.checkTableDescriptor(td, doSystemTableCheck);
        return td;
    }

    protected final TableDescriptor getTableDescriptor(UUID tableId) throws StandardException {
        TableDescriptor td = this.getDataDictionary().getTableDescriptor(tableId);
        td = this.checkTableDescriptor(td, true);
        return td;
    }

    protected final TableDescriptor getTableDescriptor(TableName tableName) throws StandardException {
        TableDescriptor td = this.justGetDescriptor(tableName);
        td = this.checkTableDescriptor(td, true);
        return td;
    }

    private TableDescriptor justGetDescriptor(TableName tableName) throws StandardException {
        String schemaName = tableName.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(schemaName);
        TableDescriptor td = this.getTableDescriptor(tableName.getTableName(), sd);
        if (td == null) {
            throw StandardException.newException("42Y55", (Object)this.statementToString(), (Object)tableName);
        }
        return td;
    }

    private TableDescriptor checkTableDescriptor(TableDescriptor td, boolean doSystemTableCheck) throws StandardException {
        String sqlState = null;
        switch (td.getTableType()) {
            case 5: {
                sqlState = "X0Y56.S";
                break;
            }
            case 1: {
                if (doSystemTableCheck) {
                    sqlState = "X0Y56.S";
                    break;
                }
                return td;
            }
            case 0: {
                return this.lockTableForCompilation(td);
            }
            case 3: {
                return td;
            }
            case 2: {
                sqlState = "42Y62";
            }
        }
        throw StandardException.newException(sqlState, (Object)this.statementToString(), (Object)td.getQualifiedName());
    }

    void bindName(DataDictionary dataDictionary) throws StandardException {
        if (this.objectName != null) {
            this.objectName.bind(dataDictionary);
        }
    }

    FromList makeFromList(DataDictionary dd, TableElementList tableElementList, boolean creatingTable) throws StandardException {
        TableName tableName = this.getObjectName();
        if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(this.getSchemaDescriptor().getSchemaName());
        }
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        FromBaseTable table = (FromBaseTable)this.getNodeFactory().getNode(135, tableName, null, null, null, this.getContextManager());
        if (creatingTable) {
            table.setTableNumber(0);
            fromList.addFromTable(table);
            table.setResultColumns((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()));
        } else {
            fromList.addFromTable(table);
            fromList.bindTables(dd, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()));
        }
        tableElementList.appendNewColumnsToRCL(table);
        return fromList;
    }
}

