/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class UnaryDateTimestampOperatorNode
extends UnaryOperatorNode {
    private static final String TIMESTAMP_METHOD_NAME = "getTimestamp";
    private static final String DATE_METHOD_NAME = "getDate";

    public void init(Object operand, Object targetType) throws StandardException {
        this.setType((DataTypeDescriptor)targetType);
        switch (this.getTypeServices().getJDBCTypeId()) {
            case 91: {
                super.init(operand, "date", DATE_METHOD_NAME);
                break;
            }
            case 93: {
                super.init(operand, "timestamp", TIMESTAMP_METHOD_NAME);
                break;
            }
            default: {
                SanityManager.NOTREACHED();
                super.init(operand);
            }
        }
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        boolean isIdentity = false;
        boolean operandIsNumber = false;
        this.bindOperand(fromList, subqueryList, aggregateVector);
        DataTypeDescriptor operandType = this.operand.getTypeServices();
        switch (operandType.getJDBCTypeId()) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                operandIsNumber = true;
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 91: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                isIdentity = true;
                break;
            }
            case 0: {
                break;
            }
            case 93: {
                if (!TIMESTAMP_METHOD_NAME.equals(this.methodName)) break;
                isIdentity = true;
                break;
            }
            default: {
                this.invalidOperandType();
            }
        }
        if (this.operand instanceof ConstantNode) {
            DataValueFactory dvf = this.getLanguageConnectionContext().getDataValueFactory();
            DataValueDescriptor sourceValue = ((ConstantNode)this.operand).getValue();
            DateTimeDataValue destValue = null;
            destValue = sourceValue.isNull() ? (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dvf.getNullTimestamp(null) : dvf.getNullDate(null)) : (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dvf.getTimestamp(sourceValue) : dvf.getDate(sourceValue));
            return (ValueNode)this.getNodeFactory().getNode(76, destValue, this.getContextManager());
        }
        if (isIdentity) {
            return this.operand;
        }
        return this;
    }

    private void invalidOperandType() throws StandardException {
        throw StandardException.newException("42X25", (Object)this.getOperatorString(), (Object)this.getOperand().getTypeServices().getSQLstring());
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushDataValueFactory(mb);
        this.operand.generateExpression(acb, mb);
        mb.cast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.callMethod((short)185, null, this.methodName, this.getTypeCompiler().interfaceName(), 1);
    }
}

