/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class CardinalityCounter
implements RowLocationRetRowSource {
    private RowLocationRetRowSource rowSource;
    private DataValueDescriptor[] prevKey;
    private long[] cardinality;
    private long numRows;

    public CardinalityCounter(RowLocationRetRowSource rowSource) {
        this.rowSource = rowSource;
    }

    public boolean needsRowLocation() {
        return this.rowSource.needsRowLocation();
    }

    public void rowLocation(RowLocation rl) throws StandardException {
        this.rowSource.rowLocation(rl);
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        DataValueDescriptor[] nextRow = this.rowSource.getNextRowFromRowSource();
        if (nextRow != null) {
            this.keepCount(nextRow);
        }
        return nextRow;
    }

    public boolean needsToClone() {
        return this.rowSource.needsToClone();
    }

    public FormatableBitSet getValidColumns() {
        return this.rowSource.getValidColumns();
    }

    public void closeRowSource() {
        this.rowSource.closeRowSource();
    }

    private DataValueDescriptor[] clone(DataValueDescriptor[] clonee) {
        DataValueDescriptor[] cloned = new DataValueDescriptor[clonee.length];
        for (int i = 0; i < clonee.length - 1; ++i) {
            cloned[i] = clonee[i].getClone();
        }
        return cloned;
    }

    public void keepCount(DataValueDescriptor[] currentKey) throws StandardException {
        int i;
        int numKeys = currentKey.length - 1;
        ++this.numRows;
        if (this.prevKey == null) {
            this.prevKey = this.clone(currentKey);
            this.cardinality = new long[currentKey.length - 1];
            for (int i2 = 0; i2 < numKeys; ++i2) {
                this.cardinality[i2] = 1L;
            }
            return;
        }
        for (i = 0; i < numKeys && !this.prevKey[i].isNull(); ++i) {
            if (this.prevKey[i].compare(currentKey[i]) == 0) continue;
            this.prevKey = null;
            this.prevKey = this.clone(currentKey);
            break;
        }
        int j = i;
        while (j < numKeys) {
            int n = j++;
            this.cardinality[n] = this.cardinality[n] + 1L;
        }
    }

    public long[] getCardinality() {
        return this.cardinality;
    }

    public long getRowCount() {
        return this.numRows;
    }
}

