/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RIBulkChecker;

public abstract class ConstraintConstantAction
extends DDLSingleTableConstantAction {
    protected String constraintName;
    protected int constraintType;
    protected String tableName;
    protected String schemaName;
    protected UUID schemaId;
    protected IndexConstantAction indexAction;

    ConstraintConstantAction(String constraintName, int constraintType, String tableName, UUID tableId, String schemaName, IndexConstantAction indexAction) {
        super(tableId);
        this.constraintName = constraintName;
        this.constraintType = constraintType;
        this.tableName = tableName;
        this.indexAction = indexAction;
        this.schemaName = schemaName;
        SanityManager.ASSERT(schemaName != null, "Constraint schema name is null");
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public IndexConstantAction getIndexAction() {
        return this.indexAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateFKConstraint(TransactionController tc, DataDictionary dd, ForeignKeyConstraintDescriptor fk, ReferencedKeyConstraintDescriptor refcd, ExecRow indexTemplateRow) throws StandardException {
        GenericScanController refScan = null;
        GroupFetchScanController fkScan = tc.openGroupFetchScan(fk.getIndexConglomerateDescriptor(dd).getConglomerateNumber(), false, 0, 7, 2, null, null, 1, null, null, -1);
        try {
            if (!fkScan.next()) {
                fkScan.close();
                return;
            }
            fkScan.reopenScan(null, 1, null, null, -1);
            refScan = tc.openGroupFetchScan(refcd.getIndexConglomerateDescriptor(dd).getConglomerateNumber(), false, 0, 6, 2, null, null, 1, null, null, -1);
            RIBulkChecker riChecker = new RIBulkChecker((GroupFetchScanController)refScan, fkScan, indexTemplateRow, true, null, null);
            int numFailures = riChecker.doCheck();
            if (numFailures > 0) {
                StandardException se = StandardException.newException("X0Y45.S", (Object)fk.getConstraintName(), (Object)fk.getTableDescriptor().getName());
                throw se;
            }
        }
        finally {
            if (fkScan != null) {
                fkScan.close();
                fkScan = null;
            }
            if (refScan != null) {
                refScan.close();
                refScan = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validateConstraint(String constraintName, String constraintText, TableDescriptor td, LanguageConnectionContext lcc, boolean isCheckConstraint) throws StandardException {
        StringBuffer checkStmt = new StringBuffer();
        checkStmt.append("SELECT COUNT(*) FROM ");
        checkStmt.append(td.getQualifiedName());
        checkStmt.append(" WHERE NOT(");
        checkStmt.append(constraintText);
        checkStmt.append(")");
        ResultSet rs = null;
        try {
            PreparedStatement ps = lcc.prepareInternalStatement(checkStmt.toString());
            rs = ps.executeSubStatement(lcc, false, 0L);
            ExecRow row = rs.getNextRow();
            if (row == null) {
                SanityManager.THROWASSERT("did not get any rows back from query: " + checkStmt.toString());
            }
            DataValueDescriptor[] rowArray = row.getRowArray();
            Number value = (Number)((NumberDataValue)row.getRowArray()[0]).getObject();
            if (value != null && value.longValue() != 0L) {
                if (isCheckConstraint) {
                    throw StandardException.newException("X0Y59.S", (Object)constraintName, (Object)td.getQualifiedName(), (Object)value.toString());
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return true;
    }
}

