/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRolePermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.CreateSchemaConstantAction;

abstract class DDLConstantAction
implements ConstantAction {
    DDLConstantAction() {
    }

    static SchemaDescriptor getAndCheckSchemaDescriptor(DataDictionary dd, UUID schemaId, String statementType) throws StandardException {
        SchemaDescriptor sd = dd.getSchemaDescriptor(schemaId, null);
        return sd;
    }

    static SchemaDescriptor getSchemaDescriptorForCreate(DataDictionary dd, Activation activation, String schemaName) throws StandardException {
        TransactionController tc = activation.getLanguageConnectionContext().getTransactionExecute();
        SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, false);
        if (sd == null || sd.getUUID() == null) {
            block5: {
                CreateSchemaConstantAction csca = new CreateSchemaConstantAction(schemaName, null);
                if (activation.getLanguageConnectionContext().isInitialDefaultSchema(schemaName)) {
                    DDLConstantAction.executeCAPreferSubTrans(csca, tc, activation);
                } else {
                    try {
                        csca.executeConstantAction(activation);
                    }
                    catch (StandardException se) {
                        if (se.getMessageId().equals("X0Y68.S")) break block5;
                        throw se;
                    }
                }
            }
            sd = dd.getSchemaDescriptor(schemaName, tc, true);
        }
        return sd;
    }

    private static void executeCAPreferSubTrans(CreateSchemaConstantAction csca, TransactionController tc, Activation activation) throws StandardException {
        TransactionController useTc = null;
        TransactionController nestedTc = null;
        try {
            useTc = nestedTc = tc.startNestedUserTransaction(false);
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT("Unexpected: not able to start nested transaction to auto-create schema", e);
            useTc = tc;
        }
        while (true) {
            try {
                csca.executeConstantAction(activation, useTc);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("40XL1")) {
                    if (useTc == nestedTc) {
                        useTc = tc;
                        nestedTc.destroy();
                        continue;
                    }
                } else if (se.getMessageId().equals("X0Y68.S")) break;
                if (useTc == nestedTc) {
                    nestedTc.destroy();
                }
                throw se;
            }
            break;
        }
        if (useTc == nestedTc) {
            nestedTc.commit();
            nestedTc.destroy();
        }
    }

    final void lockTableForDDL(TransactionController tc, long heapConglomerateNumber, boolean exclusiveMode) throws StandardException {
        ConglomerateController cc = tc.openConglomerate(heapConglomerateNumber, false, exclusiveMode ? 68 : 64, 7, 5);
        cc.close();
    }

    protected String constructToString(String statementType, String objectName) {
        return statementType + objectName;
    }

    protected void storeConstraintDependenciesOnPrivileges(Activation activation, Dependent dependent, UUID refTableUUID, ProviderInfo[] providers) throws StandardException {
        List requiredPermissionsList;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        String dbo = dd.getAuthorizationDatabaseOwner();
        String authId = lcc.getAuthorizationId();
        SettableBoolean roleDepAdded = new SettableBoolean();
        if (!lcc.getAuthorizationId().equals(dd.getAuthorizationDatabaseOwner()) && (requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !requiredPermissionsList.isEmpty()) {
            Iterator iter = requiredPermissionsList.iterator();
            while (iter.hasNext()) {
                PermissionsDescriptor permDesc;
                StatementPermission statPerm = (StatementPermission)iter.next();
                if (statPerm instanceof StatementTablePermission) {
                    StatementTablePermission statementTablePermission = (StatementTablePermission)statPerm;
                    if (statementTablePermission.getPrivType() != 2 || !statementTablePermission.getTableUUID().equals(refTableUUID)) {
                        continue;
                    }
                } else {
                    if (statPerm instanceof StatementSchemaPermission || statPerm instanceof StatementRolePermission) continue;
                    SanityManager.ASSERT(statPerm instanceof StatementRoutinePermission, "only StatementRoutinePermission expected");
                    StatementRoutinePermission rp = (StatementRoutinePermission)statPerm;
                    if (!this.inProviderSet(providers, rp.getRoutineUUID())) continue;
                }
                if ((permDesc = statPerm.getPermissionDescriptor(lcc.getAuthorizationId(), dd)) == null) {
                    permDesc = statPerm.getPermissionDescriptor("PUBLIC", dd);
                    boolean roleUsed = false;
                    if (permDesc == null || permDesc instanceof ColPermsDescriptor && !((StatementColumnPermission)statPerm).allColumnsCoveredByUserOrPUBLIC(lcc.getAuthorizationId(), dd)) {
                        roleUsed = true;
                        permDesc = DDLConstantAction.findRoleUsage(activation, statPerm);
                    }
                    if (!permDesc.checkOwner(lcc.getAuthorizationId())) {
                        dm.addDependency(dependent, permDesc, lcc.getContextManager());
                        if (roleUsed) {
                            DDLConstantAction.trackRoleDependency(activation, dependent, roleDepAdded);
                        }
                    }
                } else if (!permDesc.checkOwner(lcc.getAuthorizationId())) {
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                    if (permDesc instanceof ColPermsDescriptor) {
                        StatementColumnPermission statementColumnPermission = (StatementColumnPermission)statPerm;
                        permDesc = statementColumnPermission.getPUBLIClevelColPermsDescriptor(lcc.getAuthorizationId(), dd);
                        if (permDesc != null && permDesc.getObjectID() != null) {
                            dm.addDependency(dependent, permDesc, lcc.getContextManager());
                        }
                        if (!statementColumnPermission.allColumnsCoveredByUserOrPUBLIC(lcc.getAuthorizationId(), dd)) {
                            DDLConstantAction.trackRoleDependency(activation, dependent, roleDepAdded);
                        }
                    }
                }
                if (statPerm instanceof StatementRoutinePermission) continue;
                break;
            }
        }
    }

    private static PermissionsDescriptor findRoleUsage(Activation activation, StatementPermission statPerm) throws StandardException {
        String graphGrant;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        RoleGrantDescriptor rootGrant = null;
        String role = lcc.getCurrentRoleId(activation);
        String dbo = dd.getAuthorizationDatabaseOwner();
        String authId = lcc.getAuthorizationId();
        PermissionsDescriptor permDesc = null;
        SanityManager.ASSERT(role != null, "Unexpected: current role is not set");
        rootGrant = dd.getRoleGrantDescriptor(role, authId, dbo);
        if (rootGrant == null) {
            rootGrant = dd.getRoleGrantDescriptor(role, "PUBLIC", dbo);
        }
        RoleClosureIterator rci = dd.createRoleClosureIterator(activation.getTransactionController(), role, true);
        while (permDesc == null && (graphGrant = rci.next()) != null) {
            permDesc = statPerm.getPermissionDescriptor(graphGrant, dd);
        }
        SanityManager.ASSERT(permDesc != null, "Unexpected: Permission needs to be found via role");
        return permDesc;
    }

    private static void trackRoleDependency(Activation activation, Dependent dependent, SettableBoolean roleDepAdded) throws StandardException {
        if (!roleDepAdded.get()) {
            LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
            DataDictionary dd = lcc.getDataDictionary();
            DependencyManager dm = dd.getDependencyManager();
            String role = lcc.getCurrentRoleId(activation);
            RoleGrantDescriptor rgd = dd.getRoleDefinitionDescriptor(role);
            dm.addDependency(dependent, rgd, lcc.getContextManager());
            roleDepAdded.set(true);
        }
    }

    protected void storeViewTriggerDependenciesOnPrivileges(Activation activation, Dependent dependent) throws StandardException {
        List requiredPermissionsList;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        String dbo = dd.getAuthorizationDatabaseOwner();
        String authId = lcc.getAuthorizationId();
        SettableBoolean roleDepAdded = new SettableBoolean();
        if (!authId.equals(dbo) && (requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !requiredPermissionsList.isEmpty()) {
            Iterator iter = requiredPermissionsList.iterator();
            while (iter.hasNext()) {
                StatementPermission statPerm = (StatementPermission)iter.next();
                if (statPerm instanceof StatementSchemaPermission || statPerm instanceof StatementRolePermission) {
                    if (!(statPerm instanceof StatementRolePermission)) continue;
                    SanityManager.THROWASSERT("Unexpected StatementRolePermission");
                    continue;
                }
                PermissionsDescriptor permDesc = statPerm.getPermissionDescriptor(lcc.getAuthorizationId(), dd);
                if (permDesc == null) {
                    permDesc = statPerm.getPermissionDescriptor("PUBLIC", dd);
                    boolean roleUsed = false;
                    if (permDesc == null || permDesc instanceof ColPermsDescriptor && !((StatementColumnPermission)statPerm).allColumnsCoveredByUserOrPUBLIC(lcc.getAuthorizationId(), dd)) {
                        roleUsed = true;
                        permDesc = DDLConstantAction.findRoleUsage(activation, statPerm);
                    }
                    if (permDesc.checkOwner(lcc.getAuthorizationId())) continue;
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                    if (!roleUsed) continue;
                    DDLConstantAction.trackRoleDependency(activation, dependent, roleDepAdded);
                    continue;
                }
                if (permDesc.checkOwner(lcc.getAuthorizationId())) continue;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
                if (!(permDesc instanceof ColPermsDescriptor)) continue;
                StatementColumnPermission statementColumnPermission = (StatementColumnPermission)statPerm;
                permDesc = statementColumnPermission.getPUBLIClevelColPermsDescriptor(lcc.getAuthorizationId(), dd);
                if (permDesc != null && permDesc.getObjectID() != null) {
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                }
                if (statementColumnPermission.allColumnsCoveredByUserOrPUBLIC(lcc.getAuthorizationId(), dd)) continue;
                DDLConstantAction.trackRoleDependency(activation, dependent, roleDepAdded);
            }
        }
    }

    private boolean inProviderSet(ProviderInfo[] providers, UUID routineId) {
        if (providers == null) {
            return false;
        }
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].getObjectId().equals(routineId)) continue;
            return true;
        }
        return false;
    }

    protected void addColumnDependencies(LanguageConnectionContext lcc, DataDictionary dd, TableDescriptor td, ColumnInfo ci) throws StandardException {
        ProviderInfo[] providers = ci.providers;
        if (providers != null) {
            DependencyManager dm = dd.getDependencyManager();
            ContextManager cm = lcc.getContextManager();
            int providerCount = providers.length;
            ColumnDescriptor cd = td.getColumnDescriptor(ci.name);
            DefaultDescriptor defDesc = cd.getDefaultDescriptor(dd);
            for (int px = 0; px < providerCount; ++px) {
                ProviderInfo pi = providers[px];
                DependableFinder finder = pi.getDependableFinder();
                UUID providerID = pi.getObjectId();
                Provider provider = (Provider)finder.getDependable(dd, providerID);
                dm.addDependency(defDesc, provider, cm);
            }
        }
    }

    private class SettableBoolean {
        boolean value = false;

        SettableBoolean() {
        }

        void set(boolean b) {
            this.value = b;
        }

        boolean get() {
            return this.value;
        }
    }
}

