/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class GrantRoleConstantAction
extends DDLConstantAction {
    private List roleNames;
    private List grantees;
    private final boolean withAdminOption = false;

    public GrantRoleConstantAction(List roleNames, List grantees) {
        this.roleNames = roleNames;
        this.grantees = grantees;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        String grantor = lcc.getAuthorizationId();
        dd.startWriting(lcc);
        Iterator rIter = this.roleNames.iterator();
        while (rIter.hasNext()) {
            String role = (String)rIter.next();
            if (role.equals("PUBLIC")) {
                throw StandardException.newException("4251B");
            }
            Iterator gIter = this.grantees.iterator();
            while (gIter.hasNext()) {
                String grantee = (String)gIter.next();
                RoleGrantDescriptor rdDef = dd.getRoleDefinitionDescriptor(role);
                if (rdDef == null) {
                    throw StandardException.newException("0P000", role);
                }
                if (!grantor.equals(lcc.getDataDictionary().getAuthorizationDatabaseOwner())) {
                    throw StandardException.newException("4251A", "GRANT role");
                }
                SanityManager.ASSERT(rdDef.getGrantee().equals(grantor), "expected database owner in role grant descriptor");
                SanityManager.ASSERT(rdDef.isWithAdminOption(), "expected role definition to have ADMIN OPTION");
                RoleGrantDescriptor rgd = dd.getRoleGrantDescriptor(role, grantee, grantor);
                if (rgd != null) {
                    // empty if block
                }
                if (rgd != null) continue;
                RoleGrantDescriptor granteeDef = dd.getRoleDefinitionDescriptor(grantee);
                if (granteeDef != null) {
                    this.checkCircularity(role, grantee, grantor, tc, dd);
                }
                rgd = ddg.newRoleGrantDescriptor(dd.getUUIDFactory().createUUID(), role, grantee, grantor, false, false);
                dd.addDescriptor(rgd, null, 19, false, tc);
            }
        }
    }

    private void checkCircularity(String role, String grantee, String grantor, TransactionController tc, DataDictionary dd) throws StandardException {
        String r;
        RoleClosureIterator rci = dd.createRoleClosureIterator(tc, grantee, false);
        while ((r = rci.next()) != null) {
            if (!role.equals(r)) continue;
            throw StandardException.newException("4251C", (Object)role, (Object)grantee);
        }
    }

    public String toString() {
        StringBuffer sb1 = new StringBuffer();
        Iterator it = this.roleNames.iterator();
        while (it.hasNext()) {
            if (sb1.length() > 0) {
                sb1.append(", ");
            }
            sb1.append(it.next().toString());
        }
        StringBuffer sb2 = new StringBuffer();
        Iterator it2 = this.grantees.iterator();
        while (it2.hasNext()) {
            if (sb2.length() > 0) {
                sb2.append(", ");
            }
            sb2.append(it2.next().toString());
        }
        return "GRANT " + sb1.toString() + " TO: " + sb2.toString() + "\n";
    }
}

