/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;

public class SetReservedSpaceOperation
extends PageBasicOperation {
    protected int doMeSlot;
    protected int recordId;
    protected int newValue;
    protected int oldValue;

    public SetReservedSpaceOperation(BasePage page, int slot, int recordId, int newValue, int oldValue) {
        super(page);
        this.doMeSlot = slot;
        this.recordId = recordId;
        this.newValue = newValue;
        this.oldValue = oldValue;
        SanityManager.ASSERT(oldValue > newValue);
    }

    public SetReservedSpaceOperation() {
    }

    public int getTypeFormatId() {
        return 287;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.doMeSlot);
        CompressedNumber.writeInt(out, this.recordId);
        CompressedNumber.writeInt(out, this.newValue);
        CompressedNumber.writeInt(out, this.oldValue);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.doMeSlot = CompressedNumber.readInt(in);
        this.recordId = CompressedNumber.readInt(in);
        this.newValue = CompressedNumber.readInt(in);
        this.oldValue = CompressedNumber.readInt(in);
    }

    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        SanityManager.ASSERT(this.oldValue == this.page.getReservedCount(this.doMeSlot));
        SanityManager.ASSERT(this.newValue < this.oldValue, "cannot set reserved space to be bigger than before");
        this.page.setReservedSpace(instant, this.doMeSlot, this.newValue);
    }

    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(this.recordId, 0);
        if (!this.getPageId().equals(undoPage.getPageId())) {
            SanityManager.THROWASSERT("restoreMe cannot restore to a different page. doMe page:" + this.getPageId() + " undoPage:" + undoPage.getPageId());
        }
        if (slot != this.doMeSlot) {
            SanityManager.THROWASSERT("restoreMe cannot restore to a different slot. doMe slot:" + this.doMeSlot + " undoMe slot: " + slot + " recordId:" + this.recordId);
        }
        this.page.setReservedSpace(CLRinstant, slot, this.oldValue);
    }

    public String toString() {
        return super.toString() + "Set Reserved space of recordId " + this.recordId + " from " + this.oldValue + " to " + this.newValue;
    }
}

