/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.xact.Xact;

final class XactContext
extends ContextImpl {
    private RawTransaction xact;
    private RawStoreFactory factory;
    private boolean abortAll;

    XactContext(ContextManager cm, String name, Xact xact, boolean abortAll, RawStoreFactory factory) {
        super(cm, name);
        this.xact = xact;
        this.abortAll = abortAll;
        this.factory = factory;
        xact.xc = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanupOnError(Throwable error) throws StandardException {
        boolean throwAway;
        block12: {
            block11: {
                SanityManager.ASSERT(this.getContextManager() != null);
                throwAway = false;
                if (!(error instanceof StandardException)) break block11;
                StandardException se = (StandardException)error;
                if (this.abortAll) {
                    if (se.getSeverity() < 30000) {
                        throw StandardException.newException("40XT5", error);
                    }
                    throwAway = true;
                    break block12;
                } else {
                    if (se.getSeverity() < 30000) {
                        return;
                    }
                    if (se.getSeverity() >= 40000) {
                        throwAway = true;
                    }
                }
                break block12;
            }
            throwAway = true;
        }
        try {
            block10: {
                try {
                    if (this.xact == null) break block10;
                    this.xact.abort();
                }
                catch (StandardException se) {
                    throwAway = true;
                    if (se.getSeverity() <= 40000 && se.getSeverity() >= ((StandardException)error).getSeverity()) {
                        throw this.factory.markCorrupt(StandardException.newException("XSTB0.M", se));
                    }
                    Object var5_6 = null;
                    if (!throwAway) return;
                    this.xact.close();
                    this.xact = null;
                    return;
                }
            }
            Object var5_5 = null;
            if (!throwAway) return;
            this.xact.close();
            this.xact = null;
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!throwAway) throw throwable;
            this.xact.close();
            this.xact = null;
            throw throwable;
        }
    }

    RawTransaction getTransaction() {
        return this.xact;
    }

    RawStoreFactory getFactory() {
        return this.factory;
    }

    void substituteTransaction(Xact newTran) {
        Xact oldTran = (Xact)this.xact;
        if (oldTran.xc == this) {
            oldTran.xc = null;
        }
        this.xact = newTran;
        ((Xact)this.xact).xc = this;
    }
}

