/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.xact.TransactionId;

public class XactId
implements TransactionId {
    private long id;

    public XactId(long id) {
        this.id = id;
    }

    public XactId() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeLong(out, this.id);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.id = CompressedNumber.readLong(in);
    }

    public int getTypeFormatId() {
        return 147;
    }

    public int getMaxStoredSize() {
        return FormatIdUtil.getFormatIdByteLength(147) + 8;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        try {
            XactId oxid = (XactId)other;
            return this.id == oxid.id;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public static long compare(TransactionId a, TransactionId b) {
        if (a == null || b == null) {
            if (a == null) {
                return -1L;
            }
            if (b == null) {
                return 1L;
            }
            return 0L;
        }
        SanityManager.ASSERT(a instanceof XactId);
        SanityManager.ASSERT(b instanceof XactId);
        XactId A = (XactId)a;
        XactId B = (XactId)b;
        return A.id - B.id;
    }

    protected long getId() {
        return this.id;
    }

    public String toString() {
        return Long.toString(this.id);
    }
}

