/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.jdbc.InternalDriver;

public class AutoloadedDriver
implements Driver {
    private static boolean _engineForcedDown = false;
    private static Driver _driverModule;

    public boolean acceptsURL(String url) throws SQLException {
        return !_engineForcedDown && InternalDriver.embeddedDriverAcceptsURL(url);
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!InternalDriver.embeddedDriverAcceptsURL(url)) {
            return null;
        }
        return AutoloadedDriver.getDriverModule().connect(url, info);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return AutoloadedDriver.getDriverModule().getPropertyInfo(url, info);
    }

    public int getMajorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMajorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    public int getMinorVersion() {
        try {
            return AutoloadedDriver.getDriverModule().getMinorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    public boolean jdbcCompliant() {
        try {
            return AutoloadedDriver.getDriverModule().jdbcCompliant();
        }
        catch (SQLException se) {
            return false;
        }
    }

    static Driver getDriverModule() throws SQLException {
        if (_engineForcedDown) {
            throw new SQLException(MessageService.getTextMessage("I015"));
        }
        if (!AutoloadedDriver.isBooted()) {
            EmbeddedDriver.boot();
        }
        return _driverModule;
    }

    static void registerDriverModule(Driver driver) {
        _driverModule = driver;
        _engineForcedDown = false;
    }

    static void unregisterDriverModule() {
        _driverModule = null;
        _engineForcedDown = true;
    }

    private static boolean isBooted() {
        return _driverModule != null;
    }

    static {
        try {
            DriverManager.registerDriver(new AutoloadedDriver());
        }
        catch (SQLException se) {
            String message = MessageService.getTextMessage("I026", se.getMessage());
            throw new IllegalStateException(message);
        }
    }
}

