/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.derby.client.am.ClientJDBCObjectFactory;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.Version;
import org.apache.derby.client.net.ClientJDBCObjectFactoryImpl;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.jdbc.ClientDataSource;

public class ClientDriver
implements Driver {
    private transient int traceFileSuffixIndex_ = 0;
    private static final int DERBY_REMOTE_PROTOCOL = 1;
    private static ClientJDBCObjectFactory factoryObject = null;
    private static SQLException exceptionsOnLoadDriver__ = null;
    private static ClientDriver registeredDriver__ = null;

    public Connection connect(String url, Properties properties) throws SQLException {
        NetConnection conn;
        try {
            int traceLevel;
            StringTokenizer urlTokenizer;
            int protocol;
            if (exceptionsOnLoadDriver__ != null) {
                throw exceptionsOnLoadDriver__;
            }
            if (properties == null) {
                properties = new Properties();
            }
            if ((protocol = ClientDriver.tokenizeProtocol(url, urlTokenizer = new StringTokenizer(url, "/:= \t\n\r\f", true))) == 0) {
                return null;
            }
            String slashOrNull = null;
            if (protocol == 1) {
                try {
                    slashOrNull = urlTokenizer.nextToken(":/");
                }
                catch (NoSuchElementException e) {
                    throw new SqlException(null, new ClientMessageId("XJ028.C"), (Object)url, (Throwable)e);
                }
            }
            String server = ClientDriver.tokenizeServerName(urlTokenizer, url);
            int port = ClientDriver.tokenizeOptionalPortNumber(urlTokenizer, url);
            if (port == 0) {
                port = 1527;
            }
            String database = ClientDriver.tokenizeDatabase(urlTokenizer, url);
            Properties augmentedProperties = ClientDriver.tokenizeURLProperties(url, properties);
            database = this.appendDatabaseAttributes(database, augmentedProperties);
            try {
                traceLevel = ClientDataSource.getTraceLevel(augmentedProperties);
            }
            catch (NumberFormatException e) {
                throw new SqlException(null, new ClientMessageId("XJ213.C"), e);
            }
            LogWriter dncLogWriter = ClientDataSource.computeDncLogWriterForNewConnection(DriverManager.getLogWriter(), ClientDataSource.getTraceDirectory(augmentedProperties), ClientDataSource.getTraceFile(augmentedProperties), ClientDataSource.getTraceFileAppend(augmentedProperties), traceLevel, "_driver", this.traceFileSuffixIndex_++);
            conn = (NetConnection)ClientDriver.getFactory().newNetConnection((LogWriter)((NetLogWriter)dncLogWriter), DriverManager.getLoginTimeout(), server, port, database, augmentedProperties);
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        if (conn.isConnectionNull()) {
            return null;
        }
        return conn;
    }

    private String appendDatabaseAttributes(String database, Properties augmentedProperties) {
        StringBuffer longDatabase = new StringBuffer(database);
        Enumeration<?> keys = augmentedProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals("user") || key.equals("password") || key.equals("ssl")) continue;
            longDatabase.append(";" + key + "=" + augmentedProperties.getProperty(key));
        }
        return longDatabase.toString();
    }

    public boolean acceptsURL(String url) throws SQLException {
        try {
            StringTokenizer urlTokenizer = new StringTokenizer(url, "/:=; \t\n\r\f", true);
            int protocol = ClientDriver.tokenizeProtocol(url, urlTokenizer);
            return protocol != 0;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfo = new DriverPropertyInfo[2];
        if (properties == null) {
            properties = new Properties();
        }
        driverPropertyInfo[0] = new DriverPropertyInfo("user", properties.getProperty("user", "APP"));
        driverPropertyInfo[1] = new DriverPropertyInfo("password", properties.getProperty("password"));
        driverPropertyInfo[0].description = SqlException.getMessageUtil().getTextMessage("J132");
        driverPropertyInfo[1].description = SqlException.getMessageUtil().getTextMessage("J133");
        driverPropertyInfo[0].required = true;
        driverPropertyInfo[1].required = false;
        return driverPropertyInfo;
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private static int tokenizeProtocol(String url, StringTokenizer urlTokenizer) throws SqlException {
        if (url == null) {
            return 0;
        }
        if (urlTokenizer == null) {
            return 0;
        }
        try {
            String jdbc = urlTokenizer.nextToken(":");
            if (!jdbc.equals("jdbc")) {
                return 0;
            }
            if (!urlTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            String dbname = urlTokenizer.nextToken(":");
            int protocol = 0;
            if (!dbname.equals("derby") || url.indexOf("derby://") == -1) {
                return 0;
            }
            protocol = 1;
            if (!urlTokenizer.nextToken(":").equals(":")) {
                return 0;
            }
            return protocol;
        }
        catch (NoSuchElementException e) {
            return 0;
        }
    }

    private static String tokenizeServerName(StringTokenizer urlTokenizer, String url) throws SqlException {
        try {
            if (!urlTokenizer.nextToken("/").equals("/")) {
                throw new SqlException(null, new ClientMessageId("XJ028.C"), url);
            }
            return urlTokenizer.nextToken("/:");
        }
        catch (NoSuchElementException e) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), url);
        }
    }

    private static int tokenizeOptionalPortNumber(StringTokenizer urlTokenizer, String url) throws SqlException {
        try {
            String firstToken = urlTokenizer.nextToken(":/");
            if (firstToken.equals(":")) {
                String port = urlTokenizer.nextToken("/");
                if (!urlTokenizer.nextToken("/").equals("/")) {
                    throw new SqlException(null, new ClientMessageId("XJ028.C"), url);
                }
                return Integer.parseInt(port);
            }
            if (firstToken.equals("/")) {
                return 0;
            }
            throw new SqlException(null, new ClientMessageId("XJ028.C"), url);
        }
        catch (NoSuchElementException e) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), (Object)url, (Throwable)e);
        }
    }

    private static String tokenizeDatabase(StringTokenizer urlTokenizer, String url) throws SqlException {
        try {
            String databaseName = urlTokenizer.nextToken("\t\n\r\f;");
            return databaseName;
        }
        catch (NoSuchElementException e) {
            throw new SqlException(null, new ClientMessageId("XJ028.C"), (Object)url, (Throwable)e);
        }
    }

    private static Properties tokenizeURLProperties(String url, Properties properties) throws SqlException {
        String attributeString = null;
        int attributeIndex = -1;
        if (url != null && (attributeIndex = url.indexOf(";")) != -1) {
            attributeString = url.substring(attributeIndex);
        }
        return ClientDataSource.tokenizeAttributes(attributeString, properties);
    }

    public static ClientJDBCObjectFactory getFactory() {
        if (factoryObject != null) {
            return factoryObject;
        }
        factoryObject = Configuration.supportsJDBC40() ? ClientDriver.createJDBC40FactoryImpl() : ClientDriver.createDefaultFactoryImpl();
        return factoryObject;
    }

    private static ClientJDBCObjectFactory createDefaultFactoryImpl() {
        return new ClientJDBCObjectFactoryImpl();
    }

    private static ClientJDBCObjectFactory createJDBC40FactoryImpl() {
        String factoryName = "org.apache.derby.client.net.ClientJDBCObjectFactoryImpl40";
        try {
            return (ClientJDBCObjectFactory)Class.forName("org.apache.derby.client.net.ClientJDBCObjectFactoryImpl40").newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            return ClientDriver.createDefaultFactoryImpl();
        }
        catch (InstantiationException ie) {
            return ClientDriver.createDefaultFactoryImpl();
        }
        catch (IllegalAccessException iae) {
            return ClientDriver.createDefaultFactoryImpl();
        }
    }

    static {
        if (Configuration.exceptionsOnLoadResources != null) {
            exceptionsOnLoadDriver__ = Utils.accumulateSQLException(Configuration.exceptionsOnLoadResources.getSQLException(), exceptionsOnLoadDriver__);
        }
        try {
            registeredDriver__ = new ClientDriver();
            DriverManager.registerDriver(registeredDriver__);
        }
        catch (SQLException e) {
            exceptionsOnLoadDriver__ = new SqlException(null, new ClientMessageId("XBM0N.D")).getSQLException();
            exceptionsOnLoadDriver__.setNextException(e);
        }
    }
}

