/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.svg;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;

public class SVGImage
extends Image {
    protected Image image;
    protected URL url;
    protected byte[] data;
    public static final String BASE64 = "data:;base64,";

    public byte[] getData() {
        return this.data;
    }

    public SVGImage(Image image, URL url) {
        this.image = image;
        this.url = url;
    }

    public SVGImage(Image image, URL url, byte[] data) {
        this(image, url);
        this.data = data;
    }

    public void flush() {
        this.image.flush();
    }

    public Graphics getGraphics() {
        return this.image.getGraphics();
    }

    public int getHeight(ImageObserver arg0) {
        return this.image.getHeight(arg0);
    }

    public Object getProperty(String arg0, ImageObserver arg1) {
        return this.image.getProperty(arg0, arg1);
    }

    public Image getScaledInstance(int arg0, int arg1, int arg2) {
        return this.image.getScaledInstance(arg0, arg1, arg2);
    }

    public ImageProducer getSource() {
        return this.image.getSource();
    }

    public int getWidth(ImageObserver arg0) {
        return this.image.getWidth(arg0);
    }

    public String getUrl() {
        if (this.url == null) {
            if (this.data != null) {
                return BASE64 + new String(Base64.encodeBase64((byte[])this.data));
            }
            return "";
        }
        return this.url.toExternalForm();
    }

    public void setUrl(URL url) {
        this.url = url;
    }
}

