/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.events.IFileTransferConnectStartEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.Activator;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.FileInfo;
import org.eclipse.equinox.internal.p2.repository.JREHttpClientRequiredException;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.ProgressStatistics;
import org.eclipse.equinox.internal.p2.repository.RepositoryPreferences;
import org.eclipse.equinox.internal.p2.repository.RepositoryStatusHelper;
import org.eclipse.equinox.internal.p2.repository.RepositoryTracing;
import org.eclipse.osgi.util.NLS;

public final class FileReader
extends FileTransferJob
implements IFileTransferListener {
    private static IFileReaderProbe testProbe;
    private boolean closeStreamWhenFinished = false;
    private Exception exception;
    private FileInfo fileInfo;
    private long lastProgressCount;
    private long lastStatsCount;
    protected IProgressMonitor theMonitor;
    private OutputStream theOutputStream;
    private ProgressStatistics statistics;
    private final int connectionRetryCount;
    private final long connectionRetryDelay;
    private final IConnectContext connectContext;
    private URI requestUri;
    protected IFileTransferConnectStartEvent connectEvent;
    private Job cancelJob;
    private boolean monitorStarted;

    public FileReader(IConnectContext aConnectContext) {
        super(Messages.FileTransport_reader);
        this.setSystem(true);
        this.setUser(false);
        this.connectionRetryCount = RepositoryPreferences.getConnectionRetryCount();
        this.connectionRetryDelay = RepositoryPreferences.getConnectionMsRetryDelay();
        this.connectContext = aConnectContext;
    }

    public FileInfo getLastFileInfo() {
        return this.fileInfo;
    }

    public synchronized void handleTransferEvent(IFileTransferEvent event) {
        if (event instanceof IFileTransferConnectStartEvent) {
            this.connectEvent = (IFileTransferConnectStartEvent)event;
            this.cancelJob = new CancelHandler();
            this.cancelJob.schedule(500L);
        } else if (event instanceof IIncomingFileTransferReceiveStartEvent) {
            if (this.cancelJob != null) {
                this.cancelJob.cancel();
            }
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            try {
                FileInfo fi = new FileInfo();
                Date lastModified = source.getRemoteLastModified();
                if (lastModified != null) {
                    fi.setLastModified(lastModified.getTime());
                }
                fi.setName(source.getRemoteFileName());
                fi.setSize(source.getFileLength());
                this.fileInfo = fi;
                ((IIncomingFileTransferReceiveStartEvent)event).receive(this.theOutputStream, (FileTransferJob)this);
            }
            catch (IOException e) {
                this.exception = e;
                return;
            }
            long fileLength = source.getFileLength();
            ProgressStatistics stats = new ProgressStatistics(this.requestUri, source.getRemoteFileName(), fileLength);
            this.setStatistics(stats);
            if (this.theMonitor != null) {
                this.theMonitor.beginTask(null, 1000);
                this.monitorStarted = true;
                this.theMonitor.subTask(stats.report());
                this.lastStatsCount = 0L;
                this.lastProgressCount = 0L;
            }
            this.onStart(source);
        } else if (event instanceof IIncomingFileTransferReceiveDataEvent) {
            IIncomingFileTransfer source = ((IIncomingFileTransferEvent)event).getSource();
            if (this.theMonitor != null) {
                if (this.theMonitor.isCanceled()) {
                    source.cancel();
                    return;
                }
                long br = source.getBytesReceived();
                long count = br - this.lastStatsCount;
                this.lastStatsCount = br;
                ProgressStatistics stats = this.getStatistics();
                if (stats != null) {
                    stats.increase(count);
                    this.fileInfo.setAverageSpeed(stats.getAverageSpeed());
                    if (stats.shouldReport()) {
                        count = br - this.lastProgressCount;
                        this.lastProgressCount = br;
                        this.theMonitor.subTask(stats.report());
                        this.theMonitor.worked((int)(1000L * count / stats.getTotal()));
                    }
                }
            }
            this.onData(source);
        } else if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
            if (this.closeStreamWhenFinished) {
                FileReader.hardClose(this.theOutputStream);
            }
            if (this.exception == null) {
                this.exception = ((IIncomingFileTransferReceiveDoneEvent)event).getException();
            }
            this.onDone(((IIncomingFileTransferReceiveDoneEvent)event).getSource());
        }
    }

    public InputStream read(URI url, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        PipedOutputStream output;
        final PipedInputStream input = new PipedInputStream();
        try {
            output = new PipedOutputStream(input);
        }
        catch (IOException e) {
            throw RepositoryStatusHelper.wrap(e);
        }
        RepositoryTracing.debug("Downloading {0}", url);
        this.sendRetrieveRequest(url, output, null, true, monitor);
        return new InputStream(){

            public int available() throws IOException {
                this.checkException();
                return input.available();
            }

            public void close() throws IOException {
                FileReader.hardClose(input);
                this.checkException();
            }

            public void mark(int readlimit) {
                input.mark(readlimit);
            }

            public boolean markSupported() {
                return input.markSupported();
            }

            public int read() throws IOException {
                this.checkException();
                return input.read();
            }

            public int read(byte[] b) throws IOException {
                this.checkException();
                return input.read(b);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                this.checkException();
                return input.read(b, off, len);
            }

            public void reset() throws IOException {
                this.checkException();
                input.reset();
            }

            public long skip(long n) throws IOException {
                this.checkException();
                return input.skip(n);
            }

            private void checkException() throws IOException {
                IOException e;
                if (FileReader.this.getException() == null) {
                    return;
                }
                Throwable t = RepositoryStatusHelper.unwind(FileReader.this.getException());
                if (t instanceof IOException) {
                    e = (IOException)t;
                } else {
                    e = new IOException(t.getMessage());
                    e.initCause(t);
                }
                throw e;
            }
        };
    }

    public void readInto(URI uri, OutputStream anOutputStream, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        this.readInto(uri, anOutputStream, -1L, monitor);
    }

    public boolean belongsTo(Object family) {
        return family == this;
    }

    public void readInto(URI uri, OutputStream anOutputStream, long startPos, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                this.sendRetrieveRequest(uri, anOutputStream, startPos != -1L ? new DownloadRange(startPos) : null, false, monitor);
                Job.getJobManager().join((Object)this, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                if (monitor.isCanceled() && this.connectEvent != null) {
                    this.connectEvent.cancel();
                }
                this.checkException(uri, this.connectionRetryCount);
            }
            catch (InterruptedException interruptedException) {
                monitor.setCanceled(true);
                throw new OperationCanceledException();
            }
        }
        finally {
            if (this.cancelJob != null) {
                this.cancelJob.cancel();
                this.cancelJob = null;
            }
            if (!this.monitorStarted) {
                monitor.beginTask(null, 1);
            }
            this.monitorStarted = false;
            monitor.done();
        }
    }

    protected void sendRetrieveRequest(URI uri, OutputStream outputStream, DownloadRange range, boolean closeStreamOnFinish, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        IRetrieveFileTransferFactory factory = Activator.getDefault().getRetrieveFileTransferFactory();
        if (factory == null) {
            throw RepositoryStatusHelper.fromMessage(Messages.ecf_configuration_error);
        }
        IRetrieveFileTransfer adapter = factory.newInstance();
        adapter.setConnectContextForAuthentication(this.connectContext);
        this.exception = null;
        this.closeStreamWhenFinished = closeStreamOnFinish;
        this.fileInfo = null;
        this.statistics = null;
        this.lastProgressCount = 0L;
        this.lastStatsCount = 0L;
        this.theMonitor = monitor;
        this.monitorStarted = false;
        this.theOutputStream = outputStream;
        this.requestUri = uri;
        int retryCount = 0;
        while (true) {
            block9: {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    IFileID fileID = FileIDFactory.getDefault().createFileID(adapter.getRetrieveNamespace(), uri.toString());
                    if (range != null) {
                        adapter.sendRetrieveRequest(fileID, (IFileRangeSpecification)range, (IFileTransferListener)this, null);
                    } else {
                        adapter.sendRetrieveRequest(fileID, (IFileTransferListener)this, null);
                    }
                }
                catch (IncomingFileTransferException e) {
                    this.exception = e;
                }
                catch (FileCreateException e) {
                    this.exception = e;
                }
                catch (Throwable throwable) {
                    if (this.exception == null) break block9;
                    this.exception.printStackTrace();
                }
            }
            if (this.checkException(uri, retryCount)) break;
            ++retryCount;
        }
    }

    private boolean checkException(URI uri, int attemptCounter) throws CoreException, FileNotFoundException, AuthenticationFailedException, JREHttpClientRequiredException {
        if (this.exception != null) {
            RepositoryStatusHelper.checkJREHttpClientRequired(this.exception);
            RepositoryStatusHelper.checkPermissionDenied(this.exception);
            RepositoryStatusHelper.checkFileNotFound(this.exception, uri);
            Throwable t = RepositoryStatusHelper.unwind(this.exception);
            if (t instanceof CoreException) {
                throw RepositoryStatusHelper.unwindCoreException((CoreException)t);
            }
            if (t instanceof SocketTimeoutException) {
                throw RepositoryStatusHelper.wrap(t);
            }
            if (t instanceof IOException && attemptCounter < this.connectionRetryCount) {
                this.exception = null;
                try {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)Messages.connection_to_0_failed_on_1_retry_attempt_2, (Object[])new String[]{uri.toString(), t.getMessage(), String.valueOf(attemptCounter)}), t));
                    Thread.sleep(this.connectionRetryDelay);
                    return false;
                }
                catch (InterruptedException interruptedException) {}
            }
            throw RepositoryStatusHelper.wrap(this.exception);
        }
        return true;
    }

    protected Exception getException() {
        return this.exception;
    }

    public static void hardClose(Object aStream) {
        if (aStream != null) {
            try {
                if (aStream instanceof OutputStream) {
                    ((OutputStream)aStream).close();
                } else if (aStream instanceof InputStream) {
                    ((InputStream)aStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void onDone(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onDone(this, source, this.theMonitor);
        }
    }

    private void onStart(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onStart(this, source, this.theMonitor);
        }
    }

    private void onData(IIncomingFileTransfer source) {
        if (testProbe != null) {
            testProbe.onData(this, source, this.theMonitor);
        }
    }

    public static void setTestProbe(IFileReaderProbe probe) {
        testProbe = probe;
    }

    private synchronized void setStatistics(ProgressStatistics statistics) {
        this.statistics = statistics;
    }

    private synchronized ProgressStatistics getStatistics() {
        return this.statistics;
    }

    protected class CancelHandler
    extends Job {
        private boolean done = false;

        protected CancelHandler() {
            super(Messages.FileTransport_cancelCheck);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor jobMonitor) {
            while (!this.done && !jobMonitor.isCanceled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                if (FileReader.this.theMonitor == null || !FileReader.this.theMonitor.isCanceled() || FileReader.this.connectEvent == null) continue;
                FileReader.this.connectEvent.cancel();
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            Thread t = this.getThread();
            if (t != null) {
                t.interrupt();
            }
        }
    }

    private static class DownloadRange
    implements IFileRangeSpecification {
        private long startPosition;

        public DownloadRange(long startPos) {
            this.startPosition = startPos;
        }

        public long getEndPosition() {
            return -1L;
        }

        public long getStartPosition() {
            return this.startPosition;
        }
    }

    public static interface IFileReaderProbe {
        public void onStart(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);

        public void onData(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);

        public void onDone(FileReader var1, IIncomingFileTransfer var2, IProgressMonitor var3);
    }
}

