/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntryOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;

public class ArchiveWriter
implements IDocArchiveWriter {
    boolean shareArchive;
    IArchiveFile archive;
    HashSet streams;

    public ArchiveWriter(String archiveName) throws IOException {
        this.archive = new ArchiveFile(archiveName, "rw");
        this.shareArchive = false;
        this.streams = new HashSet();
    }

    public ArchiveWriter(IArchiveFile archive) throws IOException {
        this.archive = archive;
        this.shareArchive = true;
        this.streams = new HashSet();
    }

    public IArchiveFile getArchive() {
        return this.archive;
    }

    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        ArchiveEntry entry = this.archive.createEntry(relativePath);
        ArchiveEntryOutputStream stream = new ArchiveEntryOutputStream(this, entry);
        this.streams.add(stream);
        return stream;
    }

    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        ArchiveEntry entry = this.archive.exists(relativePath) ? this.archive.openEntry(relativePath) : this.archive.createEntry(relativePath);
        ArchiveEntryOutputStream stream = new ArchiveEntryOutputStream(this, entry);
        this.streams.add(stream);
        return stream;
    }

    public RAOutputStream createOutputStream(String relativePath) throws IOException {
        return this.createRandomAccessStream(relativePath);
    }

    public RAOutputStream getOutputStream(String relativePath) throws IOException {
        return this.openRandomAccessStream(relativePath);
    }

    public RAInputStream getInputStream(String relativePath) throws IOException {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        ArchiveEntry entry = this.archive.openEntry(relativePath);
        return new ArchiveEntryInputStream(entry);
    }

    public boolean dropStream(String relativePath) {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        try {
            return this.archive.removeEntry(relativePath);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean exists(String relativePath) {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        return this.archive.exists(relativePath);
    }

    public void finish() throws IOException {
        try {
            ArrayList unclosedStreams = new ArrayList();
            unclosedStreams.addAll(this.streams);
            for (RAOutputStream stream : unclosedStreams) {
                stream.close();
            }
            this.archive.flush();
        }
        finally {
            if (!this.shareArchive) {
                this.archive.close();
            }
        }
    }

    public void flush() throws IOException {
        ArrayList unclosedStreams = new ArrayList();
        unclosedStreams.addAll(this.streams);
        for (RAOutputStream stream : unclosedStreams) {
            stream.flush();
        }
        this.archive.flush();
    }

    public String getName() {
        return this.archive.getName();
    }

    public void initialize() throws IOException {
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
    }

    public Object lock(String relativePath) throws IOException {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = String.valueOf(ArchiveUtil.UNIX_SEPERATOR) + relativePath;
        }
        return this.archive.lockEntry(relativePath);
    }

    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {}
    }

    void registerStream(ArchiveEntryOutputStream stream) {
        this.streams.add(stream);
    }

    void unregisterStream(ArchiveEntryOutputStream stream) {
        this.streams.remove(stream);
    }
}

