/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.ICopyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.ILicense;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.ITouchpointType;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;

public class InstallableUnit
implements IInstallableUnit {
    private static final OrderedProperties NO_PROPERTIES = new OrderedProperties();
    private static final IProvidedCapability[] NO_PROVIDES = new IProvidedCapability[0];
    private static final IRequiredCapability[] NO_REQUIRES = new IRequiredCapability[0];
    private static final IArtifactKey[] NO_ARTIFACTS = new IArtifactKey[0];
    private static final ITouchpointData[] NO_TOUCHPOINT_DATA = new ITouchpointData[0];
    private IArtifactKey[] artifacts = NO_ARTIFACTS;
    private String filter;
    private String id;
    private OrderedProperties properties;
    private OrderedProperties localizedProperties;
    IProvidedCapability[] providedCapabilities = NO_PROVIDES;
    private IRequiredCapability[] requires = NO_REQUIRES;
    private IRequiredCapability[] metaRequires = NO_REQUIRES;
    private boolean singleton;
    private ArrayList touchpointData = null;
    private ITouchpointType touchpointType;
    private Version version;
    private IUpdateDescriptor updateInfo;
    private ILicense license;
    private ICopyright copyright;

    public void addTouchpointData(ITouchpointData newData) {
        this.ensureTouchpointDataCapacity(1);
        this.touchpointData.add(newData);
    }

    public int compareTo(Object toCompareTo) {
        if (!(toCompareTo instanceof IInstallableUnit)) {
            return -1;
        }
        IInstallableUnit other = (IInstallableUnit)toCompareTo;
        if (this.getId().compareTo(other.getId()) == 0) {
            return this.getVersion().compareTo((Object)other.getVersion());
        }
        return this.getId().compareTo(other.getId());
    }

    private void ensureTouchpointDataCapacity(int size) {
        if (this.touchpointData != null) {
            this.touchpointData.ensureCapacity(size);
        } else {
            this.touchpointData = new ArrayList(size);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IInstallableUnit)) {
            return false;
        }
        IInstallableUnit other = (IInstallableUnit)obj;
        if (this.id == null ? other.getId() != null : !this.id.equals(other.getId())) {
            return false;
        }
        return !(this.getVersion() == null ? other.getVersion() != null : !this.getVersion().equals((Object)other.getVersion()));
    }

    public IArtifactKey[] getArtifacts() {
        return this.artifacts;
    }

    public String getFilter() {
        return this.filter;
    }

    public IInstallableUnitFragment[] getFragments() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public Map getProperties() {
        return OrderedProperties.unmodifiableProperties((Map)this.properties());
    }

    public String getLocalizedProperty(String key) {
        String result = null;
        if (this.localizedProperties != null) {
            result = this.localizedProperties.getProperty(key);
        }
        return result;
    }

    public String getProperty(String key) {
        return this.properties().getProperty(key);
    }

    public IProvidedCapability[] getProvidedCapabilities() {
        return this.providedCapabilities;
    }

    public IRequiredCapability[] getRequiredCapabilities() {
        return this.requires;
    }

    public ITouchpointData[] getTouchpointData() {
        return this.touchpointData == null ? NO_TOUCHPOINT_DATA : this.touchpointData.toArray(new ITouchpointData[this.touchpointData.size()]);
    }

    public ITouchpointType getTouchpointType() {
        return this.touchpointType != null ? this.touchpointType : ITouchpointType.NONE;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return result;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean isResolved() {
        return false;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    private OrderedProperties properties() {
        return this.properties != null ? this.properties : NO_PROPERTIES;
    }

    public void setArtifacts(IArtifactKey[] value) {
        this.artifacts = value == null || value.length == 0 ? NO_ARTIFACTS : value;
    }

    public void setCapabilities(IProvidedCapability[] newCapabilities) {
        this.providedCapabilities = newCapabilities == null || newCapabilities.length == 0 ? NO_PROVIDES : newCapabilities;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String setLocalizedProperty(String key, String value) {
        if (this.localizedProperties == null) {
            this.localizedProperties = new OrderedProperties();
        }
        return (String)this.localizedProperties.put((Object)key, (Object)value);
    }

    public String setProperty(String key, String value) {
        if (value == null) {
            return this.properties != null ? (String)this.properties.remove((Object)key) : null;
        }
        if (this.properties == null) {
            this.properties = new OrderedProperties();
        }
        return (String)this.properties.setProperty(key, value);
    }

    public void setRequiredCapabilities(IRequiredCapability[] capabilities) {
        this.requires = capabilities.length == 0 ? NO_REQUIRES : (IRequiredCapability[])capabilities.clone();
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setTouchpointType(ITouchpointType type) {
        this.touchpointType = type != ITouchpointType.NONE ? type : null;
    }

    public void setVersion(Version newVersion) {
        this.version = newVersion != null ? newVersion : Version.emptyVersion;
    }

    public String toString() {
        return String.valueOf(this.id) + ' ' + this.getVersion();
    }

    public IInstallableUnit unresolved() {
        return this;
    }

    public IUpdateDescriptor getUpdateDescriptor() {
        return this.updateInfo;
    }

    public void setUpdateDescriptor(IUpdateDescriptor updateInfo) {
        this.updateInfo = updateInfo;
    }

    public void setLicense(ILicense license) {
        this.license = license;
    }

    public ILicense getLicense() {
        return this.license;
    }

    public void setCopyright(ICopyright copyright) {
        this.copyright = copyright;
    }

    public ICopyright getCopyright() {
        return this.copyright;
    }

    public boolean satisfies(IRequiredCapability candidate) {
        IProvidedCapability[] provides = this.getProvidedCapabilities();
        int i = 0;
        while (i < provides.length) {
            if (provides[i].satisfies(candidate)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IRequiredCapability[] getMetaRequiredCapabilities() {
        return this.metaRequires;
    }

    public void setMetaRequiredCapabilities(IRequiredCapability[] metaReqs) {
        this.metaRequires = metaReqs.length == 0 ? NO_REQUIRES : (IRequiredCapability[])metaReqs.clone();
    }
}

