/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.DataExtractionFormatInfo;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IDocumentWriter;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportEngine
implements IReportEngine {
    protected static Logger logger = Logger.getLogger(IReportEngine.class.getName());
    protected IReportEngine engine;

    public ReportEngine(EngineConfig config) {
        try {
            Platform.startup((PlatformConfig)config);
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        Object factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        if (factory instanceof IReportEngineFactory) {
            this.engine = ((IReportEngineFactory)factory).createReportEngine(config);
        }
        if (this.engine == null) {
            System.out.println("Can't load the report engine");
        }
    }

    public Object getRootScope() {
        return this.engine.getRootScope();
    }

    public void changeLogLevel(Level newLevel) {
        this.engine.changeLogLevel(newLevel);
    }

    public EngineConfig getConfig() {
        return this.engine.getConfig();
    }

    public IReportRunnable openReportDesign(String designName) throws EngineException {
        return this.engine.openReportDesign(designName);
    }

    public IReportRunnable openReportDesign(ReportDesignHandle designHandle) throws EngineException {
        return this.engine.openReportDesign(designHandle);
    }

    public IReportRunnable openReportDesign(InputStream designStream) throws EngineException {
        return this.engine.openReportDesign(designStream);
    }

    public IReportRunnable openReportDesign(String name, InputStream designStream) throws EngineException {
        return this.engine.openReportDesign(name, designStream);
    }

    public IRunAndRenderTask createRunAndRenderTask(IReportRunnable reportRunnable) {
        return this.engine.createRunAndRenderTask(reportRunnable);
    }

    public IGetParameterDefinitionTask createGetParameterDefinitionTask(IRunnable reportRunnable) {
        return this.engine.createGetParameterDefinitionTask(reportRunnable);
    }

    public String[] getSupportedFormats() {
        return this.engine.getSupportedFormats();
    }

    public EmitterInfo[] getEmitterInfo() {
        return this.engine.getEmitterInfo();
    }

    public String getMIMEType(String format) {
        return this.engine.getMIMEType(format);
    }

    public void destroy() {
        if (this.engine != null) {
            this.engine.destroy();
            this.engine = null;
        }
    }

    public IRunTask createRunTask(IReportRunnable reportRunnable) {
        return this.engine.createRunTask(reportRunnable);
    }

    public IRenderTask createRenderTask(IReportDocument reportDocument) {
        return this.engine.createRenderTask(reportDocument);
    }

    public IReportDocument openReportDocument(String fileName) throws EngineException {
        return this.engine.openReportDocument(fileName);
    }

    public IDataExtractionTask createDataExtractionTask(IReportDocument reportDocument) {
        return this.engine.createDataExtractionTask(reportDocument);
    }

    public void shutdown() {
        this.engine.shutdown();
    }

    public IReportDocument openReportDocument(String systemId, String fileName) throws EngineException {
        return this.engine.openReportDocument(systemId, fileName);
    }

    public IReportRunnable openReportDesign(String designName, IResourceLocator locator) throws EngineException {
        return this.engine.openReportDesign(designName, locator);
    }

    public IReportRunnable openReportDesign(String name, InputStream designStream, IResourceLocator locator) throws EngineException {
        return this.engine.openReportDesign(name, designStream, locator);
    }

    public IReportRunnable openReportDesign(String name, InputStream designStream, Map options) throws EngineException {
        return this.engine.openReportDesign(name, designStream, options);
    }

    public IReportDocument openReportDocument(String fileName, IResourceLocator locator) throws EngineException {
        return this.engine.openReportDocument(fileName, locator);
    }

    public IReportDocument openReportDocument(String systemId, String fileName, IResourceLocator locator) throws EngineException {
        return this.engine.openReportDocument(systemId, fileName, locator);
    }

    public IReportDocument openReportDocument(String systemId, String fileName, Map options) throws EngineException {
        return this.engine.openReportDocument(systemId, fileName, options);
    }

    public IReportDocument openReportDocument(String systemId, IDocArchiveReader reader, Map options) throws EngineException {
        return this.engine.openReportDocument(systemId, reader, options);
    }

    public Logger getLogger() {
        return this.engine.getLogger();
    }

    public void setLogger(Logger logger) {
        this.engine.setLogger(logger);
    }

    public IRenderTask createRenderTask(IReportDocument reportDocument, IReportRunnable reportRunnable) {
        return this.engine.createRenderTask(reportDocument, reportRunnable);
    }

    public DataExtractionFormatInfo[] getDataExtractionFormatInfo() {
        return this.engine.getDataExtractionFormatInfo();
    }

    public IDocumentWriter openDocumentWriter(IArchiveFile file) throws EngineException {
        return this.engine.openDocumentWriter(file);
    }

    public String getVersion() {
        return this.engine.getVersion();
    }

    public IEngineTask createEngineTask(String taskName) throws EngineException {
        return this.engine.createEngineTask(taskName);
    }
}

