/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.birt.report.engine.api.impl.EngineLoggerHandler;

public class EngineLogger {
    protected static Logger logger = Logger.getLogger(EngineLogger.class.getName());
    private static final String BIRT_NAME_SPACE = "org.eclipse.birt";
    private static EngineLoggerHandler sharedHandler = null;
    private static Logger userLogger = null;
    private static String dirName = null;
    private static String fileName = null;
    private static Logger fileLogger = null;

    public static void startEngineLogging(Logger logger, String directoryName, String file, Level logLevel) {
        Logger rootLogger = Logger.getLogger(BIRT_NAME_SPACE);
        if (sharedHandler == null) {
            sharedHandler = new EngineLoggerHandler(rootLogger);
            sharedHandler.setLevel(Level.ALL);
            rootLogger.addHandler(sharedHandler);
        }
        if (fileLogger != null) {
            EngineLogger.closeFileLogger(fileLogger);
            fileLogger = null;
        }
        if (logger != null && EngineLogger.isValidLogger(logger)) {
            userLogger = logger;
            sharedHandler.setSharedLogger(userLogger);
        } else {
            if (directoryName != null) {
                dirName = directoryName;
            }
            if (file != null) {
                fileName = file;
            }
            if (logLevel == null) {
                logLevel = rootLogger.getLevel();
            }
            if (logLevel != Level.OFF && (dirName != null || fileName != null)) {
                fileLogger = EngineLogger.createFileLogger(dirName, fileName);
                sharedHandler.setSharedLogger(fileLogger);
            }
            rootLogger.setLevel(logLevel);
        }
        rootLogger.setUseParentHandlers(false);
    }

    public static boolean isValidLogger(Logger logger) {
        Logger rootLogger = Logger.getLogger(BIRT_NAME_SPACE);
        while (logger != null) {
            if (logger == rootLogger) {
                return false;
            }
            logger = logger.getParent();
        }
        return true;
    }

    public static void stopEngineLogging() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                EngineLogger.doStopEngineLogging();
                return null;
            }
        });
    }

    private static void doStopEngineLogging() {
        Logger rootLogger = Logger.getLogger(BIRT_NAME_SPACE);
        rootLogger.removeHandler(sharedHandler);
        if (sharedHandler != null) {
            sharedHandler.close();
            sharedHandler = null;
        }
        if (fileLogger != null) {
            EngineLogger.closeFileLogger(fileLogger);
            fileLogger = null;
        }
        userLogger = null;
    }

    public static void changeLogLevel(Level newLevel) {
        if (newLevel != null) {
            if (userLogger != null && newLevel != Level.OFF && fileLogger == null && (dirName != null || fileName != null) && (fileLogger = EngineLogger.createFileLogger(dirName, fileName)) != null) {
                sharedHandler.setSharedLogger(fileLogger);
            }
            Logger rootLogger = Logger.getLogger(BIRT_NAME_SPACE);
            rootLogger.setLevel(newLevel);
        }
    }

    private static String generateUniqueLogFileName(String directoryName, String fileName) {
        if (fileName == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            String dateTimeString = df.format(new Date());
            fileName = "ReportEngine_" + dateTimeString + ".log";
        }
        if (directoryName == null) {
            directoryName = "";
        } else if (directoryName.length() > 0) {
            directoryName = String.valueOf(directoryName) + File.separator;
        }
        return new String(String.valueOf(directoryName) + fileName);
    }

    private static Logger createFileLogger(String dirName, String fileName) {
        try {
            if (dirName != null) {
                File directory = new File(dirName);
                if (!directory.exists()) {
                    if (!directory.mkdirs()) {
                        throw new IOException("logDir \"" + dirName + "\" doesn't exist and  be created");
                    }
                } else if (directory.isFile()) {
                    throw new IOException("logDir \"" + dirName + "\" should be a folder instead of a file");
                }
            }
            FileHandler logFileHandler = new FileHandler(EngineLogger.generateUniqueLogFileName(dirName, fileName), true);
            logFileHandler.setFormatter(new SimpleFormatter());
            logFileHandler.setLevel(Level.FINEST);
            Logger logger = Logger.getAnonymousLogger();
            logger.addHandler(logFileHandler);
            return logger;
        }
        catch (SecurityException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    private static void closeFileLogger(Logger logger) {
        Handler[] handles = logger.getHandlers();
        if (handles != null) {
            int i = 0;
            while (i < handles.length) {
                handles[i].close();
                ++i;
            }
        }
    }
}

