/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.XMLEncodeUtil;

public class XMLWriter {
    protected static Logger log = Logger.getLogger(XMLWriter.class.getName());
    protected static final int MAX_BUFFER_SIZE = 1024;
    protected char[] buffer = new char[1024];
    protected int bufferSize;
    protected Writer writer;
    protected String encoding = "UTF-8";
    protected int indentCount;
    protected boolean bPairedFlag = true;
    protected boolean bText = false;
    protected boolean bIndent = true;
    protected boolean bImplicitCloseTag = true;
    private static String[] INDENTS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t", "\t\t\t\t\t\t", "\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t"};

    public void open(OutputStream outputStream, String encoding) {
        assert (encoding != null);
        assert (outputStream != null);
        this.encoding = encoding;
        try {
            this.writer = new OutputStreamWriter(outputStream, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.log(Level.SEVERE, "the character encoding {0} unsupported !", encoding);
        }
    }

    public void open(OutputStream outputStream) {
        this.open(outputStream, "UTF-8");
    }

    public void close() {
        this.flush();
        try {
            this.writer.close();
        }
        catch (IOException iOException) {}
    }

    public void startWriter() {
        this.print("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
    }

    public void endWriter() {
        if (!this.bPairedFlag) {
            this.print('>');
            if (this.bIndent) {
                this.println();
            }
        }
        this.flush();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void openTag(String tagName) {
        if (!this.bPairedFlag) {
            this.print('>');
        }
        if (this.bIndent) {
            this.print('\n');
            this.print(this.indent());
        }
        this.bPairedFlag = false;
        this.print('<');
        this.print(tagName);
        ++this.indentCount;
        this.bText = false;
    }

    public void closeTag(String tagName) {
        --this.indentCount;
        if (!this.bPairedFlag) {
            if (this.bImplicitCloseTag) {
                this.print("/>");
            } else {
                this.print("></");
                this.print(tagName);
                this.print('>');
            }
        } else {
            if (this.bIndent && !this.bText) {
                this.print('\n');
                this.print(this.indent());
            }
            this.print("</");
            this.print(tagName);
            this.print('>');
        }
        this.bPairedFlag = true;
        this.bText = false;
    }

    public void attribute(String attrName, String attrValue) {
        if (attrValue != null && attrValue.length() > 0) {
            this.print(' ');
            this.print(attrName);
            this.print("=\"");
            this.print(this.encodeAttr(attrValue));
            this.print('\"');
        }
    }

    public void attributeAllowEmpty(String attrName, String attrValue) {
        if (attrValue != null) {
            this.print(' ');
            this.print(attrName);
            this.print("=\"");
            this.print(this.encodeAttr(attrValue));
            this.print('\"');
        }
    }

    public void attribute(String attrName, Object attrValue) {
        if (attrValue != null) {
            this.attribute(attrName, attrValue.toString());
        }
    }

    public void attribute(String attrName, float attrValue) {
        this.print(String.valueOf(' ') + attrName + "=\"" + Float.toString(attrValue) + '\"');
    }

    public void attribute(String attrName, double attrValue) {
        this.print(String.valueOf(' ') + attrName + "=\"" + Double.toString(attrValue) + '\"');
    }

    public void attribute(String attrName, int attrValue) {
        this.print(String.valueOf(' ') + attrName + "=\"" + Integer.toString(attrValue) + '\"');
    }

    public void text(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.print('>');
            this.bPairedFlag = true;
        }
        String stringToPrint = this.encodeText(value);
        this.print(stringToPrint);
        this.bText = true;
    }

    public void cdata(String value) {
        if (!this.bPairedFlag) {
            this.print('>');
            this.bPairedFlag = true;
        }
        String text = this.encodeCdata(value);
        this.print(text);
        if (this.bPairedFlag) {
            this.bText = true;
        }
    }

    public void literal(String value) {
        this.print(value);
    }

    protected String indent() {
        if (this.indentCount < INDENTS.length) {
            return INDENTS[this.indentCount];
        }
        return INDENTS[INDENTS.length - 1];
    }

    protected String encodeText(String s) {
        return XMLEncodeUtil.encodeText(s);
    }

    protected String encodeAttr(String s) {
        return XMLEncodeUtil.encodeAttr(s);
    }

    protected String encodeCdata(String s) {
        return XMLEncodeUtil.encodeCdata(s);
    }

    public boolean isIndent() {
        return this.bIndent;
    }

    public void setIndent(boolean indent) {
        this.bIndent = indent;
    }

    public boolean isImplicitCloseTag() {
        return this.bImplicitCloseTag;
    }

    public void setImplicitCloseTag(boolean bImplicitCloseTag) {
        this.bImplicitCloseTag = bImplicitCloseTag;
    }

    public void print(String s) {
        int length = s.length();
        if (this.bufferSize + length >= 1024) {
            try {
                this.writer.write(this.buffer, 0, this.bufferSize);
                this.writer.write(s);
                this.bufferSize = 0;
            }
            catch (IOException iOException) {}
        } else {
            s.getChars(0, length, this.buffer, this.bufferSize);
            this.bufferSize += length;
        }
    }

    public void println() {
        this.print('\n');
    }

    public void println(String s) {
        this.print(s);
        this.print('\n');
    }

    public void print(char c) {
        if (this.bufferSize >= 1024) {
            this.flush();
        }
        this.buffer[this.bufferSize++] = c;
    }

    protected void flush() {
        if (this.bufferSize > 0) {
            try {
                this.writer.write(this.buffer, 0, this.bufferSize);
            }
            catch (IOException iOException) {}
            this.bufferSize = 0;
        }
    }
}

