/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.RGBColorValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class PropertyUtil {
    private static Logger logger = Logger.getLogger(PropertyUtil.class.getName());
    private static int screenDpi = -1;

    public static boolean isBoldFont(CSSValue value) {
        return value != null && (IStyle.BOLD_VALUE.equals(value) || IStyle.BOLDER_VALUE.equals(value) || IStyle.NUMBER_600.equals(value) || IStyle.NUMBER_700.equals(value) || IStyle.NUMBER_800.equals(value) || IStyle.NUMBER_900.equals(value));
    }

    public static boolean isInlineElement(IContent content) {
        IStyle style = content.getStyle();
        if (style != null) {
            return IStyle.INLINE_VALUE.equals(style.getProperty(54));
        }
        return false;
    }

    public static int getLineHeight(String lineHeight) {
        block3: {
            try {
                if (!lineHeight.equalsIgnoreCase("normal")) break block3;
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.WARNING, "invalid line height: {0}", lineHeight);
                return 0;
            }
        }
        return (int)Float.parseFloat(lineHeight);
    }

    public static Color getColor(CSSValue value) {
        if (value != null && value instanceof RGBColorValue) {
            RGBColorValue color = (RGBColorValue)value;
            try {
                return new Color(color.getRed().getFloatValue((short)1) / 255.0f, color.getGreen().getFloatValue((short)1) / 255.0f, color.getBlue().getFloatValue((short)1) / 255.0f);
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.WARNING, "invalid color: {0}", value);
            }
        }
        return null;
    }

    public static Color getColor(String color) {
        String[] rgb;
        if (color == null || color.length() == 0) {
            return null;
        }
        if (color.charAt(0) == '#') {
            return PropertyUtil.hexToColor(color);
        }
        if (color.equalsIgnoreCase("Black")) {
            return Color.black;
        }
        if (color.equalsIgnoreCase("Gray")) {
            return Color.gray;
        }
        if (color.equalsIgnoreCase("White")) {
            return Color.white;
        }
        if (color.equalsIgnoreCase("Red")) {
            return Color.red;
        }
        if (color.equalsIgnoreCase("Green")) {
            return Color.green;
        }
        if (color.equalsIgnoreCase("Yellow")) {
            return Color.yellow;
        }
        if (color.equalsIgnoreCase("Blue")) {
            return Color.blue;
        }
        if (color.equalsIgnoreCase("Teal")) {
            return PropertyUtil.hexToColor("#008080");
        }
        if (color.equalsIgnoreCase("Aqua")) {
            return PropertyUtil.hexToColor("#00FFFF");
        }
        if (color.equalsIgnoreCase("Silver")) {
            return PropertyUtil.hexToColor("#C0C0C0");
        }
        if (color.equalsIgnoreCase("Navy")) {
            return PropertyUtil.hexToColor("#000080");
        }
        if (color.equalsIgnoreCase("Lime")) {
            return PropertyUtil.hexToColor("#00FF00");
        }
        if (color.equalsIgnoreCase("Olive")) {
            return PropertyUtil.hexToColor("#808000");
        }
        if (color.equalsIgnoreCase("Purple")) {
            return PropertyUtil.hexToColor("#800080");
        }
        if (color.equalsIgnoreCase("Fuchsia")) {
            return PropertyUtil.hexToColor("#FF00FF");
        }
        if (color.equalsIgnoreCase("Maroon")) {
            return PropertyUtil.hexToColor("#800000");
        }
        Pattern p = Pattern.compile("rgb\\(.+,.+,.+\\)");
        Matcher m = p.matcher(color);
        if (m.find() && (rgb = color.substring(m.start() + 4, m.end() - 1).split(",")).length == 3) {
            try {
                int red = Integer.parseInt(rgb[0].trim());
                int green = Integer.parseInt(rgb[1].trim());
                int blue = Integer.parseInt(rgb[2].trim());
                return new Color(red, green, blue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return null;
    }

    static final Color hexToColor(String value) {
        Color c;
        String digits = value.startsWith("#") ? value.substring(1, Math.min(value.length(), 7)) : value;
        String hstr = "0x" + digits;
        try {
            c = Color.decode(hstr);
        }
        catch (NumberFormatException numberFormatException) {
            c = null;
        }
        return c;
    }

    public static int getFontStyle(String fontStyle, String fontWeight) {
        int styleValue = 0;
        if ("oblique".equals(fontStyle) || "italic".equals(fontStyle)) {
            styleValue |= 2;
        }
        if ("bold".equals(fontWeight) || "bolder".equals(fontWeight) || "600".equals(fontWeight) || "700".equals(fontWeight) || "800".equals(fontWeight) || "900".equals(fontWeight)) {
            styleValue |= 1;
        }
        return styleValue;
    }

    public static String getBackgroundImage(CSSValue value) {
        String strValue;
        if (value != null && value instanceof StringValue && (strValue = ((StringValue)value).getStringValue()) != null && !"none".equals(strValue)) {
            return strValue;
        }
        return null;
    }

    public static int getImageDpi(IImageContent content, int imageFileDpi, int renderOptionDpi) {
        int resolution = imageFileDpi;
        if (resolution == 0) {
            resolution = PropertyUtil.getRenderDpi(content, renderOptionDpi);
        }
        return resolution;
    }

    public static int getRenderDpi(IReportContent content, int renderOptionDpi) {
        int resolution = renderOptionDpi;
        if (resolution == 0) {
            ReportDesignHandle designHandle = content.getDesign().getReportDesign();
            resolution = designHandle.getImageDPI();
        }
        if (resolution == 0) {
            resolution = PropertyUtil.getScreenDpi();
        }
        if (resolution == 0) {
            resolution = 96;
        }
        return resolution;
    }

    public static int getRenderDpi(IContent content, int renderOptionDpi) {
        return PropertyUtil.getRenderDpi(content.getReportContent(), renderOptionDpi);
    }

    private static int getScreenDpi() {
        if (-1 == screenDpi) {
            try {
                screenDpi = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (HeadlessException headlessException) {
                screenDpi = 0;
            }
            if (screenDpi < 96 || screenDpi > 120) {
                screenDpi = 0;
            }
        }
        return screenDpi;
    }

    public static int getDimensionValue(CSSValue value) {
        return PropertyUtil.getDimensionValue(value, 96, 0);
    }

    public static int getDimensionValue(CSSValue value, int referenceLength) {
        return PropertyUtil.getDimensionValue(value, 96, referenceLength);
    }

    public static int getDimensionValueConsiderDpi(CSSValue value, IContent content) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 10: {
                    return (int)(v * 12.0f * 1000.0f);
                }
                case 5: {
                    ReportDesignHandle designHandle = content.getReportContent().getDesign().getReportDesign();
                    int dpi = designHandle.getImageDPI();
                    if (dpi == 0) {
                        dpi = 96;
                    }
                    return (int)(v / (float)dpi * 72000.0f);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
            }
        }
        return 0;
    }

    private static int getDimensionValue(CSSValue value, int dpi, int referenceLength) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 10: {
                    return (int)(v * 12.0f * 1000.0f);
                }
                case 5: {
                    return (int)(v / (float)dpi * 72000.0f);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
                case 2: {
                    return (int)((double)((float)referenceLength * v) / 100.0);
                }
            }
        }
        return 0;
    }

    public static int getDimensionValue(IContent content, DimensionType d) {
        return PropertyUtil.getDimensionValue(content, d, 0, 0);
    }

    protected static int _getDimensionValue(IContent content, DimensionType d, int dpi, int referenceLength) {
        if (d.getValueType() == 1) {
            String units = d.getUnits();
            if (units.equals("pt") || units.equals("cm") || units.equals("mm") || units.equals("pc") || units.equals("in")) {
                double point = d.convertTo("pt") * 1000.0;
                return (int)point;
            }
            if (units.equals("px")) {
                if (dpi == 0) {
                    dpi = 96;
                }
                double point = d.getMeasure() / (double)dpi * 72000.0;
                return (int)point;
            }
            if (units.equals("%")) {
                double point = (double)referenceLength * d.getMeasure() / 100.0;
                return (int)point;
            }
            if (units.equals("em") || units.equals("ex")) {
                int size = 9000;
                if (content != null) {
                    IStyle style = content.getComputedStyle();
                    CSSValue fontSize = style.getProperty(44);
                    size = PropertyUtil.getDimensionValue(fontSize);
                }
                double point = (double)size * d.getMeasure();
                return (int)point;
            }
        } else if (d.getValueType() == 0) {
            String choice = d.getChoice();
            if ("medium".equals(choice)) {
                return 3000;
            }
            if ("thin".equals(choice)) {
                return 1000;
            }
            if ("thick".equals(choice)) {
                return 5000;
            }
        }
        return 0;
    }

    public static int getImageDimensionValue(IContent content, DimensionType d, int dpi, int referenceLength) {
        if (d == null) {
            return -1;
        }
        try {
            return PropertyUtil._getDimensionValue(content, d, dpi, referenceLength);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
            return -1;
        }
    }

    public static int getDimensionValue(IContent content, DimensionType d, int dpi, int referenceLength) {
        if (d == null) {
            return 0;
        }
        try {
            return PropertyUtil._getDimensionValue(content, d, dpi, referenceLength);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
            return 0;
        }
    }

    public static int getDimensionValue(IContent content, DimensionType d, int referenceLength) {
        return PropertyUtil.getDimensionValue(content, d, 0, referenceLength);
    }

    public static int getIntAttribute(Element element, String attribute) {
        String value = element.getAttribute(attribute);
        int result = 1;
        if (value != null && value.length() != 0) {
            result = Integer.parseInt(value);
        }
        return result;
    }

    public static DimensionType getDimensionAttribute(Element ele, String attribute) {
        String value = ele.getAttribute(attribute);
        if (value == null || value.length() == 0) {
            return null;
        }
        return DimensionType.parserUnit(value, "px");
    }

    public static int getIntValue(CSSValue value) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            return (int)fv.getFloatValue();
        }
        return 0;
    }

    public static float getPercentageValue(CSSValue value) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            if (2 == fv.getPrimitiveType()) {
                return v / 100.0f;
            }
        }
        return 0.0f;
    }

    public static boolean isWhiteSpaceNoWrap(CSSValue value) {
        return "nowrap".equals(value.getCssText());
    }
}

