#########################
#auteur : Audrey Jacques-Gustave
#date : 14/10/2010
#algo : Tirage aléatoire pour le carré latin
#référence : document Algo_softeam.doc (page 14)
#date modification : 25/05/2011
#########################
# usage :
# Rscript algo_carre_latin_script.R val_T file_output.csv emplacement_PNG/
#########################
## récupération des arguments
args <- commandArgs()
args <- args[match("--args", args): length(args)]
args <- args[-1]
#########################

source("affichage_dispositif.R")
#########################
## définition de la fonction de randomisation
permute <- function(V,t0,t1,t2){
  Vperm <- matrix(V,nrow=t2,ncol=(t0*t1))
  for(j in 1:t0){
    Vperm[,t1*(j-1)+1:t1] <- Vperm[,t1*(j-1)+sample(t1)]
  }
  return(Vperm)
}
#########################
## définition de la fonction de permutation circulaire
PermuteCirculaire <- function(V){
  lvec <- length(V)
  Vperm <- c(lvec,seq(1:(lvec-1)))
  sortie <- V[Vperm]
  return(sortie)
}

########################
########################
## définition de la fonction pour tester les variables en entrée du carré latin
# T:entier, nombre de traitement
test_entree_CarreLatin<- function(T){
  if(is.numeric(T)==FALSE){
    err_file<-file("error_carre.txt", open="at")
    write(paste(format(Sys.time(),"%b %d %Y %H-%M-%S"),": Erreur pour T, valeur numérique attendue"),err_file)
    close(err_file)
    return(FALSE)
  }else{
    if(length(T)>1){
      err_file <- file("error_carre.txt",open="at")
      write(paste(format(Sys.time(),"%b %d %Y %H-%M-%S"),": Erreur pour T : une seule valeur attendue"),err_file)
      close(err_file)
      return(FALSE)
    }
    if(T<1){
      err_file<-file("error_carre.txt", open="at")
      write(paste(format(Sys.time(),"%b %d %Y %H-%M-%S"),": Erreur pour T, la valeur ne peut être < 1"),err_file)  
      close(err_file)
      return(FALSE)
    }else{
      return(TRUE)
    }
  }
}
########################

########################
## définition de la fonction pour le carré latin
# T:entier, nombre de traitement
# file:chaîne de caractère, fichier csv où le résultat sera sauvegardé
getDispositif_latin_Square <- function(T,file,perso=""){
  ok <- test_entree_CarreLatin(T)
  if(ok==FALSE){
    print("Erreur, variables en entree sont incorrectes. Voir détail dans le fichier error_carre.txt")
    return(FALSE)
  }
  B <- T
  K <- T
  N <- T*T
  ##Créer structure Adonis dispositif pour B blocs, K PU
  sAdonis <- expand.grid(PU=1:T,Bloc=1:T)
  sAdonis <- cbind(sAdonis,"Sous-Bloc"=rep(0,N),m1=rep(0,N),m2=rep(0,N),m3=rep(0,N))
  sAdonis <- cbind(sAdonis,expand.grid(X=1:K,Y=1:B))
 
  sAdonis$Trt <- sAdonis$PU
  sAdonis<- sAdonis[,c("Bloc","Sous-Bloc","PU","Trt","m1","m2","m3","X","Y")]
  nU <- c(1:N)
  nUr <-  nU
  nUind <- rep(1:K,each=B)

  ##permutation circulaire de chaque pu dans chaques blocs

  i <- 1
  while(i < N+1){
    nUr[i:N] <- as.numeric(unlist(tapply(nUr[i:N],nUind[i:N],function(x){PermuteCirculaire(x)})))
    i <- i + T
  }	
  
  #browser()
  ##randomisation des lignes entre elles
  nUr <- permute(nUr,1,T,T)
  nUr <- c(nUr)
  
  
  
  ##randomisation des colonnes entre elles
  nUr <- matrix(nUr,nrow=K,ncol=B,byrow=TRUE)
  
  nUr[,1:T] <- nUr[,sample(T)]
  
  nUr <- as.numeric(unlist(c(as.data.frame(nUr))))
  sAdonis[,c("Trt")] <- sAdonis[nUr,c("Trt")]
  
  ## sauvegarde du dispositif dans un fichier format csv
  write.table(sAdonis,file,row.names=FALSE,sep=";")
  

  dispo <- read.table(file,header=TRUE,sep=";")
  affiche_dispositif(dispo,paste(perso,"CarreLatin_",format(Sys.time(),"%b_%d_%Y_%H%M%S"),".png",sep=""),"Carré Latin")
  return(sAdonis)
}
########################


## affectation des arguments
T<- as.numeric(args[1])
file <- args[2]
if(length(args)>2){
  direct <- args[3]
}else{
  direct <- ""
}


## appel de la fonction
getDispositif_latin_Square(T,file,perso=direct)






  
