/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.visualisation.notes.filters;

import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import fr.inra.adonis.visualisation.notes.VisualisationNotesComponent;
import fr.inra.adonis.visualisation.notes.WrapperColonne;
import fr.inra.adonis.visualisation.notes.filters.LineSelectorDialog;
import fr.inra.adonis.visualisation.notes.filters.LineViewerFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SelectersComponent
extends Composite {
    private static final int MARGIN = 5;
    public static final String ALL = "[Tous]";
    private final FormToolkit toolkit;
    private final ComboViewer comboUniteParcours;
    private final VisualisationNotesComponent visuTabCompo;

    public SelectersComponent(final Composite parent, final VisualisationNotesComponent visuTabCompo, int style) {
        super(parent, style);
        this.visuTabCompo = visuTabCompo;
        this.toolkit = new FormToolkit(Display.getCurrent());
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.setLayoutData(new GridData(16384, 128, true, false));
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        this.setLayout((Layout)gridLayout);
        this.toolkit.createLabel((Composite)this, "Choisir l'unit\u00e9 de parcours :");
        List<Object> input = this.getComboParcoursList();
        this.comboUniteParcours = new ComboViewer((Composite)this);
        this.comboUniteParcours.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboUniteParcours.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.comboUniteParcours.setInput(input);
        this.comboUniteParcours.addSelectionChangedListener((ISelectionChangedListener)new RefreshViewerEvent());
        this.comboUniteParcours.getCombo().select(0);
        Button selectButton = this.toolkit.createButton((Composite)this, "S\u00e9lectionner les colonnes", 8);
        Button btnFiltrerLesLignes = new Button((Composite)this, 0);
        btnFiltrerLesLignes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineSelectorDialog lineDialog = new LineSelectorDialog(parent.getShell(), visuTabCompo.getTableViewer().getTable().getColumns());
                Map<Integer, String> currentFiltres = ((LineViewerFilter)visuTabCompo.getLineFilter()).getFiltres();
                Map<Integer, String> currentComparateurs = ((LineViewerFilter)visuTabCompo.getLineFilter()).getComparateurs();
                if (currentFiltres != null) {
                    lineDialog.setFiltres(currentFiltres);
                }
                if (currentComparateurs != null) {
                    lineDialog.setComparateurs(currentComparateurs);
                }
                if (lineDialog.open() == 0) {
                    Map<Integer, String> filtres = lineDialog.getFiltres();
                    Map<Integer, String> comparateurs = lineDialog.getComparateurs();
                    ((LineViewerFilter)visuTabCompo.getLineFilter()).setFiltres(filtres);
                    ((LineViewerFilter)visuTabCompo.getLineFilter()).setComparateurs(comparateurs);
                    visuTabCompo.refreshContent();
                }
            }
        });
        this.toolkit.adapt((Control)btnFiltrerLesLignes, true, true);
        btnFiltrerLesLignes.setText("Filtrer les lignes");
        selectButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableColumn[] colonnes = visuTabCompo.getTableViewer().getTable().getColumns();
                HashMap<Integer, WrapperColonne> mapIdxColonnes = visuTabCompo.getMapIdxColonne();
                ListSelectionDialog dialog = new ListSelectionDialog(parent.getShell(), (Object)colonnes, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof TableColumn) {
                            return ((TableColumn)element).getText();
                        }
                        return element.toString();
                    }
                }, "Colonnes \u00e0 afficher : ");
                HashSet<TableColumn> colonnesAffichees = new HashSet<TableColumn>();
                TableColumn[] tableColumnArray = colonnes;
                int n = colonnes.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn col = tableColumnArray[n2];
                    if (col.getWidth() > 0) {
                        colonnesAffichees.add(col);
                    }
                    ++n2;
                }
                if (colonnesAffichees.size() > 0) {
                    dialog.setInitialSelections(colonnesAffichees.toArray());
                }
                dialog.setTitle("Filtre");
                if (dialog.open() == 0) {
                    HashSet<TableColumn> colonnesACacher = new HashSet<TableColumn>();
                    Object[] objectArray = colonnes;
                    int n3 = colonnes.length;
                    n = 0;
                    while (n < n3) {
                        TableColumn col = objectArray[n];
                        colonnesACacher.add(col);
                        ++n;
                    }
                    objectArray = dialog.getResult();
                    n3 = objectArray.length;
                    n = 0;
                    while (n < n3) {
                        TableColumn col = objectArray[n];
                        int id = 0;
                        TableColumn[] tableColumnArray2 = colonnes;
                        int n4 = colonnes.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            TableColumn col2 = tableColumnArray2[n5];
                            if (col.equals(col2)) break;
                            ++id;
                            ++n5;
                        }
                        colonnesACacher.remove(col);
                        WrapperColonne wrapperCol = mapIdxColonnes.get(id);
                        if (wrapperCol.isHorodatage() && colonnes[id - 1].getWidth() == 0) {
                            col.setWidth(0);
                            col.setResizable(false);
                        } else {
                            col.setWidth(80);
                            col.setResizable(true);
                        }
                        ++n;
                    }
                    for (TableColumn col : colonnesACacher) {
                        col.setWidth(0);
                        col.setResizable(false);
                    }
                }
            }
        });
    }

    private List<Object> getComboParcoursList() {
        ArrayList<Object> input = new ArrayList<Object>();
        input.add(ALL);
        if (this.visuTabCompo != null && this.visuTabCompo.getObjetsMetiers() != null) {
            boolean isDispoDonnes = false;
            boolean isBlocDonnes = false;
            boolean isSousBlocDonnes = false;
            boolean isParcelleDonnes = false;
            boolean isIndividuDonnes = false;
            Set<ObjetMetier> objetsMetier = this.visuTabCompo.getObjetsMetiers();
            for (ObjetMetier obj : objetsMetier) {
                if (obj instanceof Dispositif) {
                    isDispoDonnes = true;
                }
                if (obj instanceof Bloc) {
                    isBlocDonnes = true;
                }
                if (obj instanceof SousBloc) {
                    isSousBlocDonnes = true;
                }
                if (obj instanceof ParcelleUnitaire) {
                    isParcelleDonnes = true;
                }
                if (!(obj instanceof Individu)) continue;
                isIndividuDonnes = true;
            }
            SelecterUniteDeParcours item = new SelecterUniteDeParcours();
            item.uniteDeParcours = TypeUniteParcours.DISPOSITIF;
            if (isDispoDonnes) {
                input.add(item);
            }
            item = new SelecterUniteDeParcours();
            item.uniteDeParcours = TypeUniteParcours.BLOC;
            if (isBlocDonnes) {
                input.add(item);
            }
            item = new SelecterUniteDeParcours();
            item.uniteDeParcours = TypeUniteParcours.SOUS_BLOC;
            if (isSousBlocDonnes) {
                input.add(item);
            }
            item = new SelecterUniteDeParcours();
            item.uniteDeParcours = TypeUniteParcours.PARCELLE;
            if (isParcelleDonnes) {
                input.add(item);
            }
            item = new SelecterUniteDeParcours();
            item.uniteDeParcours = TypeUniteParcours.INDIVIDU;
            if (isIndividuDonnes) {
                input.add(item);
            }
        }
        return input;
    }

    private final class RefreshViewerEvent
    implements ISelectionChangedListener {
        private RefreshViewerEvent() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (selection instanceof SelecterUniteDeParcours) {
                SelectersComponent.this.visuTabCompo.setUniteParcoursCourant(((SelecterUniteDeParcours)selection).uniteDeParcours);
            } else {
                SelectersComponent.this.visuTabCompo.setUniteParcoursCourant(null);
            }
            SelectersComponent.this.visuTabCompo.refreshContent();
        }
    }

    private class SelecterUniteDeParcours {
        public TypeUniteParcours uniteDeParcours;

        private SelecterUniteDeParcours() {
        }

        public String toString() {
            return this.uniteDeParcours.toString();
        }
    }
}

