/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.LocalSite;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class SiteStatusAnalyzer {
    private static final String SOURCE_BUNDLES_PATH = "org.eclipse.equinox.source/source.info";
    private static final String ID = "org.eclipse.update.core";
    private static List allConfiguredFeatures;
    private LocalSite siteLocal;
    private List sourceBundles = null;

    public SiteStatusAnalyzer(LocalSite siteLocal) {
        this.siteLocal = siteLocal;
    }

    private IStatus getStatus(IFeature feature) {
        IStatus status;
        ISite featureSite = feature.getSite();
        if (featureSite == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Cannot determine status of feature:" + feature.getLabel() + ". Site is NULL.");
            }
            String msg = NLS.bind((String)Messages.SiteLocal_UnableToDetermineFeatureStatusSiteNull, (Object[])new Object[]{feature.getURL()});
            return this.createStatus(4, 1, msg, null);
        }
        ConfiguredSite cSite = (ConfiguredSite)featureSite.getCurrentConfiguredSite();
        if (cSite == null) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.warn("Cannot determine status of feature: " + feature.getLabel() + ". Configured Site is NULL.");
            }
            String msg = NLS.bind((String)Messages.SiteLocal_UnableToDetermineFeatureStatusConfiguredSiteNull, (Object[])new Object[]{feature.getURL()});
            return this.createStatus(4, 1, msg, null);
        }
        ISiteFeatureReference ref = cSite.getSite().getFeatureReference(feature);
        if (ref != null) {
            if (!cSite.getConfigurationPolicy().isConfigured(ref)) {
                return this.createStatus(0, -1, "", null);
            }
        } else if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
            UpdateCore.warn("Unable to find reference for feature " + feature + " in site " + cSite.getSite().getURL());
        }
        if ((status = cSite.getBrokenStatus(feature)).getSeverity() != 0) {
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_CONFIGURATION) {
                UpdateCore.debug("Feature broken:" + feature.getLabel() + ".Site:" + cSite.toString());
            }
            return status;
        }
        IPluginEntry[] featuresEntries = feature.getPluginEntries();
        return this.status(feature, featuresEntries);
    }

    public IStatus getFeatureStatus(IFeature feature) throws CoreException {
        IFeature childFeature = null;
        IIncludedFeatureReference[] children = feature.getIncludedFeatureReferences();
        String msg = Messages.SiteLocal_FeatureDisable;
        int code = -1;
        IStatus featureStatus = this.getStatus(feature);
        MultiStatus multiTemp = new MultiStatus(featureStatus.getPlugin(), code, msg, null);
        if (featureStatus.getSeverity() == 4) {
            if (featureStatus.isMultiStatus()) {
                multiTemp.addAll(featureStatus);
            } else {
                multiTemp.add(featureStatus);
            }
        }
        if (featureStatus.getCode() > code) {
            code = featureStatus.getCode();
        }
        if (code != -1) {
            int i = 0;
            while (i < children.length) {
                if (!UpdateManagerUtils.isOptional(children[i])) {
                    block22: {
                        try {
                            childFeature = children[i].getFeature(null);
                        }
                        catch (CoreException coreException) {
                            childFeature = null;
                            if (UpdateManagerUtils.isOptional(children[i])) break block22;
                            UpdateCore.warn("Error retrieving feature:" + children[i]);
                        }
                    }
                    if (childFeature == null) {
                        UpdateCore.warn("getFeatureStatus: Feature is null for:" + children[i]);
                        Object featureAsPrintableObject = children[i].getURL();
                        featureAsPrintableObject = children[i].getVersionedIdentifier();
                        String msg1 = NLS.bind((String)Messages.SiteLocal_NestedFeatureUnavailable, (Object[])new Object[]{featureAsPrintableObject});
                        multiTemp.add(this.createStatus(4, 2, msg1, null));
                        if (2 > code) {
                            code = 2;
                        }
                    } else {
                        String msg1;
                        String featureVer;
                        VersionedIdentifier versionID;
                        IStatus childStatus = this.getFeatureStatus(childFeature);
                        if (childStatus.getCode() == -1) {
                            versionID = childFeature.getVersionedIdentifier();
                            featureVer = versionID == null ? "" : versionID.getVersion().toString();
                            msg1 = NLS.bind((String)Messages.SiteLocal_NestedFeatureDisable, (Object[])new String[]{childFeature.getLabel(), featureVer});
                            multiTemp.add(this.createStatus(4, childStatus.getCode(), msg1, null));
                            if (2 > code) {
                                code = 2;
                            }
                        }
                        if (childStatus.getSeverity() != 0) {
                            versionID = childFeature.getVersionedIdentifier();
                            featureVer = versionID == null ? "" : versionID.getVersion().toString();
                            msg1 = NLS.bind((String)Messages.SiteLocal_NestedFeatureUnHappy, (Object[])new String[]{childFeature.getLabel(), featureVer});
                            multiTemp.add(this.createStatus(4, childStatus.getCode(), msg1, null));
                            if (childStatus.getCode() > code) {
                                code = childStatus.getCode();
                            }
                        }
                    }
                }
                ++i;
            }
        }
        switch (code) {
            case 0: {
                msg = Messages.SiteLocal_FeatureHappy;
                break;
            }
            case 2: {
                msg = Messages.SiteLocal_FeatureUnHappy;
                break;
            }
            case 1: {
                msg = Messages.SiteLocal_FeatureAmbiguous;
                break;
            }
            case -1: {
                msg = Messages.SiteLocal_FeatureDisable;
                break;
            }
            default: {
                msg = Messages.SiteLocal_FeatureStatusUnknown;
            }
        }
        MultiStatus multi = new MultiStatus(featureStatus.getPlugin(), code, msg, null);
        multi.addAll((IStatus)multiTemp);
        return multi;
    }

    private IStatus status(IFeature pluginsOriginatorFeature, IPluginEntry[] featurePlugins) {
        String happyMSG = Messages.SiteLocal_FeatureHappy;
        String ambiguousMSG = Messages.SiteLocal_FeatureAmbiguous;
        IStatus featureStatus = this.createStatus(0, 0, "", null);
        MultiStatus multi = new MultiStatus(featureStatus.getPlugin(), 1, ambiguousMSG, null);
        PackageAdmin pkgAdmin = UpdateCore.getPlugin().getPackageAdmin();
        int i = 0;
        while (i < featurePlugins.length) {
            MultiStatus tempmulti = new MultiStatus(featureStatus.getPlugin(), 1, ambiguousMSG, null);
            VersionedIdentifier featurePluginID = featurePlugins[i].getVersionedIdentifier();
            boolean found = false;
            String singleVersionRange = String.valueOf('[') + featurePluginID.getVersion().toString() + ',' + featurePluginID.getVersion().toString() + ']';
            Bundle[] bundles = pkgAdmin.getBundles(featurePluginID.getIdentifier(), singleVersionRange);
            if (bundles != null && bundles.length == 1) {
                found = true;
            } else {
                bundles = pkgAdmin.getBundles(featurePluginID.getIdentifier(), null);
                int j = 0;
                while (bundles != null && j < bundles.length && !found) {
                    String bundleVersion = (String)bundles[j].getHeaders().get("Bundle-Version");
                    IFeature feature = this.getFeatureForId(new VersionedIdentifier(bundles[j].getSymbolicName(), bundleVersion));
                    if (feature != null && !this.isFeaturePatchOfThisFeature(pluginsOriginatorFeature, feature)) {
                        String msg = null;
                        if (feature == null) {
                            Object[] values = new Object[]{bundles[j].getSymbolicName(), featurePluginID.getVersion(), bundleVersion};
                            msg = NLS.bind((String)Messages.SiteLocal_TwoVersionSamePlugin1, (Object[])values);
                        } else {
                            String label = feature.getLabel();
                            String featureVersion = feature.getVersionedIdentifier().getVersion().toString();
                            Object[] values = new Object[]{bundles[j].getSymbolicName(), featurePluginID.getVersion(), bundleVersion, label, featureVersion};
                            msg = NLS.bind((String)Messages.SiteLocal_TwoVersionSamePlugin2, (Object[])values);
                        }
                        UpdateCore.warn("Found another version of the same plugin on the path:" + bundles[j].getSymbolicName() + " " + bundleVersion);
                        tempmulti.add(this.createStatus(4, 1, msg, null));
                    } else {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    this.loadSourceBundlesList();
                    Iterator iter = this.sourceBundles.iterator();
                    while (iter.hasNext()) {
                        VersionedIdentifier nextId = (VersionedIdentifier)iter.next();
                        if (!featurePluginID.equals(nextId)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    if (tempmulti.getChildren().length > 0) {
                        multi.addAll((IStatus)tempmulti);
                    } else {
                        if (multi.getCode() != 2) {
                            String unhappyMSG = Messages.SiteLocal_FeatureUnHappy;
                            MultiStatus newMulti = new MultiStatus(featureStatus.getPlugin(), 2, unhappyMSG, null);
                            newMulti.addAll((IStatus)multi);
                            multi = newMulti;
                        }
                        String msg = NLS.bind((String)Messages.SiteLocal_NoPluginVersion, (Object[])new String[]{featurePluginID.getIdentifier()});
                        multi.add(this.createStatus(4, 2, msg, null));
                    }
                }
            }
            ++i;
        }
        if (!multi.isOK()) {
            return multi;
        }
        return this.createStatus(0, 0, happyMSG, null);
    }

    public static File toFile(URL url) {
        block3: {
            try {
                if ("file".equalsIgnoreCase(url.getProtocol())) break block3;
                return null;
            }
            catch (Exception exception) {
                return new File(url.getFile());
            }
        }
        return new File(new URI(url.toExternalForm()));
    }

    private void loadSourceBundlesList() {
        if (this.sourceBundles != null) {
            return;
        }
        this.sourceBundles = new ArrayList(32);
        IPlatformConfiguration config = ConfiguratorUtils.getCurrentPlatformConfiguration();
        URL configLocation = config.getConfigurationLocation();
        if (configLocation == null) {
            return;
        }
        File configDir = SiteStatusAnalyzer.toFile(configLocation);
        if ((configDir = configDir.getParentFile()) == null) {
            return;
        }
        if ((configDir = configDir.getParentFile()) == null) {
            return;
        }
        File sourceBundlesFile = new File(configDir, SOURCE_BUNDLES_PATH);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(sourceBundlesFile));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    StringTokenizer tok;
                    String symbolicName;
                    if (line.startsWith("#") || (line = line.trim()).length() == 0 || (symbolicName = (tok = new StringTokenizer(line, ",", true)).nextToken()).equals(",")) continue;
                    tok.nextToken();
                    String version = tok.nextToken();
                    if (version.equals(",")) continue;
                    tok.nextToken();
                    VersionedIdentifier sourceId = new VersionedIdentifier(symbolicName, version);
                    this.sourceBundles.add(sourceId);
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException e) {
            UpdateCore.log((IStatus)new Status(4, ID, "Error occurred while reading source bundle list.", (Throwable)e));
        }
        catch (IOException e) {
            UpdateCore.log((IStatus)new Status(4, ID, "Error occurred while reading source bundle list.", (Throwable)e));
        }
    }

    private boolean isFeaturePatchOfThisFeature(IFeature pluginsOriginatorFeature, IFeature feature) {
        if (!feature.isPatch()) {
            return false;
        }
        IImport[] featureImports = feature.getImports();
        if (featureImports == null) {
            return false;
        }
        int i = 0;
        while (i < featureImports.length) {
            if (featureImports[i].isPatch() && featureImports[i].getVersionedIdentifier().equals(pluginsOriginatorFeature.getVersionedIdentifier())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IStatus createStatus(int statusSeverity, int statusCode, String msg, Exception e) {
        String id = UpdateCore.getPlugin().getBundle().getSymbolicName();
        StringBuffer completeString = new StringBuffer("");
        if (msg != null) {
            completeString.append(msg);
        }
        if (e != null) {
            completeString.append("\r\n[");
            completeString.append(e.toString());
            completeString.append("]\r\n");
        }
        return new Status(statusSeverity, id, statusCode, completeString.toString(), (Throwable)e);
    }

    private IFeature[] getAllConfiguredFeatures() {
        if (allConfiguredFeatures == null) {
            allConfiguredFeatures = new ArrayList();
            IConfiguredSite[] allConfiguredSites = this.siteLocal.getCurrentConfiguration().getConfiguredSites();
            int i = 0;
            while (i < allConfiguredSites.length) {
                IFeatureReference[] refs = allConfiguredSites[i].getConfiguredFeatures();
                IFeature feature = null;
                int j = 0;
                while (j < refs.length) {
                    feature = null;
                    try {
                        feature = refs[j].getFeature(null);
                    }
                    catch (CoreException coreException) {}
                    if (feature != null) {
                        allConfiguredFeatures.add(feature);
                    }
                    ++j;
                }
                ++i;
            }
        }
        IFeature[] features = new IFeature[allConfiguredFeatures.size()];
        if (allConfiguredFeatures.size() > 0) {
            allConfiguredFeatures.toArray(features);
        }
        return features;
    }

    private IFeature getFeatureForId(VersionedIdentifier id) {
        if (id == null) {
            return null;
        }
        IFeature[] allFeatures = this.getAllConfiguredFeatures();
        IFeature currentFeature = null;
        IPluginEntry[] allPlugins = null;
        IPluginEntry currentPlugin = null;
        int i = 0;
        while (i < allFeatures.length) {
            currentFeature = allFeatures[i];
            allPlugins = currentFeature.getPluginEntries();
            int j = 0;
            while (j < allPlugins.length) {
                currentPlugin = allPlugins[j];
                if (id.equals(currentPlugin.getVersionedIdentifier())) {
                    return currentFeature;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

