/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportBodyExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.w3c.dom.css.CSSValue;

public class ReportletBodyExecutor
implements IReportItemExecutor {
    long offset;
    IReportItemExecutor bodyExecutor;
    ArrayList<IReportItemExecutor> parentExecutors = new ArrayList();
    IContent bodyContent;
    IReportItemExecutor childExecutor;

    ReportletBodyExecutor(ExecutorManager manager, Fragment fragment, long offset) throws BirtException {
        this.bodyExecutor = new ReportBodyExecutor(manager, fragment);
        this.offset = offset;
        this.parentExecutors.add(this.bodyExecutor);
        this.doExecute();
    }

    public void close() throws BirtException {
        if (!this.parentExecutors.isEmpty()) {
            for (IReportItemExecutor executor : this.parentExecutors) {
                executor.close();
            }
            this.parentExecutors.clear();
        }
        this.bodyExecutor = null;
        this.childExecutor = null;
    }

    protected void doExecute() throws BirtException {
        IReportItemExecutor executor = this.bodyExecutor;
        IContent content = null;
        while (executor.hasNextChild()) {
            executor = executor.getNextChild();
            this.parentExecutors.add(executor);
            content = executor.execute();
            DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
            if (docExt == null || docExt.getIndex() != this.offset) continue;
            this.bodyContent = content;
            this.childExecutor = executor;
            break;
        }
        IStyle cs = this.bodyContent.getComputedStyle();
        IStyle is = this.bodyContent.getInlineStyle();
        CSSEngine engine = this.bodyContent.getCSSEngine();
        IStyle mergedStyle = is != null ? is : new StyleDeclaration(engine);
        int i = 0;
        while (i < 59) {
            if (this.isNullValue(mergedStyle.getProperty(i)) && engine.isInheritedProperty(i)) {
                mergedStyle.setProperty(i, cs.getProperty(i));
            }
            ++i;
        }
        this.bodyContent.setInlineStyle(mergedStyle);
    }

    private boolean isNullValue(CSSValue value) {
        if (value == null) {
            return true;
        }
        if (value instanceof DataFormatValue) {
            return true;
        }
        String cssText = value.getCssText();
        return "none".equalsIgnoreCase(cssText) || "transparent".equalsIgnoreCase(cssText);
    }

    public IContent execute() {
        return null;
    }

    public IContent getContent() {
        return this.bodyContent;
    }

    public IExecutorContext getContext() {
        return this.bodyExecutor.getContext();
    }

    public Object getModelObject() {
        return this.bodyExecutor.getModelObject();
    }

    public IReportItemExecutor getNextChild() {
        if (this.childExecutor != null) {
            IReportItemExecutor executor = this.childExecutor;
            this.childExecutor = null;
            return executor;
        }
        return null;
    }

    public IReportItemExecutor getParent() {
        return null;
    }

    public IBaseResultSet[] getQueryResults() {
        return null;
    }

    public boolean hasNextChild() {
        return this.childExecutor != null;
    }

    public void setContext(IExecutorContext context) {
    }

    public void setModelObject(Object handle) {
    }

    public void setParent(IReportItemExecutor parent) {
    }
}

