/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.content.impl.ObjectContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.HTMLConstants;
import org.eclipse.birt.report.engine.layout.pdf.util.HTMLStyleProcessor;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.layout.pdf.util.StyleProperties;
import org.eclipse.birt.report.engine.layout.pdf.util.TableProcessor;
import org.eclipse.birt.report.engine.layout.pdf.util.Tag2Style;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTML2Content
implements HTMLConstants {
    protected static final HashSet htmlBlockDisplay = new HashSet();
    protected static final HashSet htmlInlineDisplay = new HashSet();
    protected static final HashMap textTypeMapping = new HashMap();

    static {
        htmlInlineDisplay.add("i");
        htmlInlineDisplay.add("font");
        htmlInlineDisplay.add("b");
        htmlInlineDisplay.add("a");
        htmlInlineDisplay.add("code");
        htmlInlineDisplay.add("em");
        htmlInlineDisplay.add("object");
        htmlInlineDisplay.add("img");
        htmlInlineDisplay.add("ins");
        htmlInlineDisplay.add("span");
        htmlInlineDisplay.add("strong");
        htmlInlineDisplay.add("sub");
        htmlInlineDisplay.add("sup");
        htmlInlineDisplay.add("tt");
        htmlInlineDisplay.add("u");
        htmlInlineDisplay.add("del");
        htmlInlineDisplay.add("strike");
        htmlInlineDisplay.add("s");
        htmlInlineDisplay.add("big");
        htmlInlineDisplay.add("small");
        htmlBlockDisplay.add("dd");
        htmlBlockDisplay.add("div");
        htmlBlockDisplay.add("dl");
        htmlBlockDisplay.add("dt");
        htmlBlockDisplay.add("h1");
        htmlBlockDisplay.add("h2");
        htmlBlockDisplay.add("h3");
        htmlBlockDisplay.add("h4");
        htmlBlockDisplay.add("h5");
        htmlBlockDisplay.add("h6");
        htmlBlockDisplay.add("hr");
        htmlBlockDisplay.add("ol");
        htmlBlockDisplay.add("p");
        htmlBlockDisplay.add("pre");
        htmlBlockDisplay.add("ul");
        htmlBlockDisplay.add("li");
        htmlBlockDisplay.add("address");
        htmlBlockDisplay.add("body");
        htmlBlockDisplay.add("center");
        htmlBlockDisplay.add("table");
        htmlBlockDisplay.add("td");
        htmlBlockDisplay.add("tr");
        textTypeMapping.put("text/html", TextParser.TEXT_TYPE_HTML);
        textTypeMapping.put("text/plaintext", TextParser.TEXT_TYPE_PLAIN);
        textTypeMapping.put("binary/unknown", TextParser.TEXT_TYPE_AUTO);
    }

    public static void html2Content(IForeignContent foreign) {
        HTML2Content.processForeignData(foreign);
    }

    protected static void processForeignData(IForeignContent foreign) {
        Node node;
        if (foreign.getChildren() != null && foreign.getChildren().size() > 0) {
            return;
        }
        HashMap<Element, StyleProperties> styleMap = new HashMap<Element, StyleProperties>();
        ReportDesignHandle reportDesign = foreign.getReportContent().getDesign().getReportDesign();
        HTMLStyleProcessor htmlProcessor = new HTMLStyleProcessor(reportDesign);
        Object rawValue = foreign.getRawValue();
        Node doc = null;
        if (rawValue != null) {
            doc = new TextParser().parse(foreign.getRawValue().toString(), (String)textTypeMapping.get(foreign.getRawType()));
        }
        Element body = null;
        if (doc != null && (node = doc.getFirstChild()) instanceof Element) {
            body = (Element)node;
        }
        if (body != null) {
            htmlProcessor.execute(body, styleMap, foreign.getReportContent().getReportContext() == null ? null : foreign.getReportContent().getReportContext().getAppContext());
            IContainerContent container = foreign.getReportContent().createContainerContent();
            IStyle parentStyle = foreign.getStyle();
            if (CSSValueConstants.INLINE_VALUE.equals(parentStyle.getProperty(54))) {
                container.getStyle().setProperty(54, CSSValueConstants.INLINE_VALUE);
            }
            HTML2Content.addChild(foreign, container);
            HTML2Content.processNodes(body, styleMap, container, null);
        }
    }

    protected static ILabelContent createLabel(String text, IContent parent) {
        ILabelContent label = parent.getReportContent().createLabelContent();
        HTML2Content.addChild(parent, label);
        label.setText(text);
        StyleDeclaration inlineStyle = new StyleDeclaration(parent.getCSSEngine());
        inlineStyle.setProperty(54, CSSValueConstants.INLINE_VALUE);
        label.setInlineStyle(inlineStyle);
        return label;
    }

    static void processNodes(Element ele, Map cssStyles, IContent content, ActionContent action) {
        int level = 0;
        Node node = ele.getFirstChild();
        while (node != null) {
            if (node.getNodeName().equals("value-of")) {
                if (node.getFirstChild() instanceof Element) {
                    HTML2Content.processNodes((Element)node.getFirstChild(), cssStyles, content, action);
                }
            } else if (node.getNodeName().equals("image")) {
                if (node.getFirstChild() instanceof Element) {
                    HTML2Content.processNodes((Element)node.getFirstChild(), cssStyles, content, action);
                }
            } else if (!node.getNodeName().equals("script")) {
                if (node.getNodeType() == 3) {
                    ILabelContent label = HTML2Content.createLabel(node.getNodeValue(), content);
                    if (action != null) {
                        label.setHyperlinkAction(action);
                    }
                } else if (node.getNodeType() == 1) {
                    HTML2Content.handleElement((Element)node, cssStyles, content, action, ++level);
                }
            }
            node = node.getNextSibling();
        }
    }

    static void handleElement(Element ele, Map<Element, StyleProperties> cssStyles, IContent content, ActionContent action, int index) {
        StyleProperties sp = cssStyles.get(ele);
        if (sp != null && "none".equals(sp.getStyle().getDisplay())) {
            return;
        }
        String lTagName = ele.getTagName().toLowerCase();
        if (lTagName.equals("a")) {
            IContainerContent container = content.getReportContent().createContainerContent();
            HTML2Content.addChild(content, container);
            HTML2Content.handleStyle(ele, cssStyles, container);
            ActionContent actionContent = HTML2Content.handleAnchor(ele, container, action);
            HTML2Content.processNodes(ele, cssStyles, content, actionContent);
        } else if (lTagName.equals("img")) {
            HTML2Content.outputImg(ele, cssStyles, content);
        } else if (lTagName.equals("object")) {
            HTML2Content.outputEmbedContent(ele, cssStyles, content);
        } else if (lTagName.equals("br")) {
            ILabelContent label = content.getReportContent().createLabelContent();
            HTML2Content.addChild(content, label);
            label.setText("\n");
            StyleDeclaration inlineStyle = new StyleDeclaration(content.getCSSEngine());
            inlineStyle.setProperty(54, CSSValueConstants.INLINE_VALUE);
            label.setInlineStyle(inlineStyle);
        } else if (lTagName.equals("ul") || lTagName.equals("ol")) {
            IReportContent report = content.getReportContent();
            ITableContent table = report.createTableContent();
            HTML2Content.addChild(content, table);
            Column column1 = new Column(report);
            column1.setWidth(new DimensionType(2.0, "em"));
            table.addColumn(column1);
            column1 = new Column(report);
            table.addColumn(column1);
            HTML2Content.handleStyle(ele, cssStyles, table);
            HTML2Content.processNodes(ele, cssStyles, table, action);
        } else if (lTagName.equals("li") && ele.getParentNode().getNodeType() == 1) {
            IReportContent report = content.getReportContent();
            IRowContent row = report.createRowContent();
            HTML2Content.addChild(content, row);
            HTML2Content.handleStyle(ele, cssStyles, row);
            StyleDeclaration style = new StyleDeclaration(content.getCSSEngine());
            style.setProperty(38, CSSValueConstants.TOP_VALUE);
            style.setProperty(9, IStyle.NUMBER_0);
            style.setProperty(7, IStyle.NUMBER_0);
            style.setProperty(12, IStyle.NUMBER_0);
            style.setProperty(10, IStyle.NUMBER_0);
            ICellContent orderCell = report.createCellContent();
            orderCell.setRowSpan(1);
            orderCell.setColumn(0);
            orderCell.setColSpan(1);
            orderCell.setInlineStyle(style);
            HTML2Content.addChild(row, orderCell);
            TextContent text = (TextContent)report.createTextContent();
            HTML2Content.addChild(orderCell, text);
            if (ele.getParentNode().getNodeName().equals("ol")) {
                text.setText(String.valueOf(new Integer(index).toString()) + ".");
            } else if (ele.getParentNode().getNodeName().equals("ul")) {
                text.setText(new String(new char[]{'\u2022'}));
            }
            ICellContent childCell = report.createCellContent();
            childCell.setRowSpan(1);
            childCell.setColumn(1);
            childCell.setColSpan(1);
            childCell.setInlineStyle(style);
            HTML2Content.addChild(row, childCell);
            HTML2Content.processNodes(ele, cssStyles, childCell, action);
        } else if (lTagName.equals("dd") || lTagName.equals("dt")) {
            IContainerContent container = content.getReportContent().createContainerContent();
            HTML2Content.addChild(content, container);
            HTML2Content.handleStyle(ele, cssStyles, container);
            if (lTagName.equals("dd")) {
                StyleDeclaration style = new StyleDeclaration(content.getCSSEngine());
                style.setProperty(54, CSSValueConstants.INLINE_VALUE);
                style.setProperty(38, CSSValueConstants.TOP_VALUE);
                TextContent text = (TextContent)content.getReportContent().createTextContent();
                HTML2Content.addChild(container, text);
                if (ele.getParentNode().getNodeName().equals("dl")) {
                    text.setText(" ");
                }
                style.setTextIndent("2em");
                text.setInlineStyle(style);
                IContainerContent childContainer = content.getReportContent().createContainerContent();
                childContainer.setInlineStyle(style);
                HTML2Content.addChild(container, childContainer);
                HTML2Content.processNodes(ele, cssStyles, container, action);
            } else {
                HTML2Content.processNodes(ele, cssStyles, container, action);
            }
        } else if ("table".equals(lTagName)) {
            TableProcessor.processTable(ele, cssStyles, content, action);
        } else if (htmlBlockDisplay.contains(lTagName) || htmlInlineDisplay.contains(lTagName)) {
            IContainerContent container = content.getReportContent().createContainerContent();
            HTML2Content.handleStyle(ele, cssStyles, container);
            HTML2Content.addChild(content, container);
            HTML2Content.processNodes(ele, cssStyles, container, action);
        } else {
            HTML2Content.processNodes(ele, cssStyles, content, action);
        }
    }

    private static boolean checkEscapeSpace(Node doc) {
        String textType = null;
        if (doc != null && doc.getFirstChild() != null && doc.getFirstChild() instanceof Element) {
            textType = ((Element)doc.getFirstChild()).getAttribute("text-type");
            return !TextParser.TEXT_TYPE_HTML.equalsIgnoreCase(textType);
        }
        return true;
    }

    protected static ActionContent handleAnchor(Element ele, IContent content, ActionContent defaultAction) {
        String href;
        ActionContent result = defaultAction;
        if (ele.getAttribute("id").trim().length() != 0) {
            content.setBookmark(ele.getAttribute("id"));
        } else {
            content.setBookmark(ele.getAttribute("name"));
        }
        if (ele.getAttribute("href").length() > 0 && (href = ele.getAttribute("href")) != null && !"".equals(href)) {
            ActionContent action = new ActionContent();
            if (href.startsWith("#")) {
                action.setBookmark(href.substring(1));
            } else {
                String target = ele.getAttribute("target");
                if ("".equals(target)) {
                    target = "_blank";
                }
                action.setHyperlink(href, target);
            }
            result = action;
        }
        return result;
    }

    static void handleStyle(Element ele, Map<Element, StyleProperties> cssStyles, IContent content) {
        String tagName;
        Tag2Style tag2Style;
        StyleProperties sp = cssStyles.get(ele);
        if (sp == null) {
            sp = new StyleProperties(new StyleDeclaration(content.getCSSEngine()));
            cssStyles.put(ele, sp);
        }
        if ((tag2Style = Tag2Style.getStyleProcess(tagName = ele.getTagName())) != null) {
            tag2Style.process(ele, sp);
        }
        content.setInlineStyle(sp.getStyle());
        sp.setProperties(content);
    }

    protected static void outputEmbedContent(Element ele, Map cssStyles, IContent content) {
        String classId = ele.getAttribute("classid");
        if ("clsid:D27CDB6E-AE6D-11cf-96B8-444553540000".equalsIgnoreCase(classId)) {
            HTML2Content.outputFlash(ele, cssStyles, content);
        }
    }

    protected static void outputFlash(Element ele, Map cssStyles, IContent content) {
        String src = null;
        String flashVars = null;
        NodeList list = ele.getElementsByTagName("param");
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node instanceof Element) {
                if ("movie".equalsIgnoreCase(((Element)node).getAttribute("name"))) {
                    src = ((Element)node).getAttribute("value");
                } else if ("flashvars".equalsIgnoreCase(((Element)node).getAttribute("name"))) {
                    flashVars = ((Element)node).getAttribute("value");
                }
            }
            ++i;
        }
        if (src != null) {
            String alt;
            ObjectContent flash = (ObjectContent)((ReportContent)content.getReportContent()).createObjectContent();
            flash.setExtension(".swf");
            flash.setMIMEType("application/x-shockwave-flash");
            HTML2Content.addChild(content, flash);
            HTML2Content.handleStyle(ele, cssStyles, flash);
            if (!FileUtil.isLocalResource(src)) {
                flash.setImageSource(3);
                flash.setURI(src);
            } else {
                ReportDesignHandle handle = content.getReportContent().getDesign().getReportDesign();
                URL url = handle.findResource(src, 1, content.getReportContent().getReportContext() == null ? null : content.getReportContent().getReportContext().getAppContext());
                if (url != null) {
                    src = url.toString();
                }
                flash.setImageSource(0);
                flash.setURI(src);
            }
            IForeignContent foreign = HTML2Content.getForeignRoot(content);
            if (foreign != null) {
                flash.setWidth(foreign.getWidth());
                flash.setHeight(foreign.getHeight());
            }
            if (flashVars != null && !"".equals(flashVars)) {
                flash.addParam("FlashVars", flashVars);
            }
            if ((alt = ele.getAttribute("alt")) != null && !"".equals(alt)) {
                flash.setAltText(alt);
            }
        }
    }

    private static IForeignContent getForeignRoot(IContent content) {
        while (!(content instanceof IForeignContent)) {
            if ((content = (IContent)content.getParent()) != null) continue;
            return null;
        }
        return (IForeignContent)content;
    }

    protected static void outputImg(Element ele, Map cssStyles, IContent content) {
        String src = ele.getAttribute("src");
        if (src != null) {
            IImageContent image = content.getReportContent().createImageContent();
            HTML2Content.addChild(content, image);
            HTML2Content.handleStyle(ele, cssStyles, image);
            if (!FileUtil.isLocalResource(src)) {
                image.setImageSource(3);
                image.setURI(src);
            } else {
                ReportDesignHandle handle = content.getReportContent().getDesign().getReportDesign();
                URL url = handle.findResource(src, 1, content.getReportContent().getReportContext() == null ? null : content.getReportContent().getReportContext().getAppContext());
                if (url != null) {
                    src = url.toString();
                }
                image.setImageSource(0);
                image.setURI(src);
            }
            if (ele.getAttribute("width") != null && !"".equals(ele.getAttribute("width"))) {
                image.setWidth(PropertyUtil.getDimensionAttribute(ele, "width"));
            }
            if (ele.getAttribute("height") != null && !"".equals(ele.getAttribute("height"))) {
                image.setHeight(PropertyUtil.getDimensionAttribute(ele, "height"));
            }
            if (ele.getAttribute("alt") != null && !"".equals(ele.getAttribute("alt"))) {
                image.setAltText(ele.getAttribute("alt"));
            }
        }
    }

    protected static void addChild(IContent parent, IContent child) {
        Collection children;
        if (parent != null && child != null && !(children = parent.getChildren()).contains(child)) {
            children.add(child);
            child.setParent(parent);
        }
    }

    protected static void formalizeInlineContainer(List parentChildren, IContent parent, IContent content) {
        IStyle style = content.getStyle();
        CSSValue display = style.getProperty(54);
        if (CSSValueConstants.INLINE_VALUE.equals(display)) {
            Iterator iter = content.getChildren().iterator();
            ArrayList<IContent> contentChildren = new ArrayList<IContent>();
            IElement clonedBlock = null;
            while (iter.hasNext()) {
                boolean isContainer;
                IContent child = (IContent)iter.next();
                boolean bl = isContainer = child.getChildren().size() > 0;
                if (isContainer) {
                    HTML2Content.formalizeInlineContainer(contentChildren, content, child);
                }
                if (clonedBlock == null) {
                    CSSValue childDisplay = child.getStyle().getProperty(54);
                    if (CSSValueConstants.BLOCK_VALUE.equals(childDisplay)) {
                        IReportContent report = content.getReportContent();
                        clonedBlock = report.createContainerContent();
                        IStyle clonedStyle = report.createStyle();
                        clonedStyle.setProperties(content.getStyle());
                        clonedStyle.setProperty(54, CSSValueConstants.BLOCK_VALUE);
                        clonedBlock.setInlineStyle(clonedStyle);
                        clonedBlock.getChildren().add(child);
                        continue;
                    }
                    if (isContainer) continue;
                    contentChildren.add(child);
                    continue;
                }
                iter.remove();
                clonedBlock.getChildren().add(child);
            }
            content.getChildren().clear();
            if (contentChildren.size() > 0) {
                content.getChildren().addAll(contentChildren);
            }
            if (content.getChildren().size() > 0) {
                parentChildren.add(content);
            }
            if (clonedBlock != null) {
                parentChildren.add(clonedBlock);
            }
        } else {
            Iterator iter = content.getChildren().iterator();
            ArrayList<IContent> newChildren = new ArrayList<IContent>();
            while (iter.hasNext()) {
                boolean isContainer;
                IContent child = (IContent)iter.next();
                boolean bl = isContainer = child.getChildren().size() > 0;
                if (isContainer) {
                    HTML2Content.formalizeInlineContainer(newChildren, content, child);
                    continue;
                }
                newChildren.add(child);
            }
            content.getChildren().clear();
            if (newChildren.size() > 0) {
                content.getChildren().addAll(newChildren);
                parentChildren.add(content);
            }
        }
    }

    public static void main(String[] args) {
        ReportContent report = new ReportContent();
        IContent root = HTML2Content.createBlockContent(report);
        IContent inline = HTML2Content.createInlineContent(report);
        root.getChildren().add(inline);
        IContent inlineContent = HTML2Content.createInlineContent(report);
        inline.getChildren().add(inlineContent);
        inline.getChildren().add(HTML2Content.createBlockContent(report));
        ArrayList list = new ArrayList();
        HTML2Content.formalizeInlineContainer(list, root, inline);
        root.getChildren().clear();
        if (list.size() > 0) {
            root.getChildren().addAll(list);
        }
    }

    protected static IContent createInlineContent(ReportContent report) {
        IContainerContent content = report.createContainerContent();
        content.getStyle().setProperty(54, CSSValueConstants.INLINE_VALUE);
        return content;
    }

    protected static IContent createBlockContent(ReportContent report) {
        IContainerContent content = report.createContainerContent();
        content.getStyle().setProperty(54, CSSValueConstants.BLOCK_VALUE);
        return content;
    }
}

