/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.actions;

import com.swtdesigner.SWTResourceManager;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerComposite;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerEditPart;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class ZoomInFontAction
extends Action {
    public static final String ID = "fr.inra.adonis.editeurgraphique.actions.ZoomInFontAction";
    private GraphicalViewer viewer;
    private AdonisRulerComposite rulerComposite;

    public ZoomInFontAction(GraphicalViewer viewer, AdonisRulerComposite adonisRulerComposite) {
        this.viewer = viewer;
        this.rulerComposite = adonisRulerComposite;
        this.setText("Zoom Font In");
        this.setId(ID);
        this.setEnabled(true);
    }

    public void run() {
        FontData[] fds;
        GraphicalProperties properties = (GraphicalProperties)this.viewer.getProperty("graphicalProperties");
        int ancienFacteur = properties.getFacteurFont();
        int nouveauFacteur = ancienFacteur + 1;
        AdonisRulerEditPart topRulePart = (AdonisRulerEditPart)this.rulerComposite.getTop().getContents().getRoot().getContents();
        Font ruleFont = topRulePart.getFigure().getFont();
        FontData[] fontDataArray = fds = ruleFont.getFontData();
        int n = fds.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            int h = Math.max(2, fd.getHeight() + nouveauFacteur - ancienFacteur);
            h = Math.min(18, h);
            Font nouvelleFont = SWTResourceManager.getFont((String)fd.getName(), (int)h, (int)fd.getStyle());
            topRulePart.getFigure().setFont(nouvelleFont);
            ++n2;
        }
        AdonisRulerEditPart leftRulePart = (AdonisRulerEditPart)this.rulerComposite.getLeft().getContents().getRoot().getContents();
        ruleFont = leftRulePart.getFigure().getFont();
        FontData[] fontDataArray2 = fds = ruleFont.getFontData();
        int n3 = fds.length;
        n = 0;
        while (n < n3) {
            FontData fd = fontDataArray2[n];
            int h = Math.max(2, fd.getHeight() + nouveauFacteur - ancienFacteur);
            h = Math.min(18, h);
            Font nouvelleFont = SWTResourceManager.getFont((String)fd.getName(), (int)h, (int)fd.getStyle());
            leftRulePart.getFigure().setFont(nouvelleFont);
            ++n;
        }
        properties.setFacteurFont(nouveauFacteur);
        this.viewer.getContents().refresh();
    }
}

