/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.commands;

import fr.inra.adonis.core.controle.Coordonnees;
import fr.inra.adonis.core.idgenerator.IdGeneratorService;
import fr.inra.adonis.core.parcours.Parcours;
import fr.inra.adonis.core.parcours.ParcoursUtil;
import fr.inra.adonis.core.propertyUtils.PropertyTesterUtils;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.core.util.UtilisateurCourant;
import fr.inra.adonis.droitsacces.util.DroitsAccesUtil;
import fr.inra.adonis.editeurgraphique.commands.AbstractCommand;
import fr.inra.adonis.editeurgraphique.wizard.traitement.SelectTraitementWizard;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.AbstractBloc;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.EtatDispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.NatureZhe;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.PlateformeFactory;
import fr.inra.adonis.modeleMetier.plateforme.PuIndividuel;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.UniteDeParcours;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import fr.inra.adonis.modeleMetier.protocole.Traitement;
import fr.inra.adonis.modeleMetier.utilisateur.TypeAction;
import fr.inra.adonis.modeleMetier.utilisateur.Utilisateur;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractCreateCommand
extends AbstractCommand {
    private List<Point> listPointToAdd;
    private ObjetMetier parent;
    private GraphicalViewer graphicalViewer;

    public AbstractCreateCommand(GraphicalViewer graphicalViewer, List<Point> pointsToAdd, EditPart part) {
        super(part.getModel(), graphicalViewer.getControl().getShell());
        this.setGraphicalViewer(graphicalViewer);
        this.setListPointToAdd(pointsToAdd);
    }

    public boolean canExecute() {
        Dispositif disp;
        if (this.getParent() != null && this.getParent() instanceof ObjetMetier && ((disp = DispositifUtil.getDispositifFrom((EObject)this.getParent())) == null || disp.getEtat() != EtatDispositif.CREE && disp.getEtat() != EtatDispositif.CONTROLE_AVALIDER && disp.getEtat() != EtatDispositif.SAISIE_COORDONNEE_AVALIDER || !DroitsAccesUtil.isDroitsAccesDispositif((Utilisateur)UtilisateurCourant.getInstance(), (Dispositif)disp, (TypeAction)TypeAction.EDITER))) {
            return false;
        }
        return this.getGraphicalViewer() != null && this.getParent() != null && this.getListPointToAdd() != null && !this.getListPointToAdd().isEmpty() && this.isFreeSpaceToAddPoints();
    }

    protected boolean isFreeSpaceToAddPoints() {
        ObjetMetier root = AbstractCreateCommand.getRoot(this.getParent());
        for (Point p : this.getListPointToAdd()) {
            if (ParcoursUtil.getChild((ObjetMetier)root, (int)p.x, (int)p.y) == null) continue;
            return false;
        }
        return true;
    }

    private static ObjetMetier getRoot(ObjetMetier obj) {
        if (obj instanceof Plateforme) {
            return obj;
        }
        Dispositif root = DispositifUtil.getDispositifFrom((EObject)obj);
        if (root.getPlateforme() != null) {
            return root.getPlateforme();
        }
        return root;
    }

    protected static Dispositif getCurrentDispo(ObjetMetier objG) {
        Dispositif dispo = DispositifUtil.getDispositifFrom((EObject)objG);
        return dispo;
    }

    public static Set<Coordonnees> getListCoordVoisins(ObjetMetier obj) {
        final HashMap map = new HashMap();
        final HashSet<Coordonnees> listCoord = new HashSet<Coordonnees>();
        Parcours parcours = new Parcours(){

            public void parcoursFeuille(ObjetMetier feuille) {
                int xInd = feuille.getX();
                int yInd = feuille.getY();
                String key = String.valueOf(xInd - 1) + "," + yInd;
                if (!map.containsKey(key)) {
                    map.put(key, new Coordonnees(xInd - 1, yInd));
                }
                listCoord.add((Coordonnees)map.get(key));
                key = String.valueOf(xInd + 1) + "," + yInd;
                if (!map.containsKey(key)) {
                    map.put(key, new Coordonnees(xInd + 1, yInd));
                }
                listCoord.add((Coordonnees)map.get(key));
                key = String.valueOf(xInd) + "," + (yInd - 1);
                if (!map.containsKey(key)) {
                    map.put(key, new Coordonnees(xInd, yInd - 1));
                }
                listCoord.add((Coordonnees)map.get(key));
                key = String.valueOf(xInd) + "," + (yInd + 1);
                if (!map.containsKey(key)) {
                    map.put(key, new Coordonnees(xInd, yInd + 1));
                }
                listCoord.add((Coordonnees)map.get(key));
                key = String.valueOf(xInd) + "," + yInd;
                if (map.containsKey(key)) {
                    listCoord.remove(map.get(key));
                }
            }

            public void parcoursIndividu(Individu ind) {
                this.parcoursFeuille((ObjetMetier)ind);
            }

            public void parcoursZhe(ZheAvecEpaisseur zhe) {
                this.parcoursFeuille((ObjetMetier)zhe);
            }

            public void parcoursPuSurfacique(PuSurfacique pu) {
                this.parcoursFeuille((ObjetMetier)pu);
            }
        };
        parcours.setAscendant(false);
        parcours.parcours(obj);
        return listCoord;
    }

    public static void createIndividus(List<Point> pointsToAdd, PuIndividuel pu, Dispositif root) {
        int nextIdInd = IdGeneratorService.getNextIdForIndividu((Dispositif)root);
        ArrayList<Individu> indToAdd = new ArrayList<Individu>();
        for (Point p : pointsToAdd) {
            Individu ind = PlateformeFactory.eINSTANCE.createIndividu();
            ind.setX(p.x);
            ind.setY(p.y);
            indToAdd.add(ind);
            ind.setNumero(nextIdInd);
            ++nextIdInd;
        }
        pu.getIndividus().addAll(indToAdd);
    }

    public static void createParcelleUnitaire(List<Point> pointsToAdd, AbstractBloc abstractBloc, Dispositif root) {
        boolean isPuSurfacique = DispositifUtil.estDansDispositifPuSurfacique((ObjetMetier)root);
        if (!isPuSurfacique) {
            PuIndividuel newPu = PlateformeFactory.eINSTANCE.createPuIndividuel();
            Traitement trait = AbstractCreateCommand.getTraitementFromWizard(root);
            if (trait == null) {
                return;
            }
            newPu.setTraitement(trait);
            int n = IdGeneratorService.getNextIdForPU((Dispositif)root);
            newPu.setNumero(n);
            AbstractCreateCommand.createIndividus(pointsToAdd, newPu, root);
            abstractBloc.getParcellesUnitaire().add((Object)newPu);
        } else {
            ArrayList<PuSurfacique> pus = new ArrayList<PuSurfacique>();
            int nextId = IdGeneratorService.getNextIdForPU((Dispositif)root);
            for (Point p : pointsToAdd) {
                PuSurfacique pu = PlateformeFactory.eINSTANCE.createPuSurfacique();
                Traitement trait = AbstractCreateCommand.getTraitementFromWizard(root);
                if (trait == null) {
                    return;
                }
                pu.setTraitement(trait);
                pu.setX(p.x);
                pu.setY(p.y);
                pu.setNumero(nextId);
                pus.add(pu);
                ++nextId;
            }
            abstractBloc.getParcellesUnitaire().addAll(pus);
        }
    }

    public static void createSousBloc(List<Point> pointsToAdd, Bloc bloc, Dispositif root) {
        SousBloc sousBloc = PlateformeFactory.eINSTANCE.createSousBloc();
        int id = IdGeneratorService.getNextIdForSousBloc((Dispositif)root);
        sousBloc.setNumero(id);
        AbstractCreateCommand.createParcelleUnitaire(pointsToAdd, (AbstractBloc)sousBloc, root);
        bloc.getSousBlocs().add((Object)sousBloc);
    }

    public static void createBloc(List<Point> pointsToAdd, Dispositif dispo, boolean wantSousBloc) {
        Bloc bloc = PlateformeFactory.eINSTANCE.createBloc();
        int id = IdGeneratorService.getNextIdForBloc((Dispositif)dispo);
        bloc.setNumero(id);
        if (wantSousBloc) {
            AbstractCreateCommand.createSousBloc(pointsToAdd, bloc, dispo);
        } else {
            AbstractCreateCommand.createParcelleUnitaire(pointsToAdd, (AbstractBloc)bloc, dispo);
        }
        dispo.getBlocs().add((Object)bloc);
    }

    public static void createZhe(List<Point> pointsToAdd, UniteDeParcours unite, NatureZhe nature) {
        int nextId = IdGeneratorService.getNextIdForZheAvecEpaisseur((ObjetMetier)AbstractCreateCommand.getRoot((ObjetMetier)unite));
        ArrayList<ZheAvecEpaisseur> zheToAdd = new ArrayList<ZheAvecEpaisseur>();
        for (Point p : pointsToAdd) {
            ZheAvecEpaisseur zhe = PlateformeFactory.eINSTANCE.createZheAvecEpaisseur();
            zhe.setX(p.x);
            zhe.setY(p.y);
            zheToAdd.add(zhe);
            zhe.setNumero(nextId);
            zhe.setNatureZhe(nature);
            ++nextId;
        }
        unite.getZheAvecEpaisseurs().addAll(zheToAdd);
    }

    protected static Traitement getTraitementFromWizard(Dispositif dispo) {
        HashSet<Traitement> traitements = new HashSet<Traitement>((Collection<Traitement>)dispo.getProtocoles().getTraitements());
        SelectTraitementWizard traitWizard = new SelectTraitementWizard(traitements);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)traitWizard);
        if (dialog.open() == 0) {
            return traitWizard.getTraitement();
        }
        return null;
    }

    protected void refreshPropertyTester() {
        PropertyTesterUtils.refreshAdonisProperties();
    }

    public void setListPointToAdd(List<Point> listPointToAdd) {
        this.listPointToAdd = listPointToAdd;
    }

    public List<Point> getListPointToAdd() {
        return this.listPointToAdd;
    }

    public void setParent(ObjetMetier objSelected) {
        this.parent = objSelected;
    }

    public ObjetMetier getParent() {
        return this.parent;
    }

    public void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }
}

