/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.commands;

import fr.inra.adonis.core.controle.Coordonnees;
import fr.inra.adonis.core.parcours.Parcours;
import fr.inra.adonis.editeurgraphique.commands.AbstractCreateCommand;
import fr.inra.adonis.editeurgraphique.tools.ObjectSelectionUtil;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;

public class SousBlocCreateCommand
extends AbstractCreateCommand {
    public SousBlocCreateCommand(GraphicalViewer gv, List<Point> pointsToAdd, EditPart part) {
        super(gv, pointsToAdd, part);
        this.setParent(ObjectSelectionUtil.selectParent(gv, SousBloc.class));
    }

    @Override
    public boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        if (!(this.getParent() instanceof Bloc)) {
            return false;
        }
        Bloc metier = (Bloc)this.getParent();
        Set<Coordonnees> coords = SousBlocCreateCommand.getListCoordVoisins((ObjetMetier)metier);
        for (Coordonnees coord : coords) {
            for (Point p : this.getListPointToAdd()) {
                if (coord.getX() != p.x || coord.getY() != p.y) continue;
                return true;
            }
        }
        final ArrayList contenu = new ArrayList();
        Parcours parcours = new Parcours(){

            public void parcoursIndividu(Individu ind) {
                contenu.add(ind);
            }

            public void parcoursZhe(ZheAvecEpaisseur zhe) {
                contenu.add(zhe);
            }
        };
        parcours.setAscendant(false);
        parcours.parcours(this.getParent());
        return contenu.isEmpty();
    }

    @Override
    public void executeCommand() {
        Dispositif root = SousBlocCreateCommand.getCurrentDispo(this.getParent());
        SousBlocCreateCommand.createSousBloc(this.getListPointToAdd(), (Bloc)this.getParent(), root);
        this.refreshPropertyTester();
    }
}

