/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.composite;

import com.swtdesigner.SWTResourceManager;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.GraphicalConfigurator;
import fr.inra.adonis.editeurgraphique.cheminement.factory.CheminementGraphFactory;
import fr.inra.adonis.editeurgraphique.part.AdonisRootEditPart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;
import fr.inra.adonis.editeurgraphique.rulers.custom.AdonisRulerComposite;
import fr.inra.adonis.editeurgraphique.tools.ZoomUtil;
import fr.inra.adonis.editeurgraphique.tools.palette.AdonisPaletteSelectionTool;
import fr.inra.adonis.icons.IconsRegistry;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;

public class GraphicalComposite
extends Composite {
    private AdonisRulerComposite rulerComp;
    protected GraphicalViewer viewer;
    private DefaultEditDomain editDomain;
    private PaletteViewer paletteViewer;
    private EditorModeEnum editorMode;
    private PaletteRoot paletteRoot;
    private ObjetMetier rootObjetMetier;
    private Collection<ObjetMetier> objectsToDisplay;
    private Collection<ObjetMetier> disposToDisplay;
    private List<TypeUniteParcours> layersToDisplay;
    private final Color backgroundColor = Display.getCurrent().getSystemColor(1);
    private final Font defaultFont = SWTResourceManager.getFont((String)"Segoe UI", (int)14, (int)0);
    private final Font toolBarFont = SWTResourceManager.getFont((String)"Tahoma", (int)10, (int)1);
    private Label lblTitle;
    private ToolItem tltmAnnuler;
    protected ToolBar toolBar;
    private ActionRegistry actionRegistry;

    public GraphicalComposite(Composite parent, String title) {
        super(parent, 0);
        this.setBackground(this.backgroundColor);
        GridLayout gridLayout = new GridLayout(1, false);
        this.setLayout((Layout)gridLayout);
        if (title != null && !title.isEmpty()) {
            this.lblTitle = new Label((Composite)this, 0);
            this.lblTitle.setBackground(this.backgroundColor);
            this.lblTitle.setFont(this.defaultFont);
            GridData gdLblTitle = new GridData(4, 0x1000000, true, false, 1, 1);
            gdLblTitle.heightHint = 30;
            this.lblTitle.setLayoutData((Object)gdLblTitle);
            this.lblTitle.setText(title);
            Label lblSep = new Label((Composite)this, 258);
            lblSep.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
    }

    public AdonisRulerComposite getRulerComp() {
        return this.rulerComp;
    }

    public void changeTitre(String nouveauTitre) {
        if (this.lblTitle != null) {
            this.lblTitle.setText(nouveauTitre);
        }
    }

    public void createToolBar() {
        this.toolBar = new ToolBar((Composite)this, 0x820008);
        this.toolBar.setFont(this.toolBarFont);
        this.toolBar.setBackground(this.backgroundColor);
        if (this.editorMode == EditorModeEnum.CREATION_CHEMINEMENT) {
            ToolItem tltmUndo = new ToolItem(this.toolBar, 0);
            tltmUndo.setText("Undo");
            tltmUndo.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_UNDO"));
            tltmUndo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (GraphicalComposite.this.editDomain != null && GraphicalComposite.this.editDomain.getCommandStack().canUndo()) {
                        GraphicalComposite.this.editDomain.getCommandStack().undo();
                    }
                }
            });
            ToolItem tltmRedo = new ToolItem(this.toolBar, 0);
            tltmRedo.setText("Redo");
            tltmRedo.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_REDO"));
            tltmRedo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (GraphicalComposite.this.editDomain != null && GraphicalComposite.this.editDomain.getCommandStack().canRedo()) {
                        GraphicalComposite.this.editDomain.getCommandStack().redo();
                    }
                }
            });
            ToolItem tltmValider = new ToolItem(this.toolBar, 0);
            tltmValider.setText("Valider");
            tltmValider.setImage(IconsRegistry.IMG_CONFIRM);
            tltmValider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CheminementGraphFactory.getInstance().getObjetsOrdonnes();
                    if (CheminementGraphFactory.getInstance().isCloseEditor()) {
                        CheminementGraphFactory.getInstance().setCancel(false);
                        GraphicalComposite.this.getShell().close();
                    }
                }
            });
            ToolItem tltmAnnuler = new ToolItem(this.toolBar, 0);
            tltmAnnuler.setText("Annuler");
            tltmAnnuler.setImage(IconsRegistry.IMG_CANCEL);
            tltmAnnuler.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (MessageDialog.openQuestion((Shell)GraphicalComposite.this.getShell(), (String)"Cr\u00e9ation cheminement", (String)"Etes-vous s\u00fbr de vouloir annuler la cr\u00e9ation graphique?")) {
                        CheminementGraphFactory.getInstance().setCancel(true);
                        GraphicalComposite.this.getShell().close();
                    }
                }
            });
            this.ajouterActionZoom(this.toolBar);
        }
        if (this.editorMode == EditorModeEnum.EDITION_PLATEFORME) {
            ToolItem tltmValider = new ToolItem(this.toolBar, 0);
            tltmValider.setText("Valider");
            tltmValider.setImage(IconsRegistry.IMG_CONFIRM);
            tltmValider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GraphicalComposite.this.getShell().close();
                }
            });
            this.tltmAnnuler = new ToolItem(this.toolBar, 0);
            this.tltmAnnuler.setText("Annuler");
            this.tltmAnnuler.setImage(IconsRegistry.IMG_CANCEL);
            this.tltmAnnuler.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    GraphicalComposite.this.getShell().close();
                }
            });
            this.ajouterActionZoom(this.toolBar);
        }
        if (this.editorMode == EditorModeEnum.VISUALISATION_TERRAIN) {
            ToolItem tltmZoomOut = new ToolItem(this.toolBar, 0);
            new ZoomOutRetargetAction();
            tltmZoomOut.setImage(IconsRegistry.IMG_ZOOM_OUT);
            tltmZoomOut.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((AdonisRootEditPart)GraphicalComposite.this.viewer.getRootEditPart()).getZoomManager().zoomOut();
                }
            });
            ToolItem tltmZoomIn = new ToolItem(this.toolBar, 0);
            new ZoomInRetargetAction();
            tltmZoomIn.setImage(IconsRegistry.IMG_ZOOM_IN);
            tltmZoomIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((AdonisRootEditPart)GraphicalComposite.this.viewer.getRootEditPart()).getZoomManager().zoomIn();
                }
            });
        }
    }

    private void ajouterActionZoom(ToolBar toolBar) {
        ToolItem tltmFit = new ToolItem(toolBar, 0);
        tltmFit.setText("Ajuster \u00e0 la fen\u00eatre");
        tltmFit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String zoomString = ZoomManager.FIT_ALL;
                ((AdonisRootEditPart)GraphicalComposite.this.viewer.getRootEditPart()).getZoomManager().setZoomAsText(zoomString);
            }
        });
        ToolItem tltmZoomOut = new ToolItem(toolBar, 0);
        ZoomOutRetargetAction zoomOut = new ZoomOutRetargetAction();
        tltmZoomOut.setImage(zoomOut.getImageDescriptor().createImage());
        final double[] zoomLevels = new double[]{0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0};
        tltmZoomOut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((AdonisRootEditPart)GraphicalComposite.this.viewer.getRootEditPart()).getZoomManager().setZoomLevels(zoomLevels);
                ((AdonisRootEditPart)GraphicalComposite.this.viewer.getRootEditPart()).getZoomManager().zoomOut();
            }
        });
        ToolItem tltmZoomIn = new ToolItem(toolBar, 0);
        ZoomInRetargetAction zoomIn = new ZoomInRetargetAction();
        tltmZoomIn.setImage(zoomIn.getImageDescriptor().createImage());
        tltmZoomIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((AdonisRootEditPart)GraphicalComposite.this.viewer.getRootEditPart()).getZoomManager().setZoomLevels(zoomLevels);
                ((AdonisRootEditPart)GraphicalComposite.this.viewer.getRootEditPart()).getZoomManager().zoomIn();
            }
        });
    }

    public void createRulerGraphicalViewerWithPalette() {
        this.initEditDomain();
        SashForm sashForm = new SashForm((Composite)this, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createPaletteViewer((Composite)sashForm);
        this.createRulerGraphicalViewerDefault((Composite)sashForm);
        sashForm.setWeights(new int[]{1, 5});
    }

    private void initEditDomain() {
        this.editDomain = new DefaultEditDomain(null);
        this.editDomain.setPaletteRoot(this.paletteRoot);
        this.editDomain.setDefaultTool((Tool)new AdonisPaletteSelectionTool());
        this.editDomain.loadDefaultTool();
    }

    private void createPaletteViewer(Composite parent) {
        PaletteEntry p;
        this.paletteViewer = new PaletteViewer();
        this.paletteViewer.createControl(parent);
        this.editDomain.setPaletteViewer(this.paletteViewer);
        int nb = this.paletteRoot.getChildren().size();
        if (nb > 0 && (p = (PaletteEntry)this.paletteRoot.getChildren().get(nb - 1)) instanceof PaletteContainer) {
            PaletteContainer pContainer = (PaletteContainer)p;
            int i = 0;
            while (i < pContainer.getChildren().size()) {
                PaletteEntry entry = (PaletteEntry)pContainer.getChildren().get(i);
                if ("Outil cheminement".equals(entry.getLabel())) {
                    if (!(entry instanceof ToolEntry)) break;
                    this.editDomain.getPaletteViewer().setActiveTool((ToolEntry)entry);
                    break;
                }
                ++i;
            }
        }
    }

    private void createRulerGraphicalViewerDefault(Composite parent) {
        this.rulerComp = new AdonisRulerComposite(parent, 0);
        this.rulerComp.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.createGraphicalViewer(this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.viewer);
    }

    public void createRulerGraphicalViewer() {
        this.initEditDomain();
        this.createRulerGraphicalViewerDefault(this);
    }

    private void createGraphicalViewer(Composite parent) {
        this.viewer = new ScrollingGraphicalViewer();
        this.viewer.createControl(parent);
        this.editDomain.addViewer((EditPartViewer)this.viewer);
        GraphicalConfigurator.configureGraphicalViewer(this.viewer, this.editorMode, this.rootObjetMetier);
        ZoomUtil.configureZoom(this.getActionRegistry(), this.viewer);
        this.viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)0), (Object)MouseWheelZoomHandler.SINGLETON);
        this.initializeGraphicalViewer();
    }

    public void initializeGraphicalViewer() {
        this.viewer.setProperty("indsToDisplay", this.objectsToDisplay);
        this.viewer.setProperty("layersToDisplay", this.layersToDisplay);
        if (this.editorMode == EditorModeEnum.CREATION_CHEMINEMENT) {
            this.viewer.setProperty("disposToDisplay", this.disposToDisplay);
        }
        this.viewer.setContents((Object)this.rootObjetMetier);
        GraphicalViewerKeyHandler keyHandler = new GraphicalViewerKeyHandler(this.viewer);
        keyHandler.put(KeyStroke.getPressed((char)'+', (int)16777259, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_in"));
        keyHandler.put(KeyStroke.getPressed((char)'-', (int)16777261, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.zoom_out"));
        if (this.editorMode != EditorModeEnum.VISUALISATION_TERRAIN) {
            keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), (IAction)new DeleteAction(null){

                protected CommandStack getCommandStack() {
                    return GraphicalComposite.this.editDomain.getCommandStack();
                }

                protected List getSelectedObjects() {
                    return GraphicalComposite.this.viewer.getSelectedEditParts();
                }

                public boolean isEnabled() {
                    return true;
                }
            });
        }
        this.viewer.setKeyHandler((KeyHandler)keyHandler);
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void setEditorMode(EditorModeEnum mode) {
        this.editorMode = mode;
    }

    public void setPaletteRoot(PaletteRoot paletteRoot) {
        this.paletteRoot = paletteRoot;
    }

    public ObjetMetier getRootObjetMetier() {
        return this.rootObjetMetier;
    }

    public void setRootObjetMetier(ObjetMetier rootObjetMetier) {
        this.rootObjetMetier = rootObjetMetier;
    }

    public Collection<ObjetMetier> getObjectsToDisplay() {
        return this.objectsToDisplay;
    }

    public void setObjectsToDisplay(Collection<ObjetMetier> objectsToDisplay) {
        this.objectsToDisplay = objectsToDisplay;
    }

    public void setDisposToDisplay(Collection<ObjetMetier> disposToDisplay) {
        this.disposToDisplay = disposToDisplay;
    }

    public ObjetMetierPart getRootObjetMetierPart() {
        return (ObjetMetierPart)this.viewer.getContents();
    }

    public void setLayersToDisplay(TypeUniteParcours level) {
        this.layersToDisplay = new ArrayList<TypeUniteParcours>();
        this.layersToDisplay.add(TypeUniteParcours.PLATEFORME);
        if (level == TypeUniteParcours.DISPOSITIF) {
            this.layersToDisplay.add(TypeUniteParcours.DISPOSITIF);
        } else if (level == TypeUniteParcours.BLOC) {
            this.layersToDisplay.add(TypeUniteParcours.DISPOSITIF);
            this.layersToDisplay.add(TypeUniteParcours.BLOC);
        } else if (level == TypeUniteParcours.SOUS_BLOC) {
            this.layersToDisplay.add(TypeUniteParcours.DISPOSITIF);
            this.layersToDisplay.add(TypeUniteParcours.BLOC);
            this.layersToDisplay.add(TypeUniteParcours.SOUS_BLOC);
        } else if (level == TypeUniteParcours.PARCELLE) {
            this.layersToDisplay.add(TypeUniteParcours.DISPOSITIF);
            this.layersToDisplay.add(TypeUniteParcours.BLOC);
            this.layersToDisplay.add(TypeUniteParcours.SOUS_BLOC);
            this.layersToDisplay.add(TypeUniteParcours.PARCELLE);
        } else if (level == TypeUniteParcours.INDIVIDU) {
            this.layersToDisplay.add(TypeUniteParcours.DISPOSITIF);
            this.layersToDisplay.add(TypeUniteParcours.BLOC);
            this.layersToDisplay.add(TypeUniteParcours.SOUS_BLOC);
            this.layersToDisplay.add(TypeUniteParcours.PARCELLE);
            this.layersToDisplay.add(TypeUniteParcours.INDIVIDU);
        }
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.viewer;
    }

    public void setCancelListener(SelectionListener listener) {
        this.tltmAnnuler.addSelectionListener(listener);
    }
}

