/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.model;

import fr.inra.adonis.editeurgraphique.part.ObjetMetierPart;

public class Connection {
    public static final int CONNECTION_DEFAULT = 1;
    private int lineStyle;
    private int connectionType;
    private ObjetMetierPart sourceObjGraphique;
    private ObjetMetierPart targetObjGraphique;

    public Connection(ObjetMetierPart sourceNode, ObjetMetierPart targetNode, int connectionType) {
        this.sourceObjGraphique = sourceNode;
        this.targetObjGraphique = targetNode;
        this.connectionType = connectionType;
    }

    public void connect() {
        if (this.sourceObjGraphique != null && this.targetObjGraphique != null) {
            this.sourceObjGraphique.addConnection(this);
            this.targetObjGraphique.addConnection(this);
        }
    }

    public void disconnect() {
        if (this.sourceObjGraphique != null && this.targetObjGraphique != null) {
            this.sourceObjGraphique.removeConnection(this);
            this.targetObjGraphique.removeConnection(this);
        }
    }

    public void reconnect(ObjetMetierPart sourceNode, ObjetMetierPart targetNode) {
        if (sourceNode != null && targetNode != null && sourceNode != targetNode) {
            this.disconnect();
            this.sourceObjGraphique = sourceNode;
            this.targetObjGraphique = targetNode;
            this.connect();
        }
    }

    public ObjetMetierPart getSource() {
        return this.sourceObjGraphique;
    }

    public ObjetMetierPart getTarget() {
        return this.targetObjGraphique;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
    }
}

