/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.part;

import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.graphique.Origine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.GuideLayer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.SimpleRootEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.tools.MarqueeDragTracker;

public class AdonisRootEditPart
extends SimpleRootEditPart
implements LayerConstants,
LayerManager {
    private LayeredPane innerLayers;
    private LayeredPane printableLayers;
    private ScalableFreeformLayeredPane scaledLayers;
    private final ZoomManager zoomManager;
    private final PropertyChangeListener gridListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("SnapToGrid.GridOrigin") || property.equals("SnapToGrid.GridSpacing") || property.equals("SnapToGrid.isVisible")) {
                AdonisRootEditPart.this.refreshGridLayer();
            }
        }
    };

    public AdonisRootEditPart() {
        this.zoomManager = new ZoomManager((ScalableFigure)this.getScaledLayers(), (Viewport)this.getFigure());
    }

    protected GridLayer createGridLayer() {
        return new GridLayer();
    }

    protected LayeredPane createPrintableLayers() {
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Primary Layer");
        layeredPane.add((IFigure)new ConnectionLayer(), (Object)"Connection Layer");
        return layeredPane;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == AutoexposeHelper.class) {
            return new ViewportAutoexposeHelper((GraphicalEditPart)this);
        }
        return super.getAdapter(adapter);
    }

    public IFigure getContentPane() {
        return this.getLayer("Primary Layer");
    }

    public DragTracker getDragTracker(Request req) {
        return new MarqueeDragTracker();
    }

    public Object getModel() {
        return LayerManager.ID;
    }

    public LayeredPane getPrintableLayers() {
        if (this.printableLayers == null) {
            this.printableLayers = this.createPrintableLayers();
        }
        return this.printableLayers;
    }

    public GridLayer getGridLayer() {
        return (GridLayer)this.getLayer("Grid Layer");
    }

    protected void refreshGridLayer() {
        boolean visible = false;
        GridLayer grid = (GridLayer)this.getLayer("Grid Layer");
        Boolean val = (Boolean)this.getViewer().getProperty("SnapToGrid.isVisible");
        if (val != null) {
            visible = val;
        }
        grid.setOrigin((Point)this.getViewer().getProperty("SnapToGrid.GridOrigin"));
        grid.setSpacing((Dimension)this.getViewer().getProperty("SnapToGrid.GridSpacing"));
        grid.setVisible(visible);
    }

    protected void register() {
        super.register();
        if (this.getLayer("Grid Layer") != null) {
            this.getViewer().addPropertyChangeListener(this.gridListener);
            this.refreshGridLayer();
        }
        this.getViewer().setProperty(ZoomManager.class.toString(), (Object)this.getZoomManager());
    }

    protected void unregister() {
        this.getViewer().setProperty(ZoomManager.class.toString(), null);
        this.getViewer().removePropertyChangeListener(this.gridListener);
        super.unregister();
    }

    protected IFigure createFigure() {
        FreeformViewport viewport = new FreeformViewport(){

            protected void readjustScrollBars() {
                if (this.getContents() == null) {
                    return;
                }
                if (!(this.getContents() instanceof FreeformFigure)) {
                    return;
                }
                FreeformFigure ff = (FreeformFigure)this.getContents();
                Rectangle clientArea = this.getClientArea();
                Rectangle bounds = ff.getFreeformExtent().getCopy();
                GraphicalProperties props = (GraphicalProperties)AdonisRootEditPart.this.getViewer().getProperty("graphicalProperties");
                if (props != null) {
                    Point p = new Point(props.getLargeurMaille(), props.getHauteurMaille());
                    p.scale(1.0 / AdonisRootEditPart.this.getZoomManager().getZoom());
                    Point origine = new Point();
                    origine.x = p.x * props.getCoeffX();
                    origine.y = p.y * props.getCoeffY();
                    bounds.union(origine.x, origine.y);
                    Insets insets = new Insets();
                    switch (props.getOrigine()) {
                        case BAS_DROITE: {
                            insets.top = p.y * 2;
                            insets.left = p.x * 2;
                            break;
                        }
                        case BAS_GAUCHE: {
                            insets.top = p.y * 2;
                            insets.right = p.x * 2;
                            break;
                        }
                        case HAUT_DROITE: {
                            insets.bottom = p.y * 2;
                            insets.left = p.x * 2;
                            break;
                        }
                        case HAUT_GAUCHE: {
                            insets.bottom = p.y * 2;
                            insets.right = p.x * 2;
                            break;
                        }
                    }
                    bounds.expand(insets);
                    if ((props.getOrigine() == Origine.BAS_DROITE || props.getOrigine() == Origine.HAUT_DROITE) && -bounds.x < clientArea.width) {
                        bounds.x = -clientArea.width;
                    }
                    if ((props.getOrigine() == Origine.BAS_DROITE || props.getOrigine() == Origine.BAS_GAUCHE) && -bounds.y < clientArea.height) {
                        bounds.y = -clientArea.height;
                    }
                }
                bounds.union(bounds.x, bounds.y, clientArea.width, clientArea.height);
                ff.setFreeformBounds(bounds);
                this.getVerticalRangeModel().setAll(bounds.y, clientArea.height, bounds.bottom());
                this.getHorizontalRangeModel().setAll(bounds.x, clientArea.width, bounds.right());
            }
        };
        this.innerLayers = new FreeformLayeredPane();
        this.createLayers(this.innerLayers);
        viewport.setContents((IFigure)this.innerLayers);
        return viewport;
    }

    protected void createLayers(LayeredPane layeredPane) {
        layeredPane.add((IFigure)this.getScaledLayers(), (Object)"Scalable Layers");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Handle Layer");
        layeredPane.add((IFigure)new FeedbackLayer(), (Object)"Feedback Layer");
        layeredPane.add((IFigure)new GuideLayer(), (Object)"Guide Layer");
    }

    protected ScalableFreeformLayeredPane createScaledLayers() {
        ScalableFreeformLayeredPane layers = new ScalableFreeformLayeredPane();
        layers.add((IFigure)this.createGridLayer(), (Object)"Grid Layer");
        layers.add((IFigure)this.getPrintableLayers(), (Object)"Printable Layers");
        layers.add((IFigure)new FeedbackLayer(), (Object)"Scaled Feedback Layer");
        return layers;
    }

    public IFigure getLayer(Object key) {
        Layer layer = this.scaledLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        if (this.innerLayers == null) {
            return null;
        }
        layer = this.innerLayers.getLayer(key);
        if (layer != null) {
            return layer;
        }
        if (this.printableLayers == null) {
            return null;
        }
        return this.printableLayers.getLayer(key);
    }

    protected LayeredPane getScaledLayers() {
        if (this.scaledLayers == null) {
            this.scaledLayers = this.createScaledLayers();
        }
        return this.scaledLayers;
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    class FeedbackLayer
    extends FreeformLayer {
        FeedbackLayer() {
            this.setEnabled(false);
        }
    }
}

