/*
 * Decompiled with CFR 0.152.
 */
package fr.inra.adonis.editeurgraphique.part;

import fr.inra.adonis.core.rcp.AdonisPropertySourceProvider;
import fr.inra.adonis.core.util.ColorUtil;
import fr.inra.adonis.core.util.DispositifUtil;
import fr.inra.adonis.editeurgraphique.EditorModeEnum;
import fr.inra.adonis.editeurgraphique.cheminement.editpolicy.AppConnectionPolicy;
import fr.inra.adonis.editeurgraphique.editpolicies.AdonisNonResizablePolicy;
import fr.inra.adonis.editeurgraphique.editpolicies.DeletePolicies;
import fr.inra.adonis.editeurgraphique.editpolicies.ObjEditLayoutPolicy;
import fr.inra.adonis.editeurgraphique.figure.FeuilleFigure;
import fr.inra.adonis.editeurgraphique.model.Connection;
import fr.inra.adonis.editeurgraphique.part.FeuillePart;
import fr.inra.adonis.editeurgraphique.part.NodePart;
import fr.inra.adonis.editeurgraphique.part.ObjetMetierDragTracker;
import fr.inra.adonis.editeurgraphique.tools.GraphicalProperties;
import fr.inra.adonis.modeleMetier.conceptsDeBase.ObjetMetier;
import fr.inra.adonis.modeleMetier.graphique.FlecheNord;
import fr.inra.adonis.modeleMetier.plateforme.Bloc;
import fr.inra.adonis.modeleMetier.plateforme.Dispositif;
import fr.inra.adonis.modeleMetier.plateforme.Individu;
import fr.inra.adonis.modeleMetier.plateforme.ParcelleUnitaire;
import fr.inra.adonis.modeleMetier.plateforme.Plateforme;
import fr.inra.adonis.modeleMetier.plateforme.PuIndividuel;
import fr.inra.adonis.modeleMetier.plateforme.PuSurfacique;
import fr.inra.adonis.modeleMetier.plateforme.SousBloc;
import fr.inra.adonis.modeleMetier.plateforme.TypeUniteParcours;
import fr.inra.adonis.modeleMetier.plateforme.UniteDeParcours;
import fr.inra.adonis.modeleMetier.plateforme.ZheAvecEpaisseur;
import fr.inra.adonis.modeleMetier.plateforme.ZoneHorsExperimentation;
import fr.inra.adonis.modeleMetier.saisieTerrain.MesureVariable;
import fr.inra.adonis.modeleMetier.saisieTerrain.Saisie;
import fr.inra.adonis.modeleMetier.saisieTerrain.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class ObjetMetierPart
extends AbstractGraphicalEditPart
implements NodeEditPart {
    private static boolean waitForRefresh = false;
    protected ConnectionAnchor anchor;
    private final List<Connection> sourceConnections = new ArrayList<Connection>();
    private final List<Connection> targetConnections = new ArrayList<Connection>();
    private Image currentImage;
    private boolean disablePart = false;
    protected AdapterImpl adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            ObjetMetierPart.this.propertyChanged(notification);
        }
    };

    public boolean isDisablePart() {
        return this.disablePart;
    }

    public void setDisablePart(boolean disablePart) {
        if (disablePart != this.disablePart) {
            this.disablePart = disablePart;
            this.refreshVisuals();
        }
    }

    public static boolean waitForRefresh() {
        return waitForRefresh;
    }

    public static void setWaitForRefresh(boolean waitForRefresh) {
        ObjetMetierPart.waitForRefresh = waitForRefresh;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new AdonisNonResizablePolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ObjEditLayoutPolicy());
        if (this.getViewer().getProperty("editorMode") == EditorModeEnum.EDITION_PLATEFORME) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeletePolicies(null));
        }
        if (this.getViewer().getProperty("editorMode") == EditorModeEnum.CREATION_CHEMINEMENT) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new AppConnectionPolicy());
        }
    }

    protected void setVisibility(Figure figure) {
        Collection objectsToDisplay;
        ObjetMetier objMetier = (ObjetMetier)this.getModel();
        Object objects = null;
        if (objMetier instanceof Individu) {
            objects = this.getViewer().getProperty("indsToDisplay");
        } else if (objMetier instanceof ParcelleUnitaire) {
            objects = this.getViewer().getProperty("pusToDisplay");
        } else if (objMetier instanceof SousBloc) {
            objects = this.getViewer().getProperty("ssblocsToDisplay");
        } else if (objMetier instanceof Bloc) {
            objects = this.getViewer().getProperty("blocsToDisplay");
        } else if (objMetier instanceof Dispositif) {
            objects = this.getViewer().getProperty("disposToDisplay");
        }
        if (objects != null && !(objectsToDisplay = (Collection)objects).contains(objMetier)) {
            figure.setVisible(false);
            return;
        }
        Object layers = this.getViewer().getProperty("layersToDisplay");
        if (layers != null) {
            List layersToDisplay = (List)layers;
            TypeUniteParcours unite = DispositifUtil.getTypeUniteParcours((ObjetMetier)objMetier);
            if (unite != null && !layersToDisplay.contains(unite)) {
                figure.setVisible(false);
                return;
            }
        }
        figure.setVisible(true);
    }

    public void refreshVisuals() {
        super.refreshVisuals();
    }

    public List<Connection> getModelSourceConnections() {
        return this.sourceConnections;
    }

    public List<Connection> getModelTargetConnections() {
        return this.targetConnections;
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new ChopboxAnchor(this.getFigure());
        }
        return this.anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            if (!this.sourceConnections.contains(conn)) {
                this.sourceConnections.add(conn);
                this.refreshSourceConnections();
            }
        } else if (conn.getTarget() == this && !this.targetConnections.contains(conn)) {
            this.targetConnections.add(conn);
            this.refreshTargetConnections();
        }
    }

    public void removeConnection(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.remove(conn);
            this.refreshSourceConnections();
        } else if (conn.getTarget() == this) {
            this.targetConnections.remove(conn);
            this.refreshTargetConnections();
        }
    }

    protected List<FeuillePart> getChildrenRec() {
        ArrayList<FeuillePart> result = new ArrayList<FeuillePart>();
        for (Object child : this.getChildren()) {
            if (child instanceof FeuillePart) {
                result.add((FeuillePart)((Object)child));
                continue;
            }
            if (!(child instanceof NodePart)) continue;
            result.addAll(((NodePart)((Object)child)).getChildrenRec());
        }
        return result;
    }

    public List getModelChildren() {
        ObjetMetier model = (ObjetMetier)this.getModel();
        ArrayList<FlecheNord> children = new ArrayList<FlecheNord>();
        if (model instanceof PuIndividuel) {
            children.addAll((Collection<FlecheNord>)((PuIndividuel)model).getIndividus());
        } else if (model instanceof SousBloc) {
            children.addAll((Collection<FlecheNord>)((SousBloc)model).getParcellesUnitaire());
        } else if (model instanceof Bloc) {
            children.addAll((Collection<FlecheNord>)((Bloc)model).getSousBlocs());
            children.addAll((Collection<FlecheNord>)((Bloc)model).getParcellesUnitaire());
        } else if (model instanceof Dispositif) {
            children.addAll((Collection<FlecheNord>)((Dispositif)model).getBlocs());
        } else if (model instanceof Plateforme) {
            children.addAll((Collection<FlecheNord>)((Plateforme)model).getDispositifs());
            children.addAll((Collection<FlecheNord>)((Plateforme)model).getZonesDeTexte());
            if (((Plateforme)model).getFlecheNord() != null) {
                children.add(((Plateforme)model).getFlecheNord());
            }
        }
        if (model instanceof UniteDeParcours) {
            children.addAll((Collection<FlecheNord>)((UniteDeParcours)model).getZheAvecEpaisseurs());
        }
        return children;
    }

    public String getLabel() {
        ObjetMetier model = (ObjetMetier)this.getModel();
        GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
        if (model instanceof ZheAvecEpaisseur) {
            return properties.getZheLabel((ZheAvecEpaisseur)model);
        }
        Object layers = this.getViewer().getProperty("layersToDisplay");
        if (layers != null) {
            List layersToDisplay = (List)layers;
            if (layersToDisplay.contains(TypeUniteParcours.INDIVIDU)) {
                if (model instanceof Individu) {
                    return properties.getIndividuLabel((Individu)model);
                }
                if (model instanceof PuSurfacique) {
                    return properties.getParcelleLabel((ParcelleUnitaire)model);
                }
            } else if (layersToDisplay.contains(TypeUniteParcours.PARCELLE)) {
                if (model instanceof ParcelleUnitaire) {
                    return properties.getParcelleLabel((ParcelleUnitaire)model);
                }
            } else if (layersToDisplay.contains(TypeUniteParcours.SOUS_BLOC)) {
                if (model instanceof SousBloc) {
                    return properties.getSousBlocLabel((SousBloc)model);
                }
            } else if (layersToDisplay.contains(TypeUniteParcours.BLOC)) {
                if (model instanceof Bloc) {
                    return properties.getBlocLabel((Bloc)model);
                }
            } else if (layersToDisplay.contains(TypeUniteParcours.DISPOSITIF) && model instanceof Dispositif) {
                return properties.getDispositifLabel((Dispositif)model);
            }
        } else {
            if (model instanceof Individu) {
                return properties.getIndividuLabel((Individu)model);
            }
            if (model instanceof PuSurfacique) {
                return properties.getParcelleLabel((ParcelleUnitaire)model);
            }
        }
        return "";
    }

    public Image getTexture() {
        Image t = null;
        if (this.currentImage != null) {
            return this.currentImage;
        }
        ObjetMetier model = (ObjetMetier)this.getModel();
        GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
        if (model instanceof Plateforme) {
            t = properties.getPlateformeTexture((Plateforme)model);
        } else if (model instanceof Dispositif) {
            t = properties.getDispositifTexture((Dispositif)model);
        } else if (model instanceof Bloc) {
            t = properties.getBlocTexture((Bloc)model);
        } else if (model instanceof SousBloc) {
            t = properties.getSousBlocTexture((SousBloc)model);
        } else if (model instanceof ParcelleUnitaire) {
            t = properties.getParcelleTexture((ParcelleUnitaire)model);
        } else if (model instanceof Individu) {
            t = properties.getIndividuTexture((Individu)model);
        } else if (model instanceof ZheAvecEpaisseur) {
            ZheAvecEpaisseur zhe = (ZheAvecEpaisseur)model;
            if (zhe.getTexture() != null) {
                t = ColorUtil.getTexture((String)zhe.getTexture());
            } else if (zhe.getNatureZhe() != null && zhe.getNatureZhe().getTexture() != null) {
                t = ColorUtil.getTexture((String)zhe.getNatureZhe().getTexture());
            }
        }
        return t;
    }

    public Color getColor() {
        Color c = ColorConstants.white;
        if (this.disablePart) {
            c = ColorConstants.lightGray;
        } else {
            ObjetMetier model = (ObjetMetier)this.getModel();
            try {
                GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
                c = properties.getObjetMetierBackgroundColor(model);
                Saisie saisie = (Saisie)this.getViewer().getProperty("saisie");
                HashSet<ObjetMetier> objetsDejaTraites = new HashSet<ObjetMetier>();
                if (saisie != null && !(model instanceof ZoneHorsExperimentation)) {
                    for (Session session : saisie.getSessions()) {
                        for (MesureVariable mv : session.getMesureVariables()) {
                            if (objetsDejaTraites.contains(mv.getObjetMetier())) continue;
                            if (DispositifUtil.getParent((ObjetMetier)mv.getObjetMetier(), model.getClass()) == model) {
                                return c;
                            }
                            objetsDejaTraites.add(mv.getObjetMetier());
                        }
                    }
                    c = ColorConstants.lightGray;
                }
            }
            catch (Exception exception) {}
        }
        return c;
    }

    protected int getFacteurFont() {
        GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
        return properties.getFacteurFont();
    }

    public static int getShrinkValue(ObjetMetier model) {
        int shrinkValue = 0;
        if (model instanceof ZheAvecEpaisseur) {
            shrinkValue = 12;
        } else if (model instanceof Individu) {
            shrinkValue = 12;
        } else if (model instanceof ParcelleUnitaire) {
            shrinkValue = 10;
        } else if (model instanceof SousBloc) {
            shrinkValue = 8;
        } else if (model instanceof Bloc) {
            shrinkValue = 6;
        } else if (model instanceof Dispositif) {
            shrinkValue = 2;
        } else if (model instanceof Plateforme) {
            shrinkValue = 0;
        }
        return shrinkValue;
    }

    public Object getAdapter(Class key) {
        if (key == IPropertySource.class) {
            return AdonisPropertySourceProvider.getInstance().getPropertySource(this.getModel());
        }
        if (key == ObjetMetier.class) {
            return this.getModel();
        }
        return super.getAdapter(key);
    }

    public void showTargetFeedback(Request request) {
        if (this.getParent() == null || this.getRoot() == null || this.getViewer() == null) {
            return;
        }
        GraphicalProperties properties = (GraphicalProperties)this.getViewer().getProperty("graphicalProperties");
        if (properties != null && properties.isTooltipsActive()) {
            super.showTargetFeedback(request);
            Label tooltip = (Label)this.getFigure().getToolTip();
            if (tooltip == null) {
                tooltip = new Label();
                this.getFigure().setToolTip((IFigure)tooltip);
            }
            ObjetMetier model = (ObjetMetier)this.getModel();
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(model.getClass().getSimpleName());
            strBuffer.append(" ");
            if (model instanceof Plateforme) {
                strBuffer.append(properties.getPlateformeLabel((Plateforme)model));
            } else if (model instanceof Dispositif) {
                strBuffer.append(properties.getDispositifTooltip((Dispositif)model));
            } else if (model instanceof Bloc) {
                strBuffer.append(properties.getBlocTooltip((Bloc)model));
            } else if (model instanceof SousBloc) {
                strBuffer.append(properties.getSousBlocTooltip((SousBloc)model));
            } else if (model instanceof ParcelleUnitaire) {
                strBuffer.append(properties.getParcelleTooltip((ParcelleUnitaire)model));
            } else if (model instanceof Individu) {
                strBuffer.append(properties.getIndividuTooltip((Individu)model));
            } else if (model instanceof ZheAvecEpaisseur) {
                strBuffer.append(properties.getZheLabel((ZheAvecEpaisseur)model));
            }
            tooltip.setText(strBuffer.toString());
        }
    }

    protected abstract void propertyChanged(Notification var1);

    public void activate() {
        super.activate();
        ObjetMetier og = (ObjetMetier)this.getModel();
        if (og != null) {
            og.eAdapters().add((Object)this.adapter);
        }
    }

    public void deactivate() {
        ObjetMetier og = (ObjetMetier)this.getModel();
        if (og != null) {
            og.eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    public void setImage(Image image) {
        this.currentImage = image;
        if (this.getFigure() instanceof FeuilleFigure) {
            ((FeuilleFigure)this.getFigure()).setImage(this.currentImage);
        }
        this.getFigure().repaint();
    }

    public void setLabel(String label) {
        if (this.getFigure() instanceof FeuilleFigure) {
            ((FeuilleFigure)this.getFigure()).setLabel(label);
        }
        this.getFigure().repaint();
    }

    public DragTracker getDragTracker(Request request) {
        this.getViewer().setProperty("shiftPressed", (Object)false);
        return new ObjetMetierDragTracker((EditPart)this);
    }

    public void removeAllConnections() {
        this.sourceConnections.clear();
        this.targetConnections.clear();
        for (Object fils : this.getChildren()) {
            if (!(fils instanceof ObjetMetierPart)) continue;
            ((ObjetMetierPart)((Object)fils)).removeAllConnections();
        }
    }
}

